package com.bringspring.system.print.model;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

@Data
@Schema(description = "打印模板详情")
public class PrintDevInfoVO {

    @Schema(description = "模板id")
    private String id;

    @Schema(description = "版本id")
    private String versionId;

    @Schema(description = "名称")
    private String fullName;

    @Schema(description = "编码")
    private String enCode;

    @Schema(description = "分类")
    private String category;

    @Schema(description = "类型")
    private Integer type;

    @Schema(description = "连接数据_id")
    private String dbLinkId;

    @Schema(description = "sql语句")
    private String sqlTemplate;

    @Schema(description = "左侧字段")
    private String leftFields;

    @Schema(description = "打印模板")
    private String printTemplate;

    @Schema(description = "说明")
    private String description;

    @Schema(description = "排序")
    private Long sortCode;

    @Schema(description = "有效标志")
    private Integer enabledMark;

    @Schema(description = "创建时间")
    private Long creatorTime;

    @Schema(description = "创建用户_id")
    private String creatorUserId;


    @Schema(description = "修改时间")
    private Long lastModifyTime;

    @Schema(description = "修改用户_id")
    private String lastModifyUserId;

    @Schema(description = "删除标志")
    private Integer deleteMark;

    @Schema(description = "删除时间")
    private Long deleteTime;

    @Schema(description = "删除用户_id")
    private String deleteUserId;
}
