package com.bringspring.system.print.util;

import com.bringspring.system.print.enums.ResultColumnKeysEnum;
import com.bringspring.system.print.model.PrintFieldModel;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/**
 * 打印模板-工具类
 *
 * @author RKKJ开发平台组 YY
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月30日
 */
public class PrintDevUtil {

    public static List<PrintFieldModel> getColumnInfo(Connection conn,String table){
        List<PrintFieldModel> printFieldModelList = new ArrayList<>();
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            ResultSet rs = metaData.getColumns(conn.getCatalog(), "%", table, "%");
            while (rs.next()) {
                PrintFieldModel printFieldModel = new PrintFieldModel();
                //列名称：
                printFieldModel.setColumnName(rs.getString(ResultColumnKeysEnum.COLUMN_NAME.name()));
                //java.sql.Types
                printFieldModel.setDataType(rs.getString(ResultColumnKeysEnum.DATA_TYPE.name()));
                //字段类型：
                printFieldModel.setTypeName(rs.getString(ResultColumnKeysEnum.TYPE_NAME.name()));
                //列的大小：
                printFieldModel.setColumnSize(rs.getString(ResultColumnKeysEnum.COLUMN_SIZE.name()));
                //小数部分的位数：
                printFieldModel.setDecimalDigits(rs.getString(ResultColumnKeysEnum.DECIMAL_DIGITS.name()));
                //基数：
                printFieldModel.setNumPrecRadix(rs.getString(ResultColumnKeysEnum.NUM_PREC_RADIX.name()));
                //描述列的注释：
                printFieldModel.setReMarks(rs.getString(ResultColumnKeysEnum.REMARKS.name()));
                //该列的默认值：
                printFieldModel.setColumnDef(rs.getString(ResultColumnKeysEnum.COLUMN_DEF.name()));
                //列中的最大字节数：
                printFieldModel.setCharOctetLength(rs.getString(ResultColumnKeysEnum.CHAR_OCTET_LENGTH.name()));
                //列的索引：
                printFieldModel.setOrdinalPosition(rs.getString(ResultColumnKeysEnum.ORDINAL_POSITION.name()));
                //是否允许使用 NULL：
                printFieldModel.setIsNullAble(rs.getString(ResultColumnKeysEnum.IS_NULLABLE.name()));
                //指示此列是否自动增加：
                printFieldModel.setIsAutoIncrement(rs.getString(ResultColumnKeysEnum.IS_AUTOINCREMENT.name()));
                printFieldModelList.add(printFieldModel);
            }
            rs.close();
        } catch (SQLException e) {
            throw new RuntimeException("表信息抽取异常！", e);
        }
        return printFieldModelList;
    }

    public static String compareGetColumnComment(Connection conn,String table,String columnName){
        List<PrintFieldModel> columnList = getColumnInfo(conn,table);
        for(PrintFieldModel printFieldModel : columnList){
            if(printFieldModel.getColumnName().equalsIgnoreCase(columnName)){
                return printFieldModel.getReMarks();
            }
        }
        return null;
    }

}
