/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.base.entity.DataInterfaceLogEntity;
import com.bringspring.system.base.model.dataInterface.DataInterfaceLogVO;
import com.bringspring.system.base.service.DataInterfaceLogService;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u6570\u636e\u63a5\u53e3\u8c03\u7528\u65e5\u5fd7")
@RestController
@RequestMapping(value={"/api/system/DataInterfaceLog"})
public class DataInterfaceLogController {
    @Autowired
    private DataInterfaceLogService dataInterfaceLogService;
    @Autowired
    private UserService userService;

    @Operation(summary="\u83b7\u53d6\u6570\u636e\u63a5\u53e3\u8c03\u7528\u65e5\u5fd7\u5217\u8868")
    @GetMapping(value={"{id}"})
    public ActionResult getList(@PathVariable(value="id") String id, Pagination pagination) {
        List<DataInterfaceLogEntity> list = this.dataInterfaceLogService.getList(id, pagination);
        List voList = JsonUtil.getJsonToList(list, DataInterfaceLogVO.class);
        for (DataInterfaceLogVO vo : voList) {
            UserEntity entity = this.userService.getInfo(vo.getUserId());
            if (entity == null) continue;
            vo.setUserId(entity.getRealName());
        }
        PaginationVO vo = (PaginationVO)JsonUtil.getJsonToBean((Object)pagination, PaginationVO.class);
        return ActionResult.page((List)voList, (PaginationVO)vo);
    }
}

