/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Page;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.model.DbTableDataForm;
import com.bringspring.common.database.model.DbTableFieldModel;
import com.bringspring.common.database.model.DbTableModel;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.enums.ModuleTypeEnum;
import com.bringspring.common.util.file.FileExport;
import com.bringspring.system.base.model.dbtable.DbTableCreate;
import com.bringspring.system.base.model.dbtable.DbTableForm;
import com.bringspring.system.base.model.dbtable.DbTableUpdate;
import com.bringspring.system.base.model.dbtable.vo.DbTableFieldSeleVO;
import com.bringspring.system.base.model.dbtable.vo.DbTableFieldVO;
import com.bringspring.system.base.model.dbtable.vo.DbTableInfoVO;
import com.bringspring.system.base.model.dbtable.vo.DbTableVO;
import com.bringspring.system.base.service.DbTableService;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.print.entity.PrintDevEntity;
import com.google.common.base.CaseFormat;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="\u6570\u636e\u5efa\u6a21")
@RestController
@RequestMapping(value={"/api/system/DataModel"})
public class DbTableController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DbTableController.class);
    @Autowired
    private DbTableService dbTableService;
    @Autowired
    private FileExport fileExport;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @Operation(summary="\u83b7\u53d6\u6570\u636e\u5e93\u8868\u5217\u8868")
    @GetMapping(value={"/{id}/Tables"})
    public ActionResult<ListVO<DbTableModel>> getList(@PathVariable(value="id") String id, Page page) throws DataException {
        String escape = XSSEscape.escape((String)id);
        List data = this.dbTableService.getList(escape).stream().filter(t -> StringUtils.isNotEmpty((String)page.getKeyword()) ? t.getDescription().toLowerCase().contains(page.getKeyword().toLowerCase()) || t.getTable().toLowerCase().contains(page.getKeyword().toLowerCase()) : t.getTable() != null).sorted(Comparator.comparing(DbTableModel::getTable)).collect(Collectors.toList());
        ListVO vo = new ListVO();
        vo.setList(data);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u9884\u89c8\u6570\u636e\u5e93\u8868")
    @GetMapping(value={"/{linkId}/Table/{tableName}/Preview"})
    public ActionResult<PageListVO<Map<String, Object>>> data(DbTableDataForm dbTableDataForm, @PathVariable(value="linkId") String linkId, @PathVariable(value="tableName") String tableName) throws Exception {
        String escape = XSSEscape.escape((String)linkId);
        String escapeTableName = XSSEscape.escape((String)tableName);
        List<Map<String, Object>> data = this.dbTableService.getData(dbTableDataForm, escape, escapeTableName);
        PaginationVO paginationVO = JsonUtilEx.getJsonToBeanEx(dbTableDataForm, PaginationVO.class);
        return ActionResult.page(data, (PaginationVO)paginationVO);
    }

    @GetMapping(value={"/{linkId}/Tables/{tableName}/Fields/Selector"})
    @Operation(summary="\u83b7\u53d6\u6570\u636e\u5e93\u8868\u5b57\u6bb5\u4e0b\u62c9\u6846\u5217\u8868")
    public ActionResult<ListVO<DbTableFieldSeleVO>> selectorList(@PathVariable(value="linkId") String linkId, @PathVariable(value="tableName") String tableName) throws DataException {
        List<DbTableFieldModel> data = this.dbTableService.getFieldList(linkId, tableName);
        List vos = JsonUtil.getJsonToList(data, DbTableFieldSeleVO.class);
        ListVO vo = new ListVO();
        vo.setList(vos);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u83b7\u53d6\u6570\u636e\u5e93\u8868\u5b57\u6bb5\u5217\u8868")
    @GetMapping(value={"/{linkId}/Tables/{tableName}/Fields"})
    public ActionResult<ListVO<DbTableFieldVO>> fieldList(@PathVariable(value="linkId") String linkId, @PathVariable(value="tableName") String tableName, @RequestParam(value="type", required=false) String type) throws DataException {
        List<DbTableFieldModel> data = this.dbTableService.getFieldList(linkId, tableName);
        List vos = JsonUtil.getJsonToList(data, DbTableFieldVO.class);
        for (DbTableFieldVO vo : vos) {
            if (!"1".equals(type)) continue;
            String name = vo.getField().toLowerCase().replaceAll("f_", "");
            vo.setField(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name));
        }
        ListVO vo = new ListVO();
        vo.setList(vos);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u83b7\u53d6\u6570\u636e\u8868")
    @GetMapping(value={"/{linkId}/Table/{tableName}"})
    public ActionResult<DbTableVO> get(@PathVariable(value="linkId") String linkId, @PathVariable(value="tableName") String tableName) throws DataException {
        return ActionResult.success((Object)this.getDbTable(linkId, tableName));
    }

    private DbTableVO getDbTable(String linkId, String tableName) throws DataException {
        DbTableModel dbTableModel = this.dbTableService.getList(linkId).stream().filter(m -> m.getTable().equals(tableName)).findFirst().orElse(null);
        DbTableVO dbTableVO = new DbTableVO();
        if (dbTableModel != null) {
            DbTableInfoVO tableInfo = JsonUtilEx.getJsonToBeanEx(dbTableModel, DbTableInfoVO.class);
            List<DbTableFieldModel> tableFieldList = this.dbTableService.getFieldList(linkId, tableName);
            List fieldList = JsonUtil.getJsonToList(tableFieldList, DbTableFieldVO.class);
            dbTableVO.setTableFieldList(fieldList);
            dbTableVO.setTableInfo(tableInfo);
        }
        return dbTableVO;
    }

    @Operation(summary="\u65b0\u5efa")
    @PostMapping(value={"{linkId}/Table"})
    public ActionResult<String> create(@PathVariable(value="linkId") String linkId, @RequestBody @Valid DbTableCreate dbTableCreate) throws DataException {
        dbTableCreate.initCreate(linkId);
        int status = this.dbTableService.createTable(dbTableCreate);
        if (status == 1) {
            return ActionResult.success((String)MsgCode.SU001.get());
        }
        if (status == 0) {
            return ActionResult.fail((String)"\u8868\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        return ActionResult.fail((String)"\u6dfb\u52a0\u5931\u8d25");
    }

    @Operation(summary="\u66f4\u65b0")
    @PutMapping(value={"/{linkId}/Table"})
    public ActionResult<String> update(@PathVariable(value="linkId") String linkId, @RequestBody @Valid DbTableUpdate dbTableUpdate) throws DataException {
        dbTableUpdate.initUpdate(linkId);
        String newTable = dbTableUpdate.getNewTable();
        String oldTable = dbTableUpdate.getOldTable();
        if (!newTable.equals(oldTable) && this.dbTableService.isExistByTableName(linkId, newTable)) {
            return ActionResult.fail((String)"\u8868\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        this.dbTableService.update(dbTableUpdate);
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @Operation(summary="\u5220\u9664")
    @DeleteMapping(value={"/{linkId}/Table/{tableName}"})
    public ActionResult<String> delete(@PathVariable(value="linkId") String linkId, @PathVariable(value="tableName") String tableName) throws DataException {
        this.dbTableService.delete(linkId, tableName);
        return ActionResult.success((String)MsgCode.SU003.get());
    }

    @Operation(summary="\u5bfc\u5165")
    @PostMapping(value={"/{linkId}/Action/Import"}, consumes={"multipart/form-data"})
    public ActionResult<PageListVO<PrintDevEntity>> importData(@PathVariable(value="linkId") String linkId, @RequestPart(value="file") MultipartFile multipartFile) throws DataException {
        if (FileUtil.existsSuffix((MultipartFile)multipartFile, (String)ModuleTypeEnum.SYSTEM_DBTABLE.getTableName())) {
            return ActionResult.fail((String)MsgCode.IMP002.get());
        }
        String fileContent = FileUtil.getFileContent((MultipartFile)multipartFile, (String)this.configValueUtil.getTemporaryFilePath());
        try {
            DbTableVO dbTableVO = (DbTableVO)JsonUtil.getJsonToBean((String)fileContent, DbTableVO.class);
            String tableName = dbTableVO.getTableInfo().getTable();
            if (this.dbTableService.isExistByTableName(linkId, tableName)) {
                return ActionResult.fail((String)"\u8868\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
            }
            DbTableCreate dbTableCreate = new DbTableCreate();
            BeanUtils.copyProperties((Object)dbTableVO, (Object)dbTableCreate);
            DbTableForm dbTableForm = new DbTableForm();
            dbTableCreate.setDbLinkId(linkId);
            dbTableForm.setNewTable(tableName);
            dbTableForm.setTableName(tableName);
            dbTableCreate.setTableInfo(dbTableForm);
            dbTableCreate.initCreate(linkId);
            int i = this.dbTableService.createTable(dbTableCreate);
            if (i == 1) {
                return ActionResult.success((String)MsgCode.IMP001.get());
            }
            return ActionResult.success((String)"\u6570\u636e\u5e93\u8868\u540d\u91cd\u590d");
        }
        catch (Exception e) {
            throw new DataException(MsgCode.IMP004.get());
        }
    }

    @Operation(summary="\u5bfc\u51fa")
    @GetMapping(value={"/{linkId}/Table/{tableName}/Action/Export"})
    public ActionResult<DownloadVO> export(@PathVariable(value="linkId") String linkId, @PathVariable(value="tableName") String tableName) {
        DownloadVO downloadVO = null;
        try {
            DbTableVO dbTable = this.getDbTable(linkId, tableName);
            downloadVO = this.fileExport.exportFile((Object)dbTable, this.configValueUtil.getTemporaryFilePath(), dbTable.getTableInfo().getTable() + "_", ModuleTypeEnum.SYSTEM_DBTABLE.getTableName());
        }
        catch (DataException e) {
            e.printStackTrace();
        }
        return ActionResult.success(downloadVO);
    }
}

