/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.SmsModel;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.sms.util.message.SmsUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.base.entity.MessageTemplateEntity;
import com.bringspring.system.base.entity.SmsTemplateEntity;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.model.messagetemplate.MessageTemplateCrForm;
import com.bringspring.system.base.model.messagetemplate.MessageTemplateListVO;
import com.bringspring.system.base.model.messagetemplate.MessageTemplateSelector;
import com.bringspring.system.base.model.messagetemplate.MessageTemplateUpForm;
import com.bringspring.system.base.model.messagetemplate.MessageTemplateVO;
import com.bringspring.system.base.service.MessageTemplateService;
import com.bringspring.system.base.service.SmsTemplateService;
import com.bringspring.system.message.model.message.SentMessageForm;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u6d88\u606f\u6a21\u677f\u63a7\u5236\u7c7b")
@RestController
@RequestMapping(value={"/api/system/MessageTemplate"})
public class MessageTemplateController {
    @Autowired
    private MessageTemplateService messageTemplateService;
    @Autowired
    private SmsTemplateService smsTemplateService;
    @Autowired
    private UserService userService;

    @Operation(summary="\u6d88\u606f\u6a21\u677f\u5217\u8868")
    @GetMapping
    public ActionResult<PageListVO<MessageTemplateListVO>> list(Pagination pagination) {
        List<MessageTemplateEntity> list = this.messageTemplateService.getList(pagination);
        List listVO = JsonUtil.getJsonToList(list, MessageTemplateListVO.class);
        for (MessageTemplateListVO messageTemplateListVO : listVO) {
            StringBuffer noticeMethod = new StringBuffer();
            if (messageTemplateListVO.getIsDingTalk() == 1) {
                noticeMethod.append("\u3001\u963f\u91cc\u9489\u9489");
            }
            if (messageTemplateListVO.getIsEmail() == 1) {
                noticeMethod.append("\u3001\u7535\u5b50\u90ae\u7bb1");
            }
            if (messageTemplateListVO.getIsSms() == 1) {
                noticeMethod.append("\u3001\u77ed\u4fe1");
            }
            if (messageTemplateListVO.getIsStationLetter() == 1) {
                noticeMethod.append("\u3001\u7ad9\u5185\u4fe1");
            }
            if (messageTemplateListVO.getIsWecom() == 1) {
                noticeMethod.append("\u3001\u4f01\u4e1a\u5fae\u4fe1");
            }
            if (noticeMethod.length() > 0) {
                messageTemplateListVO.setNoticeMethod(noticeMethod.toString().replaceFirst("\u3001", ""));
            }
            if ("1".equals(messageTemplateListVO.getCategory())) {
                messageTemplateListVO.setCategory("\u666e\u901a");
            } else if ("2".equals(messageTemplateListVO.getCategory())) {
                messageTemplateListVO.setCategory("\u91cd\u8981");
            } else if ("3".equals(messageTemplateListVO.getCategory())) {
                messageTemplateListVO.setCategory("\u7d27\u6025");
            }
            UserEntity entity = this.userService.getInfo(messageTemplateListVO.getCreatorUserId());
            messageTemplateListVO.setCreatorUserId(entity != null ? entity.getRealName() : null);
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)pagination, PaginationVO.class);
        return ActionResult.page((List)listVO, (PaginationVO)paginationVO);
    }

    @Operation(summary="\u6d88\u606f\u6a21\u677f\u4e0b\u62c9\u6846")
    @GetMapping(value={"/Selector"})
    public ActionResult<PageListVO<MessageTemplateSelector>> selector(Pagination pagination) {
        List<MessageTemplateEntity> list = this.messageTemplateService.getSelector(pagination);
        for (MessageTemplateEntity entity : list) {
            if ("1".equals(entity.getCategory())) {
                entity.setCategory("\u666e\u901a");
                continue;
            }
            if ("2".equals(entity.getCategory())) {
                entity.setCategory("\u91cd\u8981");
                continue;
            }
            if (!"3".equals(entity.getCategory())) continue;
            entity.setCategory("\u7d27\u6025");
        }
        List jsonToList = JsonUtil.getJsonToList(list, MessageTemplateSelector.class);
        ListVO listVO = new ListVO();
        listVO.setList(jsonToList);
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)pagination, PaginationVO.class);
        return ActionResult.page((List)jsonToList, (PaginationVO)paginationVO);
    }

    @Operation(summary="\u83b7\u53d6\u6d88\u606f\u6a21\u677f")
    @GetMapping(value={"/{id}"})
    public ActionResult<MessageTemplateVO> info(@PathVariable(value="id") String id) {
        MessageTemplateVO vo;
        MessageTemplateEntity entity = this.messageTemplateService.getInfo(id);
        SmsTemplateEntity info = this.smsTemplateService.getInfo((vo = (MessageTemplateVO)JsonUtil.getJsonToBean((Object)entity, MessageTemplateVO.class)).getSmsId());
        vo.setSmsTemplateName(info != null ? info.getFullName() : null);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u83b7\u53d6\u6d88\u606f\u6a21\u677f\u53c2\u6570")
    @GetMapping(value={"/getTemplate/{id}"})
    public ActionResult<?> getParameter(@PathVariable(value="id") String id) {
        MessageTemplateEntity entity = this.messageTemplateService.getInfo(id);
        if (entity == null) {
            return ActionResult.fail((String)"\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        String templateJson = entity.getTemplateJson();
        Map map = JsonUtil.stringToMap((String)templateJson);
        if (entity.getIsSms() == 1) {
            SmsModel smsModel = this.smsTemplateService.getSmsConfig();
            String smsId = entity.getSmsId();
            SmsTemplateEntity info = this.smsTemplateService.getInfo(smsId);
            List list = SmsUtil.querySmsTemplateRequest((Integer)info.getCompany(), (SmsModel)smsModel, (String)info.getEndpoint(), (String)info.getRegion(), (String)info.getTemplateId());
            for (String key : list) {
                map.put(key, null);
            }
        }
        return ActionResult.success((Object)map);
    }

    @Operation(summary="\u65b0\u5efa")
    @PostMapping
    public ActionResult<String> create(@RequestBody @Valid MessageTemplateCrForm messageTemplateCrForm) {
        MessageTemplateEntity entity = (MessageTemplateEntity)JsonUtil.getJsonToBean((Object)messageTemplateCrForm, MessageTemplateEntity.class);
        if (this.messageTemplateService.isExistByFullName(entity.getFullName(), entity.getId())) {
            return ActionResult.fail((String)"\u65b0\u5efa\u5931\u8d25\uff0c\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        if (this.messageTemplateService.isExistByEnCode(entity.getEnCode(), entity.getId())) {
            return ActionResult.fail((String)"\u65b0\u5efa\u5931\u8d25\uff0c\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        this.messageTemplateService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @Operation(summary="\u4fee\u6539")
    @PutMapping(value={"/{id}"})
    public ActionResult<String> update(@PathVariable(value="id") String id, @RequestBody @Valid MessageTemplateUpForm messageTemplateUpForm) {
        MessageTemplateEntity entity = (MessageTemplateEntity)JsonUtil.getJsonToBean((Object)messageTemplateUpForm, MessageTemplateEntity.class);
        if (entity != null) {
            if (this.messageTemplateService.isExistByFullName(entity.getFullName(), id)) {
                return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
            }
            if (this.messageTemplateService.isExistByEnCode(entity.getEnCode(), id)) {
                return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
            }
            boolean flag = this.messageTemplateService.update(id, entity);
            if (!flag) {
                return ActionResult.fail((String)MsgCode.FA002.get());
            }
            return ActionResult.success((String)MsgCode.SU004.get());
        }
        return ActionResult.fail((String)MsgCode.FA002.get());
    }

    @Operation(summary="\u5220\u9664")
    @DeleteMapping(value={"/{id}"})
    public ActionResult<String> delete(@PathVariable(value="id") String id) {
        MessageTemplateEntity entity = this.messageTemplateService.getInfo(id);
        if (entity == null) {
            return ActionResult.fail((String)MsgCode.FA003.get());
        }
        this.messageTemplateService.delete(entity);
        return ActionResult.success((String)MsgCode.SU003.get());
    }

    @Operation(summary="\u4fee\u6539\u72b6\u6001")
    @PutMapping(value={"/{id}/Actions/State"})
    public ActionResult<String> update(@PathVariable(value="id") String id) {
        MessageTemplateEntity entity = this.messageTemplateService.getInfo(id);
        if (entity != null) {
            if (entity.getEnabledMark() == 0) {
                entity.setEnabledMark(1);
            } else {
                entity.setEnabledMark(0);
            }
            boolean flag = this.messageTemplateService.update(id, entity);
            if (!flag) {
                return ActionResult.fail((String)MsgCode.FA002.get());
            }
            return ActionResult.success((String)MsgCode.SU004.get());
        }
        return ActionResult.success((String)MsgCode.FA002.get());
    }

    @Operation(summary="\u6d4b\u8bd5\u53d1\u9001\u6d88\u606f")
    @PostMapping(value={"/sendMessage"})
    public ActionResult<String> sendMessage(@RequestBody @Valid SentMessageForm messageTemplateCrForm) throws Exception {
        this.messageTemplateService.testSendMessage(messageTemplateCrForm);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @GetMapping(value={"/getMessageTemplateByEncode/{enCode}"})
    public ActionResult getMessageTemplateByEncode(@PathVariable(value="enCode") String enCode) throws BaseException {
        MessageTemplateEntity messageTemplateByEncode = this.messageTemplateService.getMessageTemplateByEncode(enCode);
        return ActionResult.success((Object)messageTemplateByEncode);
    }
}

