/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.systemconfig.EmailTestForm;
import com.bringspring.common.base.systemconfig.SysConfigListVO;
import com.bringspring.common.base.systemconfig.SysConfigModel;
import com.bringspring.common.base.systemconfig.SysConfigModelNew;
import com.bringspring.common.base.systemconfig.SysConfigVo;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.model.login.BaseSystemInfo;
import com.bringspring.common.model.login.SystemInfo;
import com.bringspring.common.sms.util.third.DingTalkUtil;
import com.bringspring.common.sms.util.third.QyWebChatUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.wxutil.HttpUtil;
import com.bringspring.system.base.entity.EmailConfigEntity;
import com.bringspring.system.base.entity.SysConfigEntity;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.message.entity.QyWebChatModel;
import com.bringspring.system.message.model.message.DingTalkModel;
import com.bringspring.system.permission.model.user.form.UserUpAdminForm;
import com.bringspring.system.permission.model.user.vo.UserAdminVO;
import com.bringspring.system.permission.service.UserService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u7cfb\u7edf\u914d\u7f6e")
@RestController
@RequestMapping(value={"/api/system/SysConfig"})
public class SysConfigController {
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private UserService userService;

    @Operation(summary="\u5217\u8868")
    @GetMapping
    public ActionResult list() {
        List<SysConfigEntity> list = this.sysConfigService.getList();
        HashMap<String, String> map = new HashMap<String, String>(16);
        for (SysConfigEntity sys : list) {
            map.put(sys.getKeyName(), sys.getKeyValue());
        }
        SysConfigModel sysConfigModel = (SysConfigModel)JsonUtil.getJsonToBean(map, SysConfigModel.class);
        return ActionResult.success((Object)sysConfigModel);
    }

    @Operation(summary="\u5217\u8868")
    @GetMapping(value={"/getConfigByKeyName/{keyName}"})
    public ActionResult getConfigByKeyName(@PathVariable(value="keyName") String keyName) throws BaseException {
        SysConfigEntity sysConfigEntity = this.sysConfigService.getConfigByKeyName(keyName);
        return ActionResult.success((Object)sysConfigEntity);
    }

    @Operation(summary="\u5217\u8868")
    @GetMapping(value={"/getConfigListByCategory/{category}"})
    public ActionResult getConfigListByCategory(@PathVariable(value="category") String category) throws BaseException {
        List<SysConfigEntity> sysConfigList = this.sysConfigService.getConfigListByCategory(category);
        List list = JsonUtil.getJsonToList(sysConfigList, SysConfigVo.class);
        return ActionResult.success((Object)list);
    }

    @Operation(summary="\u57fa\u7840\u914d\u7f6e")
    @GetMapping(value={"/getSystemBaseConfig"})
    @NotCheckLogin
    public ActionResult getSystemBaseConfig() throws BaseException {
        BaseSystemInfo sysInfo = this.sysConfigService.getSysInfo();
        SystemInfo jsonToBean = (SystemInfo)JsonUtil.getJsonToBean((Object)sysInfo, SystemInfo.class);
        return ActionResult.success((Object)jsonToBean);
    }

    @Operation(summary="\u66f4\u65b0\u7cfb\u7edf\u914d\u7f6e")
    @PutMapping
    public ActionResult saveConfig(@RequestBody SysConfigListVO sysConfigModel) {
        ArrayList<SysConfigEntity> entitys = new ArrayList<SysConfigEntity>();
        for (SysConfigModelNew entry : sysConfigModel.getList()) {
            SysConfigEntity entity = new SysConfigEntity();
            entity.setId(RandomUtil.uuId());
            entity.setName(entry.getName());
            entity.setKeyName(entry.getKey());
            entity.setKeyValue(entry.getValue());
            entity.setCategory(sysConfigModel.getCategory());
            entitys.add(entity);
        }
        try {
            this.sysConfigService.saveBatch(entitys, sysConfigModel.getCategory());
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
        return ActionResult.success((String)MsgCode.SU005.get());
    }

    @Operation(summary="\u66f4\u65b0\u7cfb\u7edf\u914d\u7f6e")
    @PutMapping(value={"/saveByKeyName"})
    public ActionResult saveConfig(@RequestBody SysConfigEntity entity) {
        this.sysConfigService.create(entity);
        return ActionResult.success((String)MsgCode.SU005.get());
    }

    @Operation(summary="\u90ae\u7bb1\u8fde\u63a5\u6d4b\u8bd5")
    @PostMapping(value={"/Email/Test"})
    public ActionResult checkLogin(@RequestBody EmailTestForm emailTestForm) {
        EmailConfigEntity entity = (EmailConfigEntity)JsonUtil.getJsonToBean((Object)emailTestForm, EmailConfigEntity.class);
        String result = this.sysConfigService.checkMainLogin(entity);
        if ("true".equals(result)) {
            return ActionResult.success((String)MsgCode.SU017.get());
        }
        return ActionResult.fail((String)result);
    }

    @Operation(summary="\u6d4b\u8bd5\u4f01\u4e1a\u5fae\u4fe1\u914d\u7f6e\u7684\u8fde\u63a5")
    @PostMapping(value={"{type}/testQyWebChatConnect"})
    public ActionResult testQyWebChatConnect(@PathVariable(value="type") String type, @RequestBody @Valid QyWebChatModel qyWebChatModel) {
        JSONObject retMsg = new JSONObject();
        String corpId = qyWebChatModel.getQyhCorpId();
        String agentSecret = qyWebChatModel.getQyhAgentSecret();
        String corpSecret = qyWebChatModel.getQyhCorpSecret();
        if ("0".equals(type)) {
            retMsg = QyWebChatUtil.getAccessToken((String)corpId, (String)agentSecret);
            if (HttpUtil.isWxError((JSONObject)retMsg)) {
                return ActionResult.fail((String)("\u6d4b\u8bd5\u53d1\u9001\u6d88\u606f\u7684\u8fde\u63a5\u5931\u8d25\uff1a" + retMsg.getString("errmsg")));
            }
            return ActionResult.success((String)"\u6d4b\u8bd5\u53d1\u9001\u6d88\u606f\u8fde\u63a5\u6210\u529f");
        }
        if ("1".equals(type)) {
            retMsg = QyWebChatUtil.getAccessToken((String)corpId, (String)corpSecret);
            if (HttpUtil.isWxError((JSONObject)retMsg)) {
                return ActionResult.fail((String)("\u6d4b\u8bd5\u7ec4\u7ec7\u540c\u6b65\u7684\u8fde\u63a5\u5931\u8d25\uff1a" + retMsg.getString("errmsg")));
            }
            return ActionResult.success((String)"\u6d4b\u8bd5\u7ec4\u7ec7\u540c\u6b65\u8fde\u63a5\u6210\u529f");
        }
        return ActionResult.fail((String)"\u6d4b\u8bd5\u8fde\u63a5\u7c7b\u578b\u9519\u8bef");
    }

    @Operation(summary="\u6d4b\u8bd5\u9489\u9489\u914d\u7f6e\u7684\u8fde\u63a5")
    @PostMapping(value={"/testDingTalkConnect"})
    public ActionResult testDingTalkConnect(@RequestBody @Valid DingTalkModel dingTalkModel) {
        String appSecret;
        JSONObject retMsg = new JSONObject();
        String appKey = dingTalkModel.getDingSynAppKey();
        retMsg = DingTalkUtil.getAccessToken((String)appKey, (String)(appSecret = dingTalkModel.getDingSynAppSecret()));
        if (!retMsg.getBoolean("code").booleanValue()) {
            return ActionResult.fail((String)("\u6d4b\u8bd5\u9489\u9489\u8fde\u63a5\u5931\u8d25\uff1a" + retMsg.getString("error")));
        }
        return ActionResult.success((String)"\u6d4b\u8bd5\u9489\u9489\u8fde\u63a5\u6210\u529f");
    }

    @Operation(summary="\u83b7\u53d6\u7ba1\u7406\u5458\u96c6\u5408")
    @GetMapping(value={"/getAdminList"})
    public ActionResult<List<UserAdminVO>> getAdminList() {
        List admins = JsonUtil.getJsonToList(this.userService.getAdminList(), UserAdminVO.class);
        return ActionResult.success((Object)admins);
    }

    @Operation(summary="\u83b7\u53d6\u7ba1\u7406\u5458\u96c6\u5408")
    @PutMapping(value={"/setAdminList"})
    public ActionResult<String> setAdminList(@RequestBody UserUpAdminForm userUpAdminForm) {
        this.userService.setAdminListByIds(userUpAdminForm.getAdminIds());
        return ActionResult.success((String)MsgCode.SU004.get());
    }
}

