/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.exception;

import com.alibaba.fastjson.JSON;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.ActionResultCode;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.IpUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ReflectionUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.entity.LogEntity;
import com.bringspring.system.base.enums.LogSortEnum;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.exception.LoginException;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.base.exception.WxErrorException;
import com.bringspring.system.base.service.LogService;
import com.bringspring.system.permission.exception.PermissionException;
import java.nio.file.AccessDeniedException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@ControllerAdvice
public class ResultException {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResultException.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private LogService logService;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @ResponseBody
    @ExceptionHandler(value={LoginException.class})
    public ActionResult loginException(LoginException e) {
        log.error("\u7cfb\u7edf\u5f02\u5e38:" + e.getMessage(), (Throwable)((Object)e));
        ActionResult result = ActionResult.fail((Integer)ActionResultCode.Fail.getCode(), (String)e.getMessage());
        return result;
    }

    @ResponseBody
    @ExceptionHandler(value={AccessDeniedException.class})
    public ActionResult accessException(AccessDeniedException e) {
        log.error("\u7cfb\u7edf\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        ActionResult result = ActionResult.fail((Integer)ActionResultCode.ValidateError.getCode(), (String)"\u65e0\u6743\u8bbf\u95ee\u63a5\u53e3");
        return result;
    }

    @ResponseBody
    @ExceptionHandler(value={DataException.class})
    public ActionResult dataException(DataException e) {
        log.error("\u7cfb\u7edf\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        ActionResult result = ActionResult.fail((Integer)ActionResultCode.Fail.getCode(), (String)e.getMessage());
        return result;
    }

    @ResponseBody
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ActionResult methodArgumentNotValidException(MethodArgumentNotValidException e) {
        log.error("\u7cfb\u7edf\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        HashMap<String, String> map = new HashMap<String, String>(16);
        List allErrors = e.getBindingResult().getAllErrors();
        for (int i = 0; i < allErrors.size(); ++i) {
            String s = ((ObjectError)allErrors.get(i)).getCodes()[0];
            String[] parts = s.split("\\.");
            String part1 = parts[parts.length - 1];
            map.put(part1, ((ObjectError)allErrors.get(i)).getDefaultMessage());
        }
        String json = JSON.toJSONString(map);
        ActionResult result = ActionResult.fail((Integer)ActionResultCode.ValidateError.getCode(), (String)json);
        this.printLog((Exception)e, "\u5b57\u6bb5\u9a8c\u8bc1\u5f02\u5e38");
        return result;
    }

    @ResponseBody
    @ExceptionHandler(value={WorkFlowException.class})
    public ActionResult workFlowException(WorkFlowException e) {
        log.error("\u7cfb\u7edf\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        return ActionResult.fail((String)e.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={WxErrorException.class})
    public ActionResult wxErrorException(WxErrorException e) {
        log.error("\u7cfb\u7edf\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        return ActionResult.fail((Integer)e.getError().getErrorCode(), (String)"\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41");
    }

    @ResponseBody
    @ExceptionHandler(value={BaseException.class})
    public ActionResult baseExceptionException(BaseException e) {
        log.error("\u7cfb\u7edf\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        this.printLog(e, "\u7cfb\u7edf\u5f02\u5e38");
        return ActionResult.fail((Integer)ActionResultCode.Fail.getCode(), (String)e.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={PermissionException.class})
    public ActionResult permissionException(PermissionException e) {
        log.error("\u7cfb\u7edf\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        this.printLog(e, "\u7cfb\u7edf\u5f02\u5e38");
        return ActionResult.fail((Integer)ActionResultCode.Fail.getCode(), (String)e.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public ActionResult exception(Exception e) {
        log.error("\u7cfb\u7edf\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        this.printLog(e, "\u7cfb\u7edf\u5f02\u5e38");
        return ActionResult.fail((Integer)ActionResultCode.Fail.getCode(), (String)"\u7cfb\u7edf\u5f02\u5e38");
    }

    private void printLog(Exception e, String module) {
        UserInfo userInfo = this.userProvider.get();
        LogEntity entity = new LogEntity();
        entity.setId(RandomUtil.uuId());
        entity.setCategory(LogSortEnum.Operate.getCode());
        entity.setUserId(userInfo.getUserId());
        String userName = StringUtils.isNotEmpty((String)userInfo.getUserName()) ? userInfo.getUserName() + "/" + userInfo.getUserAccount() : userInfo.getUserAccount();
        entity.setUserName(userName);
        if (!ServletUtils.getIsMobileDevice()) {
            String modelName = module;
            entity.setModuleName(modelName);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(e.toString() + "\n");
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element.toString() + "\n");
        }
        entity.setJsons(sb.toString());
        entity.setRequestUrl(ServletUtils.getRequest().getServletPath());
        entity.setRequestMethod(ServletUtils.getRequest().getMethod());
        entity.setCategory(4);
        entity.setUserId(userInfo.getUserId());
        entity.setIpAddress(IpUtil.getIpAddr());
        entity.setCreatorTime(new Date());
        entity.setPlatForm(ServletUtils.getUserAgent());
        if (this.configValueUtil.isMultiTenancy() && StringUtils.isEmpty((String)userInfo.getTenantId())) {
            log.error("\u8bf7\u6c42\u5f02\u5e38\uff0c \u65e0\u767b\u9646\u79df\u6237\uff1a" + ReflectionUtil.toString((Object)entity), (Throwable)e);
        } else {
            this.logService.save(entity);
        }
    }

    private void printLoginLog(Exception e, String module) {
        if (!this.configValueUtil.isMultiTenancy()) {
            UserInfo userInfo = this.userProvider.get();
            LogEntity entity = new LogEntity();
            entity.setId(RandomUtil.uuId());
            entity.setCategory(LogSortEnum.Operate.getCode());
            entity.setUserId(userInfo.getUserId());
            String userName = StringUtils.isNotEmpty((String)userInfo.getUserName()) ? userInfo.getUserName() + "/" + userInfo.getUserAccount() : userInfo.getUserAccount();
            entity.setUserName(userName);
            if (!ServletUtils.getIsMobileDevice()) {
                String modelName = module;
                entity.setModuleName(modelName);
            }
            entity.setAbstracts("\u767b\u9646\u5931\u8d25");
            entity.setJsons(e.getMessage());
            entity.setRequestUrl(ServletUtils.getRequest().getServletPath());
            entity.setRequestMethod(ServletUtils.getRequest().getMethod());
            entity.setCategory(1);
            entity.setUserId(userInfo.getUserId());
            entity.setIpAddress(IpUtil.getIpAddr());
            entity.setCreatorTime(new Date());
            entity.setPlatForm(ServletUtils.getUserAgent());
            this.logService.save(entity);
        }
    }
}

