/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.entity.VisualDataMapEntity;
import com.bringspring.system.base.mapper.DataMapMapper;
import com.bringspring.system.base.service.DataMapService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataMapServiceImpl
extends ServiceImpl<DataMapMapper, VisualDataMapEntity>
implements DataMapService {
    @Autowired
    private UserProvider userProvider;

    @Override
    public List<VisualDataMapEntity> getList(Pagination pagination) {
        boolean flag = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)pagination.getKeyword())) {
            flag = true;
            queryWrapper.lambda().and(t -> ((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(VisualDataMapEntity::getFullName, (Object)pagination.getKeyword())).or()).like(VisualDataMapEntity::getEnCode, (Object)pagination.getKeyword()));
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(VisualDataMapEntity::getSortCode)).orderByDesc(VisualDataMapEntity::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(VisualDataMapEntity::getLastModifyTime);
        }
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage iPages = this.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(iPages.getRecords(), page.getTotal());
    }

    @Override
    public List<VisualDataMapEntity> getList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByDesc(VisualDataMapEntity::getSortCode)).orderByDesc(VisualDataMapEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public VisualDataMapEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(VisualDataMapEntity::getId, (Object)id);
        return (VisualDataMapEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(VisualDataMapEntity entity) {
        entity.setId(RandomUtil.uuId());
        entity.setCreatorTime(DateUtil.getNowDate());
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        entity.setEnabledMark(1);
        this.save(entity);
    }

    @Override
    public boolean update(String id, VisualDataMapEntity entity) {
        entity.setId(id);
        entity.setLastModifyTime(DateUtil.getNowDate());
        entity.setLastModifyUserId(this.userProvider.get().getUserId());
        return this.updateById(entity);
    }

    @Override
    public void delete(VisualDataMapEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public boolean isExistByFullName(String fullName, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(VisualDataMapEntity::getFullName, (Object)fullName);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(VisualDataMapEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public boolean isExistByEnCode(String enCode, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(VisualDataMapEntity::getEnCode, (Object)enCode);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(VisualDataMapEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }
}

