/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.external.config.mutil;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.system.msgcenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgcenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgcenter.service.McMsgAccountService;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import me.chanjar.weixin.mp.config.impl.WxMpDefaultConfigImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WxMpConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WxMpConfiguration.class);
    @Autowired
    private McMsgAccountService mcMsgAccountService;
    private Map<String, McMsgAccountEntity> accounts = Maps.newHashMap();
    private WxMpService wxMpService = new WxMpServiceImpl();

    public WxMpService getWxMpService(String appId) {
        this.initWxMpService();
        if (!this.wxMpService.switchover(appId)) {
            throw new IllegalArgumentException(String.format("\u672a\u627e\u5230\u5bf9\u5e94appid=[%s]\u7684\u914d\u7f6e\uff0c\u8bf7\u6838\u5b9e\uff01", appId));
        }
        return this.wxMpService;
    }

    public McMsgAccountEntity getAccount(String appId) {
        McMsgAccountEntity account = this.accounts.get(appId);
        if (ObjectUtil.isEmpty((Object)account)) {
            this.initWxMpService();
            account = this.accounts.get(appId);
        }
        return account;
    }

    public void initWxMpService() {
        List<McMsgAccountEntity> account = this.mcMsgAccountService.getAccountByCategory(ChannelTypeEnum.WX_MP.getCode());
        if (CollectionUtil.isEmpty(account)) {
            throw new WxRuntimeException("\u672a\u6dfb\u52a0\u5fae\u4fe1\u516c\u4f17\u53f7\u76f8\u5173\u8d26\u53f7\u914d\u7f6e\uff01");
        }
        this.wxMpService.setMultiConfigStorages(account.stream().map(a -> {
            WxMpDefaultConfigImpl config = new WxMpDefaultConfigImpl();
            config.setAppId(a.getAppId());
            config.setSecret(a.getAppSecret());
            config.setToken(a.getAgentId());
            config.setAesKey(a.getBearer());
            return config;
        }).collect(Collectors.toMap(WxMpDefaultConfigImpl::getAppId, a -> a, (o, n) -> o)));
        account.stream().forEach(a -> this.accounts.put(a.getAppId(), (McMsgAccountEntity)a));
    }
}

