/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.external.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.emoji.EmojiUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.external.bean.linkedcorp.MyWxCpLinkedCorpUser;
import com.bringspring.system.external.service.WxCpLinkedCorpService;
import com.bringspring.system.external.util.ValidateCommonUtil;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.message.util.SynThirdConsts;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.UserService;
import java.util.ArrayList;
import java.util.HashMap;
import lombok.Generated;
import me.chanjar.weixin.cp.api.WxCpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WxCpLinkedCorpServiceImpl
implements WxCpLinkedCorpService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WxCpLinkedCorpServiceImpl.class);
    @Autowired
    private ValidateCommonUtil validateCommonUtil;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    PositionService positionService;
    @Autowired
    private UserService userService;

    @Override
    public UserEntity registerSysAccount(MyWxCpLinkedCorpUser qyuser, WxCpService wxCpService) {
        UserEntity userEntity = null;
        if (ObjectUtil.isNotEmpty((Object)qyuser)) {
            String corpId = wxCpService.getWxCpConfigStorage().getCorpId();
            String userCorpId = qyuser.getCorpId();
            String userId = qyuser.getUserId();
            String thirdObjid = userCorpId + "/" + userId;
            String mobile = qyuser.getMobile();
            String email = qyuser.getEmail();
            this.validateCommonUtil.initData();
            userEntity = this.userService.getUserEntity(userId, mobile, email);
            if (ObjectUtil.isEmpty((Object)userEntity)) {
                ArrayList<PositionEntity> positionBatch = new ArrayList<PositionEntity>();
                HashMap<String, PositionEntity> savePositionMap = new HashMap<String, PositionEntity>();
                userEntity = new UserEntity();
                userEntity.setId(RandomUtil.uuId());
                userEntity.setAccount(userId);
                SynThirdInfoEntity synThirdInfoEntity = this.validateCommonUtil.newSynThirdInfoForWxUser(thirdObjid);
                synThirdInfoEntity.setCropId(corpId);
                synThirdInfoEntity.setSystemObjectId(userEntity.getId());
                synThirdInfoEntity.setSynState(SynThirdConsts.SYN_STATE_OK);
                synThirdInfoEntity.setDescription("\u4e92\u8054\u4f01\u4e1a\u7528\u6237\uff0c\u626b\u7801\u6216\u81ea\u52a8\u767b\u5f55\u7ed1\u5b9a\u6ce8\u518c\u8d26\u6237\u3002");
                if (StringUtils.isNotEmpty((String)qyuser.getName())) {
                    String name = StringUtils.stringFilter((String)EmojiUtil.removeAllEmojis((String)qyuser.getName()));
                    userEntity.setRealName(name);
                }
                if (StringUtils.isNotEmpty((String)mobile)) {
                    userEntity.setMobilePhone(mobile);
                }
                if (StringUtils.isNotEmpty((String)qyuser.getTelephone())) {
                    userEntity.setTelePhone(qyuser.getTelephone());
                }
                if (StringUtils.isNotEmpty((String)email)) {
                    userEntity.setEmail(email);
                }
                this.validateCommonUtil.setDeptAndPosition(qyuser, userEntity);
                userEntity.setCode(this.validateCommonUtil.getCode(qyuser));
                userEntity.setRoleId(this.validateCommonUtil.getDefaultRoleId());
                userEntity.setHeadIcon("/api/file/Image/userAvatar/001.png");
                userEntity.setGender(3);
                userEntity.setEnabledMark(1);
                userEntity.setSecretkey(RandomUtil.uuId());
                userEntity.setIsAdministrator(0);
                userEntity.setPassword(this.userService.getDefaultPassword(userEntity.getSecretkey()));
                this.validateCommonUtil.convertPosition(savePositionMap, userEntity);
                if (!savePositionMap.isEmpty()) {
                    for (String key : savePositionMap.keySet()) {
                        positionBatch.add((PositionEntity)savePositionMap.get(key));
                    }
                }
                this.userService.saveOrUpdateCommon(userEntity.getId(), userEntity);
                this.positionService.saveOrUpdateBatch(positionBatch);
                this.userService.save(userEntity);
                this.synThirdInfoService.save(synThirdInfoEntity);
            } else {
                SynThirdInfoEntity synThirdInfoEntity = this.validateCommonUtil.newSynThirdInfoForWxUser(thirdObjid);
                synThirdInfoEntity.setCropId(corpId);
                synThirdInfoEntity.setSystemObjectId(userEntity.getId());
                synThirdInfoEntity.setSynState(SynThirdConsts.SYN_STATE_OK);
                synThirdInfoEntity.setDescription("\u4e92\u8054\u4f01\u4e1a\u7528\u6237\uff0c\u626b\u7801\u6216\u81ea\u52a8\u767b\u5f55\u7ed1\u5b9a\u5df2\u6709\u8d26\u6237\u3002");
                this.synThirdInfoService.save(synThirdInfoEntity);
            }
        }
        return userEntity;
    }
}

