/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.message.service.impl;

import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.model.message.QyWebChatUserModel;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.message.service.SynThirdQyService;
import com.bringspring.system.message.util.SynThirdConsts;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.mapper.OrganizeMapper;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SynThirdQyServiceImpl
extends ServiceImpl<OrganizeMapper, OrganizeEntity>
implements SynThirdQyService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private UserService userService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private RoleService roleService;

    public JSONObject checkDepartmentSysToQy(SynThirdInfoEntity synThirdInfoEntity) {
        JSONObject retMsg = new JSONObject();
        retMsg.put("code", (Object)true);
        retMsg.put("flag", (Object)"");
        retMsg.put("error", (Object)"");
        if (synThirdInfoEntity != null) {
            if ("".equals(String.valueOf(synThirdInfoEntity.getThirdObjectId())) || "null".equals(String.valueOf(synThirdInfoEntity.getThirdObjectId()))) {
                retMsg.put("code", (Object)false);
                retMsg.put("flag", (Object)"2");
                retMsg.put("error", (Object)"\u540c\u6b65\u8868\u4e2d\u90e8\u95e8\u5bf9\u5e94\u7684\u4f01\u4e1a\u5fae\u4fe1ID\u4e3a\u7a7a!");
            }
        } else {
            retMsg.put("code", (Object)false);
            retMsg.put("flag", (Object)"3");
            retMsg.put("error", (Object)"\u90e8\u95e8\u672a\u540c\u6b65\u5230\u4f01\u4e1a\u5fae\u4fe1!");
        }
        return retMsg;
    }

    public JSONObject checkCnEnName(String cnName, String EnName, String opType, SynThirdInfoEntity synThirdInfoEntity, Integer thirdType, Integer dataType, String sysObjId, String thirdObjId, String deptFlag) {
        JSONObject retMsg = new JSONObject();
        retMsg.put("code", (Object)true);
        retMsg.put("error", (Object)"");
        if (cnName.equals(EnName)) {
            Integer synState = SynThirdConsts.SYN_STATE_FAIL;
            String description = deptFlag + "\u90e8\u95e8\u4e2d\u6587\u540d\u79f0\u4e0e\u82f1\u6587\u540d\u79f0\u4e0d\u80fd\u76f8\u540c";
            this.saveSynThirdInfoEntity(opType, synThirdInfoEntity, thirdType, dataType, sysObjId, thirdObjId, synState, description);
            retMsg.put("code", (Object)false);
            retMsg.put("error", (Object)description);
        }
        return retMsg;
    }

    public void saveSynThirdInfoEntity(String opType, SynThirdInfoEntity synThirdInfoEntity, Integer thirdType, Integer dataType, String sysObjId, String thirdObjId, Integer synState, String description) {
        UserInfo userInfo = this.userProvider.get();
        SynThirdInfoEntity entity = new SynThirdInfoEntity();
        String compValue = "add";
        if (compValue.equals(opType)) {
            entity.setId(RandomUtil.uuId());
            entity.setThirdType(thirdType);
            entity.setDataType(dataType);
            entity.setSystemObjectId(sysObjId);
            entity.setThirdObjectId(thirdObjId);
            entity.setSynState(synState);
            entity.setDescription(description);
            entity.setCreatorUserId(userInfo.getUserId());
            entity.setCreatorTime(DateUtil.getNowDate());
            entity.setLastModifyUserId(userInfo.getUserId());
            entity.setLastModifyTime(DateUtil.getNowDate());
            this.synThirdInfoService.create(entity);
        } else {
            entity = synThirdInfoEntity;
            entity.setThirdType(thirdType);
            entity.setDataType(dataType);
            entity.setThirdObjectId(thirdObjId);
            entity.setSynState(synState);
            entity.setDescription(description);
            entity.setLastModifyUserId(userInfo.getUserId());
            entity.setLastModifyTime(DateUtil.getNowDate());
            this.synThirdInfoService.update(entity.getId(), entity);
        }
    }

    public JSONObject setQyUserObject(UserEntity userEntity, QyWebChatUserModel qyWebChatUserModel) {
        List<UserEntity> userList = this.userService.getList();
        JSONObject object = new JSONObject();
        JSONObject retMsg = new JSONObject();
        retMsg.put("code", (Object)true);
        retMsg.put("error", (Object)"");
        if (StringUtils.isNotEmpty((String)userEntity.getEmail()) && !Validator.isEmail((CharSequence)userEntity.getEmail())) {
            retMsg.put("code", (Object)false);
            retMsg.put("error", (Object)"\u90ae\u7bb1\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
            retMsg.put("qyUserObject", (Object)"");
            return retMsg;
        }
        object.put("userid", (Object)userEntity.getId());
        object.put("name", (Object)userEntity.getRealName());
        object.put("mobile", (Object)userEntity.getMobilePhone());
        SynThirdInfoEntity synThirdInfoEntity = this.synThirdInfoService.getInfoBySysObjId("1", "1", userEntity.getOrganizeId());
        retMsg = this.checkDepartmentSysToQy(synThirdInfoEntity);
        if (!retMsg.getBoolean("code").booleanValue()) {
            retMsg.put("code", (Object)false);
            retMsg.put("error", (Object)"\u90e8\u95e8\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4f01\u4e1a\u5fae\u4fe1ID\uff01");
            retMsg.put("qyUserObject", (Object)"");
            return retMsg;
        }
        String formatString = "[%s]";
        object.put("department", (Object)String.format(formatString, synThirdInfoEntity.getThirdObjectId()));
        object.put("main_department", (Object)synThirdInfoEntity.getThirdObjectId());
        String isLeader = userList.stream().filter(t -> userEntity.getOrganizeId().equals(t.getOrganizeId()) && userEntity.getId().equals(t.getManagerId())).count() == 0L ? "0" : "1";
        object.put("is_leader_in_dept", (Object)String.format(formatString, isLeader));
        object.put("email", (Object)userEntity.getEmail());
        PositionEntity positionEntity = this.positionService.getInfo(userEntity.getPositionId());
        if (positionEntity != null) {
            object.put("position", (Object)positionEntity.getFullName());
        } else {
            object.put("position", (Object)"");
        }
        object.put("gender", (Object)userEntity.getGender().toString());
        object.put("telephone", (Object)userEntity.getTelePhone());
        object.put("enable", (Object)userEntity.getEnabledMark());
        JSONObject extattr = new JSONObject();
        extattr.put("attrs", (Object)"[]");
        object.put("extattr", (Object)extattr.toJSONString());
        object.put("address", (Object)userEntity.getPostalAddress());
        object.put("alias", (Object)"");
        object.put("avatar_mediaid", (Object)"");
        JSONObject external_profile = new JSONObject();
        external_profile.put("external_corp_name", (Object)"");
        external_profile.put("external_attr", (Object)"[]");
        object.put("external_profile", (Object)external_profile.toJSONString());
        object.put("external_position", (Object)"");
        if (qyWebChatUserModel != null) {
            object.put("alias", (Object)qyWebChatUserModel.getAlias());
            object.put("avatar_mediaid", (Object)qyWebChatUserModel.getAvatar_mediaid());
            object.put("external_profile", (Object)qyWebChatUserModel.getExternal_profile());
            object.put("external_position", (Object)qyWebChatUserModel.getExternal_position());
        }
        String jsonString = object.toJSONString();
        jsonString = jsonString.replaceAll("\\\\", "");
        jsonString = jsonString.replaceAll("\"\\{", "{");
        jsonString = jsonString.replaceAll("}\"", "}");
        jsonString = jsonString.replaceAll("\"\\[", "[");
        jsonString = jsonString.replaceAll("\\]\"", "]");
        retMsg.put("qyUserObject", (Object)jsonString);
        return retMsg;
    }

    public JSONObject checkUserMobileEmailRepeat(String mobile, String email, String userId, List<QyWebChatUserModel> qyUserList, String opType, SynThirdInfoEntity synThirdInfoEntity, Integer thirdType, Integer dataType, String sysObjId, String thirdObjId, String deptFlag) {
        boolean isDiff = true;
        Object description = "";
        JSONObject retMsg = new JSONObject();
        if (StringUtils.isNotEmpty((String)mobile)) {
            if (StringUtils.isNotEmpty((String)userId)) {
                if (qyUserList.stream().filter(t -> String.valueOf(t.getMobile()).equals(mobile) && !t.getUserid().equals(userId)).count() > 0L) {
                    isDiff = false;
                    description = deptFlag + "\u4f01\u4e1a\u5185\u5df2\u6709\u7ed1\u5b9a\u624b\u673a\u53f7:" + mobile;
                }
            } else if (qyUserList.stream().filter(t -> String.valueOf(t.getMobile()).equals(mobile)).count() > 0L) {
                isDiff = false;
                description = deptFlag + "\u4f01\u4e1a\u5185\u5df2\u6709\u7ed1\u5b9a\u624b\u673a\u53f7:" + mobile;
            }
        }
        if (StringUtils.isNotEmpty((String)email)) {
            if (StringUtils.isNotEmpty((String)userId)) {
                if (qyUserList.stream().filter(t -> String.valueOf(t.getEmail()).equals(email) && !t.getUserid().equals(userId)).count() > 0L) {
                    isDiff = false;
                    description = deptFlag + "\u4f01\u4e1a\u5185\u5df2\u6709\u7ed1\u5b9a\u6b64\u90ae\u7bb1:" + email;
                }
            } else if (qyUserList.stream().filter(t -> String.valueOf(t.getEmail()).equals(email)).count() > 0L) {
                isDiff = false;
                description = deptFlag + "\u4f01\u4e1a\u5185\u5df2\u6709\u7ed1\u5b9a\u6b64\u90ae\u7bb1:" + email;
            }
        }
        retMsg.put("code", (Object)isDiff);
        retMsg.put("error", description);
        if (!isDiff) {
            Integer synState = SynThirdConsts.SYN_STATE_FAIL;
            this.saveSynThirdInfoEntity(opType, synThirdInfoEntity, thirdType, dataType, sysObjId, thirdObjId, synState, (String)description);
        }
        return retMsg;
    }

    public JSONObject checkUserSysToQy(SynThirdInfoEntity synThirdInfoEntity) {
        JSONObject retMsg = new JSONObject();
        retMsg.put("code", (Object)true);
        retMsg.put("flag", (Object)"");
        retMsg.put("error", (Object)"");
        if (synThirdInfoEntity != null) {
            if ("".equals(String.valueOf(synThirdInfoEntity.getThirdObjectId())) || "null".equals(String.valueOf(synThirdInfoEntity.getThirdObjectId()))) {
                retMsg.put("code", (Object)false);
                retMsg.put("flag", (Object)"2");
                retMsg.put("error", (Object)"\u540c\u6b65\u8868\u4e2d\u7528\u6237\u5bf9\u5e94\u7684\u7b2c\u4e09\u65b9ID\u4e3a\u7a7a!");
            }
        } else {
            retMsg.put("code", (Object)false);
            retMsg.put("flag", (Object)"3");
            retMsg.put("error", (Object)"\u7528\u6237\u672a\u540c\u6b65!");
        }
        return retMsg;
    }

    @Override
    public void createOrgan(OrganizeEntity entity) {
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        String organizeIdTree = StringUtils.isNotEmpty((String)entity.getOrganizeIdTree()) ? entity.getOrganizeIdTree() + "," : "";
        entity.setOrganizeIdTree(organizeIdTree + entity.getId());
        this.save(entity);
    }

    public void setOrganizedTree() {
        List<OrganizeEntity> listOrgan = this.organizeService.getList();
        List collectCompany = listOrgan.stream().filter(i -> "company".equals(i.getCategory())).map(v -> v.getId()).collect(Collectors.toList());
        if (ObjectUtil.isNotEmpty(listOrgan)) {
            for (OrganizeEntity item : listOrgan) {
                String organizeIdTree = this.organizeService.getOrganizeIdTreeALL(item);
                List<String> listTree = Arrays.asList(organizeIdTree.split(","));
                List collectOrg = listTree.stream().filter(collectCompany::contains).collect(Collectors.toList());
                String organizeId = "0";
                if (!ObjectUtil.isEmpty(collectOrg)) {
                    organizeId = (String)collectOrg.get(collectOrg.size() - 1);
                }
                item.setOrganizeIdTree(organizeIdTree);
                item.setOrganizeId(organizeId);
            }
            this.organizeService.updateBatchById(listOrgan);
        }
    }

    public void setOrganizeCode() {
        List<OrganizeEntity> orgListCodeNull = this.organizeService.getOrgListCodeNull();
        if (ObjectUtil.isNotEmpty(orgListCodeNull)) {
            orgListCodeNull.stream().forEach(item -> this.setCode((OrganizeEntity)item));
        }
    }

    public void setCode(OrganizeEntity entity) {
        OrganizeEntity parentEntity = this.organizeService.getInfo(entity.getParentId());
        if (ObjectUtil.isNotEmpty((Object)parentEntity.getEnCode())) {
            List<OrganizeEntity> parentIdList = this.organizeService.getParentIdListAsc(entity.getParentId());
            if (ObjectUtil.isNotEmpty(parentIdList) && ObjectUtil.isNotEmpty((Object)parentIdList.get(0).getEnCode())) {
                String enCode1 = parentIdList.get(0).getEnCode();
                String ul = enCode1.replaceAll("[a-zA-Z]", "");
                int utellength = ul.length();
                Object u = "";
                for (int i = 0; i < utellength; ++i) {
                    u = (String)u + "0";
                }
                BigInteger utel = new BigInteger(ul);
                BigInteger untel = new BigInteger(String.valueOf("1"));
                utel = utel.add(untel);
                DecimalFormat nf = new DecimalFormat((String)u);
                String str = nf.format(utel);
                String enCode = parentEntity.getEnCode();
                entity.setEnCode(enCode.charAt(0) + str);
            } else {
                entity.setEnCode(parentEntity.getEnCode() + "01");
            }
        } else {
            this.setCode(parentEntity);
        }
        this.organizeService.update(entity);
    }
}

