/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.message.util;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.system.message.model.message.EmailModel;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class EmailUtil {
    public static JSONObject sendMail(EmailModel emailModel) {
        JSONObject retMsg = new JSONObject();
        String from = emailModel.getEmailAccount();
        String to = emailModel.getEmailToUsers();
        Properties props = System.getProperties();
        props.setProperty("mail.smtp.host", emailModel.getEmailSmtpHost());
        props.setProperty("mail.smtp.auth", "true");
        props.setProperty("mail.transport.protocol", "smtp");
        Session session = Session.getInstance((Properties)props);
        session.setDebug(true);
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(from, emailModel.getEmailSenderName(), "UTF-8"));
            InternetAddress[] sendTo = InternetAddress.parse((String)to);
            message.setRecipients(MimeMessage.RecipientType.TO, (Address[])sendTo);
            message.setSubject(emailModel.getEmailTitle());
            message.setContent((Object)emailModel.getEmailContent(), "text/html;charset=utf-8");
            Transport transport = session.getTransport();
            transport.connect(emailModel.getEmailSmtpHost(), Integer.parseInt(emailModel.getEmailSmtpPort()), emailModel.getEmailAccount(), emailModel.getEmailPassword());
            transport.sendMessage((Message)message, (Address[])sendTo);
            transport.close();
            retMsg.put("code", (Object)true);
            retMsg.put("error", (Object)"");
            return retMsg;
        }
        catch (UnsupportedEncodingException | MessagingException e) {
            retMsg.put("code", (Object)false);
            retMsg.put("error", (Object)e.toString());
            return retMsg;
        }
    }
}

