/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.service.chain;

import cn.hutool.core.collection.CollectionUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.enums.EnabledMarkEnum;
import com.bringspring.system.msgcenter.enums.MsgCenterCode;
import com.bringspring.system.msgcenter.service.chain.FilterProcessor;
import com.bringspring.system.msgcenter.service.context.FilterResult;
import com.bringspring.system.msgcenter.service.context.SendMessageContext;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ThirdObjectIdFilter
implements FilterProcessor {
    @Override
    public FilterResult process(SendMessageContext context) {
        Map<Boolean, List<McTaskMsgReceiveEntity>> partitioned = context.getValidList().stream().collect(Collectors.partitioningBy(r -> {
            SynThirdInfoEntity info = context.getThirdInfoMap().get(r.getReceiveUserId());
            return info != null && StringUtils.isNotEmpty((String)info.getThirdObjectId());
        }));
        List<McTaskMsgReceiveEntity> invalidList = partitioned.get(false);
        if (CollectionUtil.isNotEmpty(invalidList)) {
            invalidList.stream().forEach(e -> {
                e.setEnabledMark(EnabledMarkEnum.FAIL.getCode());
                e.setDescription(MsgCenterCode.THIRD_PARTY_ID_EMPTY.getDesc() + "\uff08" + e.getReceiveUserId() + "\uff09");
            });
        }
        return new FilterResult(partitioned.get(true), invalidList);
    }
}

