/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.service.strategy.impl;

import com.bringspring.common.util.RandomUtil;
import com.bringspring.system.msgcenter.constant.Constants;
import com.bringspring.system.msgcenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgcenter.entity.McMsgTemplateEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.service.McMsgTemplateService;
import com.bringspring.system.msgcenter.service.strategy.AbstractMessageChannelStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WebhookStrategy
extends AbstractMessageChannelStrategy {
    @Autowired
    private McMsgTemplateService mcMsgTemplateService;

    @Override
    public ChannelTypeEnum getChannelType() {
        return ChannelTypeEnum.WEBHOOK;
    }

    @Override
    public void processMessage(McTaskMsgEntity taskMsg, McMsgSendTemplateModel sendTemplate, Map<String, McTaskMsgContentEntity> contentMap, Map<String, List<McTaskMsgReceiveEntity>> receiveMap, Set<String> userSet) {
        McTaskMsgContentEntity webhookContent;
        String taskMsgId = taskMsg.getId();
        String templateId = sendTemplate.getId();
        String channelType = sendTemplate.getMessageType();
        String msgTemplateId = sendTemplate.getTemplateId();
        String msgAccountId = sendTemplate.getAccountConfigId();
        McMsgAccountEntity account = this.mcMsgAccountService.getInfo(sendTemplate.getAccountConfigId());
        McMsgTemplateEntity msgTemplate = this.mcMsgTemplateService.getInfo(sendTemplate.getTemplateId());
        String webhookKey = channelType + msgTemplateId + msgAccountId;
        if (!contentMap.containsKey(webhookKey)) {
            webhookContent = this.getTaskMsgContent(templateId, channelType, taskMsg, msgTemplate, account);
            contentMap.put(webhookKey, webhookContent);
        } else {
            webhookContent = contentMap.get(webhookKey);
        }
        receiveMap.computeIfAbsent(webhookKey, k -> {
            McTaskMsgReceiveEntity webhookReceiveEntity = new McTaskMsgReceiveEntity();
            webhookReceiveEntity.setId(RandomUtil.uuId());
            webhookReceiveEntity.setMsgId(taskMsgId);
            webhookReceiveEntity.setTemplateId(templateId);
            webhookReceiveEntity.setMsgTemplateId(msgTemplateId);
            webhookReceiveEntity.setMsgAccountId(msgAccountId);
            webhookReceiveEntity.setContentId(webhookContent.getId());
            webhookReceiveEntity.setChannelType(channelType);
            webhookReceiveEntity.setReceiveUserId(sendTemplate.getAccountConfigId());
            webhookReceiveEntity.setSysUserId(null);
            webhookReceiveEntity.setEnabledMark(0);
            webhookReceiveEntity.setIsRead(Constants.ReadStatus.UNREAD.getCode());
            webhookReceiveEntity.setDescription(null);
            return new ArrayList<McTaskMsgReceiveEntity>(Arrays.asList(webhookReceiveEntity));
        });
    }
}

