/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.util.DateUtil;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebHookUtil {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String APPLICATION_JSON = "application/json";
    private static final String MSG_TYPE = "msg_type";
    private static final String CONTENT_KEY = "content";
    private static final String TEXT_MSG_TYPE = "text";
    private static final Logger logger = LoggerFactory.getLogger(WebHookUtil.class);

    private WebHookUtil() {
        throw new UnsupportedOperationException("\u5de5\u5177\u7c7b\u4e0d\u5141\u8bb8\u5b9e\u4f8b\u5316");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static JSONObject doPostForJson(String url, String jsonParams) {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            JSONObject jSONObject;
            block18: {
                CloseableHttpResponse response;
                block16: {
                    JSONObject jSONObject2;
                    block17: {
                        HttpPost httpPost = WebHookUtil.buildHttpPost(url, jsonParams);
                        logger.debug("Request parameters: {}", (Object)EntityUtils.toString((HttpEntity)httpPost.getEntity()));
                        response = httpClient.execute((ClassicHttpRequest)httpPost);
                        try {
                            if (response.getCode() != 200) break block16;
                            String result = EntityUtils.toString((HttpEntity)response.getEntity());
                            logger.debug("Result: {}", (Object)result);
                            jSONObject2 = JSONObject.parseObject((String)result);
                            if (response == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (response != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        response.close();
                    }
                    return jSONObject2;
                }
                jSONObject = new JSONObject();
                if (response == null) break block18;
                response.close();
            }
            return jSONObject;
        }
        catch (Exception e) {
            logger.error("POST\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            return new JSONObject();
        }
    }

    private static HttpPost buildHttpPost(String url, String jsonParams) throws UnsupportedEncodingException {
        HttpPost httpPost = new HttpPost(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(180000L, TimeUnit.MILLISECONDS).setConnectionRequestTimeout(180000L, TimeUnit.MILLISECONDS).setResponseTimeout(180000L, TimeUnit.MILLISECONDS).setRedirectsEnabled(true).build();
        httpPost.setConfig(requestConfig);
        httpPost.setHeader(CONTENT_TYPE, (Object)APPLICATION_JSON);
        httpPost.setEntity((HttpEntity)new StringEntity(jsonParams, ContentType.APPLICATION_JSON));
        return httpPost;
    }

    public static void sendMsgBasic(String url, List<String> msgList, String userName, String password) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put(MSG_TYPE, TEXT_MSG_TYPE);
        HashMap<String, String> contentMap = new HashMap<String, String>();
        contentMap.put(CONTENT_KEY, String.join((CharSequence)"\n", msgList));
        params.put(CONTENT_KEY, contentMap);
        WebHookUtil.doPostForJsonObject(url, JSON.toJSONString(params), WebHookUtil.buildBasicAuthToken(userName, password));
    }

    private static String buildBasicAuthToken(String userName, String password) {
        return "Basic " + Base64.getEncoder().encodeToString((userName + ":" + password).getBytes(StandardCharsets.UTF_8));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JSONObject doPostForJsonObject(String url, String jsonParams, String token) {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            JSONObject jsonObject = null;
            HttpPost httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(180L, TimeUnit.SECONDS).setConnectionRequestTimeout(180L, TimeUnit.SECONDS).setResponseTimeout(180L, TimeUnit.SECONDS).setRedirectsEnabled(true).build();
            httpPost.setConfig(requestConfig);
            httpPost.setHeader(CONTENT_TYPE, (Object)APPLICATION_JSON);
            httpPost.setHeader("Authorization", (Object)token);
            try {
                CloseableHttpResponse response;
                block17: {
                    JSONObject jSONObject;
                    httpPost.setEntity((HttpEntity)new StringEntity(jsonParams, ContentType.APPLICATION_JSON));
                    logger.debug("Request parameters: {}", (Object)EntityUtils.toString((HttpEntity)httpPost.getEntity()));
                    logger.debug("httpPost: {}", (Object)httpPost);
                    response = httpClient.execute((ClassicHttpRequest)httpPost);
                    try {
                        if (response == null || response.getCode() != 200) break block17;
                        String result = EntityUtils.toString((HttpEntity)response.getEntity());
                        logger.debug("result: {}", (Object)result);
                        jSONObject = jsonObject = JSONObject.parseObject((String)result);
                        if (response == null) return jSONObject;
                    }
                    catch (Throwable throwable) {
                        if (response == null) throw throwable;
                        try {
                            response.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    response.close();
                    return jSONObject;
                }
                if (response != null) {
                    response.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            JSONObject jSONObject = jsonObject;
            return jSONObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new JSONObject();
        }
    }

    private static String GenSign(String secret, Long timestamp) throws NoSuchAlgorithmException, InvalidKeyException {
        String stringToSign = timestamp + "\n" + secret;
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
        byte[] signData = mac.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8));
        return new String(Base64.getEncoder().encode(signData));
    }

    public static void sendMsg(String url, List<String> msgList, String Secret) throws NoSuchAlgorithmException, InvalidKeyException {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        Long timestamp = DateUtil.getTime((Date)DateUtil.getNowDate());
        String sign = WebHookUtil.GenSign(Secret, timestamp);
        params.put(MSG_TYPE, TEXT_MSG_TYPE);
        params.put("timestamp", timestamp);
        params.put("sign", sign);
        HashMap<String, String> contentMap = new HashMap<String, String>();
        params.put(CONTENT_KEY, contentMap);
        StringBuilder stringBuilder = new StringBuilder();
        msgList.forEach(e -> stringBuilder.append(e + "\n"));
        contentMap.put(TEXT_MSG_TYPE, stringBuilder.toString());
        WebHookUtil.doPostForJson(url, JSON.toJSONString(params));
    }

    public static void sendMsgNoSecret(String url, List<String> msgList) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put(MSG_TYPE, TEXT_MSG_TYPE);
        HashMap<String, String> contentMap = new HashMap<String, String>();
        params.put(CONTENT_KEY, contentMap);
        StringBuilder stringBuilder = new StringBuilder();
        msgList.forEach(e -> stringBuilder.append(e + "\n"));
        contentMap.put(TEXT_MSG_TYPE, stringBuilder.toString());
        WebHookUtil.doPostForJson(url, JSON.toJSONString(params));
    }

    public static String sendPostByMap(String url, Map<String, Object> mapParam) {
        HashMap<String, String> headParam = new HashMap<String, String>();
        headParam.put("Content-type", "application/json;charset=UTF-8");
        return WebHookUtil.sendPost(url, mapParam, headParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPost(String url, Map<String, Object> param, Map<String, String> headParam) {
        PrintWriter out = null;
        BufferedReader in = null;
        Object result = "";
        try {
            String line;
            URL realUrl = new URL(url);
            URLConnection conn = realUrl.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Fiddler");
            if (headParam != null) {
                for (Map.Entry<String, String> entry : headParam.entrySet()) {
                    conn.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            conn.setDoOutput(true);
            conn.setDoInput(true);
            out = new PrintWriter(conn.getOutputStream());
            out.print(JSON.toJSONString(param));
            out.flush();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = (String)result + line;
            }
        }
        catch (Exception e) {
            logger.info("\u53d1\u9001 POST \u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + String.valueOf(e));
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public static String sendTextMsg(String msg) {
        JSONObject text = new JSONObject();
        text.put(CONTENT_KEY, (Object)msg);
        JSONObject reqBody = new JSONObject();
        reqBody.put("msgtype", (Object)TEXT_MSG_TYPE);
        reqBody.put(TEXT_MSG_TYPE, (Object)text);
        reqBody.put("safe", (Object)0);
        return reqBody.toString();
    }

    public static JSONObject callWeChatBot(String url, String content) {
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        MediaType mediaType = MediaType.parse((String)APPLICATION_JSON);
        content = WebHookUtil.sendTextMsg(content);
        RequestBody body = RequestBody.create((String)content, (MediaType)mediaType);
        Request request = new Request.Builder().url(url).method("POST", body).addHeader(CONTENT_TYPE, APPLICATION_JSON).build();
        Response response = null;
        Object result = "";
        try {
            String line;
            response = client.newCall(request).execute();
            BufferedReader in = new BufferedReader(new InputStreamReader(response.body().byteStream()));
            while ((line = in.readLine()) != null) {
                result = (String)result + line;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return JSONObject.parseObject((String)result);
    }

    public static JSONObject sendDDMessage(String url, String msg) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        HashMap<String, String> text = new HashMap<String, String>();
        json.put("msgtype", TEXT_MSG_TYPE);
        text.put(CONTENT_KEY, msg);
        json.put(TEXT_MSG_TYPE, text);
        String response = WebHookUtil.sendPostByMap(url, json);
        return JSONObject.parseObject((String)response);
    }

    public static JSONObject sendDingDing(String url, String Secret, String content) {
        try {
            Long timestamp = System.currentTimeMillis();
            String sign = WebHookUtil.GenSign(Secret, timestamp);
            String dingUrl = String.format("%s&timestamp=%d&sign=%s", url, timestamp, URLEncoder.encode(sign, StandardCharsets.UTF_8.toString()));
            boolean isAtAll = true;
            HashMap contentMap = Maps.newHashMap();
            contentMap.put(CONTENT_KEY, content);
            HashMap atMap = Maps.newHashMap();
            atMap.put("isAtAll", isAtAll);
            HashMap<String, Object> reqMap = new HashMap<String, Object>();
            reqMap.put("msgtype", TEXT_MSG_TYPE);
            reqMap.put(TEXT_MSG_TYPE, contentMap);
            reqMap.put("at", atMap);
            String result = WebHookUtil.sendPostByMap(dingUrl, reqMap);
            return JSONObject.parseObject((String)result);
        }
        catch (Exception e) {
            logger.error("\u9489\u9489\u6d88\u606f\u53d1\u9001\u5931\u8d25", (Throwable)e);
            return new JSONObject();
        }
    }
}

