/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.aop;

import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.router.SaRouter;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.database.util.NotTenantPluginHolder;
import com.bringspring.common.database.util.TenantDataSourceUtil;
import com.bringspring.common.properties.GatewayWhite;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.TenantHolder;
import java.util.List;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=1)
public class DataSourceBindAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataSourceBindAspect.class);
    @Autowired
    UserProvider userProvider;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private GatewayWhite gatewayWhite;

    @Pointcut(value="((execution(* com.bringspring.*.controller.*.*(..))) && !execution(* com.bringspring.oauth.controller.LoginController.Login(..)))|| execution(* com.bringspring.system.message.websocket.WebSocket.*(..))")
    public void bindDataSource() {
    }

    @Around(value="bindDataSource() && !@annotation(com.bringspring.common.base.NoDataSourceBind)")
    public Object doAroundService(ProceedingJoinPoint pjp) throws Throwable {
        if (this.configValueUtil.isMultiTenancy()) {
            if (StringUtils.isEmpty((String)TenantHolder.getDatasourceId())) {
                String url = null;
                try {
                    url = SaHolder.getRequest().getRequestPath();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (url != null) {
                    boolean isWhiteUrl;
                    boolean bl = isWhiteUrl = SaRouter.isMatch((List)this.gatewayWhite.excludeUrl, (String)url) || SaRouter.isMatch((List)this.gatewayWhite.whiteUrl, (String)url);
                    if (!isWhiteUrl) {
                        UserInfo userInfo = UserProvider.getUser();
                        log.error("\u672a\u68c0\u6d4b\u5230\u79df\u6237\u4fe1\u606f, Tenant: {}, URL: {}, TOKEN: {}", new Object[]{userInfo.getTenantId(), url, userInfo.getToken()});
                        return null;
                    }
                }
            }
            return pjp.proceed();
        }
        Object obj = pjp.proceed();
        return obj;
    }

    @Around(value="bindDataSource() && @annotation(com.bringspring.common.base.NoDataSourceBind)")
    public Object doAroundService2(ProceedingJoinPoint pjp) throws Throwable {
        try {
            NotTenantPluginHolder.setNotSwitchAlwaysFlag();
            TenantDataSourceUtil.clearLocalTenantInfo();
            Object object = pjp.proceed();
            return object;
        }
        finally {
            NotTenantPluginHolder.clearNotSwitchAlwaysFlag();
        }
    }
}

