/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bringspring.common.annotation.HandleLog;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.model.user.mod.UserAllModel;
import com.bringspring.system.permission.model.userrelation.UserRelationForm;
import com.bringspring.system.permission.model.userrelation.UserRelationIdsVO;
import com.bringspring.system.permission.model.userrelation.UserRelationPagination;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u7528\u6237\u5173\u7cfb", description="UserRelation")
@RestController
@RequestMapping(value={"/api/permission/UserRelation"})
public class UserRelationController {
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserProvider userProvider;

    @Operation(summary="\u83b7\u53d6\u5c97\u4f4d/\u89d2\u8272/\u95e8\u6237\u6210\u5458\u5217\u8868ids")
    @GetMapping(value={"/{objectId}"})
    public ActionResult<UserRelationIdsVO> listTree(@PathVariable(value="objectId") String objectId) {
        List<UserRelationEntity> data = this.userRelationService.getListByObjectId(objectId);
        ArrayList<String> ids = new ArrayList<String>();
        for (UserRelationEntity entity : data) {
            ids.add(entity.getUserId());
        }
        UserRelationIdsVO vo = new UserRelationIdsVO();
        vo.setIds(ids);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u83b7\u53d6\u5c97\u4f4d/\u89d2\u8272/\u95e8\u6237\u6210\u5458\u5217\u8868ids")
    @GetMapping(value={"/getUserByObject/{objectId}"})
    public ActionResult<List<UserAllModel>> getUserByObject(@PathVariable(value="objectId") String objectId) {
        List<UserRelationEntity> data = this.userRelationService.getListByObjectId(objectId);
        ArrayList<String> ids = new ArrayList<String>();
        for (UserRelationEntity entity : data) {
            ids.add(entity.getUserId());
        }
        List<UserEntity> userList = this.userService.getUserName(ids);
        List voListVO = JsonUtil.getJsonToList(userList, UserAllModel.class);
        return ActionResult.success((Object)voListVO);
    }

    @Operation(summary="\u83b7\u53d6\u5c97\u4f4d/\u89d2\u8272/\u95e8\u6237\u6210\u5458\u5217\u8868")
    @GetMapping(value={"/getUserByObjectType/{objectType}"})
    public ActionResult<List<UserAllModel>> getUserByObjectType(@PathVariable(value="objectType") String objectType) {
        List<UserRelationEntity> data = this.userRelationService.getListByObjectId(null, objectType);
        ArrayList<String> ids = new ArrayList<String>();
        for (UserRelationEntity entity : data) {
            ids.add(entity.getUserId());
        }
        List<UserEntity> userList = this.userService.getUserName(ids);
        List voListVO = JsonUtil.getJsonToList(userList, UserAllModel.class);
        return ActionResult.success((Object)voListVO);
    }

    @Operation(summary="\u6dfb\u52a0\u5c97\u4f4d\u6216\u89d2\u8272\u6210\u5458")
    @PostMapping(value={"/{objectId}"})
    public ActionResult save(@PathVariable(value="objectId") String objectId, @RequestBody UserRelationForm userRelationForm) {
        if (userRelationForm.getObjectType().equals("Role")) {
            this.userRelationService.roleSaveByUserIds(objectId, userRelationForm.getUserIds());
        } else if (userRelationForm.getObjectType().equals("Organize")) {
            HashSet<String> set = new HashSet<String>(userRelationForm.getUserIds());
            ArrayList<String> list = new ArrayList<String>(set);
            this.userRelationService.organizeSaveByUserIds(objectId, list);
        } else {
            HashSet<String> set = new HashSet<String>(userRelationForm.getUserIds());
            ArrayList<String> list = new ArrayList<String>(set);
            userRelationForm.setUserIds(list);
            this.userRelationService.saveObjectId(objectId, userRelationForm);
        }
        this.userService.delCurUser(userRelationForm.getUserIds());
        return ActionResult.success((String)MsgCode.SU002.get());
    }

    @RequestMapping(value={"/create"})
    @PostMapping
    @HandleLog(moduleName="\u7528\u6237\u7ba1\u7406", requestMethod="\u6dfb\u52a0\u533a\u57df\u9650\u5236")
    public ActionResult create(@RequestBody UserRelationPagination userRelationPagination) {
        UserInfo userInfo = this.userProvider.get();
        Object collect = "";
        if (ObjectUtil.isNotNull(userRelationPagination.getAddress())) {
            String[] addressStr = userRelationPagination.getAddress().toArray(new String[0]);
            ArrayList<String> list1 = new ArrayList<String>();
            for (String s2 : addressStr) {
                list1.add(s2);
            }
            collect = list1.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(","));
            collect = "[" + (String)collect + "]";
        }
        if (ObjectUtil.isNotNull(userRelationPagination.getUserId())) {
            for (String s3 : userRelationPagination.getUserId()) {
                QueryWrapper userRelationEntityQueryWrapper = new QueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)userRelationEntityQueryWrapper.lambda().eq(UserRelationEntity::getObjectType, (Object)userRelationPagination.getAuthorizeType())).eq(UserRelationEntity::getUserId, (Object)s3)).eq(UserRelationEntity::getObjectId, (Object)((String)collect).replaceAll(" ", ""));
                UserRelationEntity one = (UserRelationEntity)this.userRelationService.getOne((Wrapper)userRelationEntityQueryWrapper);
                if (ObjectUtil.isNotNull((Object)one)) continue;
                UserRelationEntity userRelationEntity = new UserRelationEntity();
                String mainId = RandomUtil.uuId();
                userRelationEntity.setUserId(s3);
                userRelationEntity.setId(mainId);
                userRelationEntity.setObjectType(userRelationPagination.getAuthorizeType());
                userRelationEntity.setObjectId(((String)collect).replaceAll(" ", ""));
                userRelationEntity.setCreatorUserId(userInfo.getUserId());
                userRelationEntity.setCreatorTime(DateUtil.getNowDate());
                this.userRelationService.save(userRelationEntity);
            }
        }
        return ActionResult.success();
    }

    @RequestMapping(value={"/delete"})
    @DSTransactional
    @HandleLog(moduleName="\u7528\u6237\u7ba1\u7406", requestMethod="\u5220\u9664\u533a\u57df\u9650\u5236")
    public ActionResult delete(@RequestBody UserRelationPagination userRelationPagination) {
        String str = userRelationPagination.getUserId().get(0);
        QueryWrapper userRelationEntityQueryWrapper = new QueryWrapper();
        ArrayList<String> ids = new ArrayList<String>();
        if (ObjectUtil.isNotNull(userRelationPagination.getAddress())) {
            ((LambdaQueryWrapper)userRelationEntityQueryWrapper.lambda().eq(UserRelationEntity::getObjectType, (Object)"Area")).eq(UserRelationEntity::getUserId, (Object)str);
            List list = this.userRelationService.list((Wrapper)userRelationEntityQueryWrapper);
            List<String> collect = list.stream().map(UserRelationEntity::getId).collect(Collectors.toList());
            this.userRelationService.delete(collect.toArray(new String[0]));
            return ActionResult.success();
        }
        String[] addressStr = userRelationPagination.getAddress().toArray(new String[0]);
        ArrayList<String> list1 = new ArrayList<String>();
        for (String ss : addressStr) {
            list1.add(ss);
        }
        Object collect = list1.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(", "));
        collect = "[" + (String)collect + "]";
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)userRelationEntityQueryWrapper.lambda().eq(UserRelationEntity::getObjectType, (Object)"Area")).eq(UserRelationEntity::getUserId, (Object)str)).eq(UserRelationEntity::getObjectId, (Object)((String)collect).replaceAll(" ", ""))).or();
        UserRelationEntity user = (UserRelationEntity)this.userRelationService.getOne((Wrapper)userRelationEntityQueryWrapper);
        if (ObjectUtil.isNotNull((Object)user)) {
            Object strTemp = (String)list1.get(0);
            strTemp = "[\"" + (String)strTemp + "\"]";
            UserRelationEntity relationServiceOne = (UserRelationEntity)this.userRelationService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UserRelationEntity::getObjectType, (Object)"Area")).eq(UserRelationEntity::getUserId, (Object)str)).eq(UserRelationEntity::getObjectId, (Object)((String)strTemp).replaceAll(" ", "")));
            ids.add(relationServiceOne.getId());
            this.userRelationService.delete(ids.toArray(new String[0]));
            return ActionResult.success();
        }
        ids.add(user.getId());
        this.userRelationService.delete(ids.toArray(new String[0]));
        return ActionResult.success();
    }

    @RequestMapping(value={"/deleteByUserIdAndObjectType"})
    @DSTransactional
    @HandleLog(moduleName="\u7528\u6237\u7ba1\u7406", requestMethod="\u5220\u9664\u6388\u6743")
    public ActionResult deleteByUserIdAndObjectType(@RequestBody UserRelationPagination userRelationPagination) {
        QueryWrapper userRelationEntityQueryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)userRelationEntityQueryWrapper.lambda().in(UserRelationEntity::getUserId, userRelationPagination.getUserId())).eq(UserRelationEntity::getObjectType, (Object)userRelationPagination.getAuthorizeType());
        this.userRelationService.remove((Wrapper)userRelationEntityQueryWrapper);
        return ActionResult.success();
    }
}

