/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PermissionEntityBase;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.UserCommonEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.mapper.UserCommonMapper;
import com.bringspring.system.permission.model.user.vo.UserIdListVo;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.UserCommonService;
import com.bringspring.system.permission.service.UserService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserCommonServiceImpl
extends ServiceImpl<UserCommonMapper, UserCommonEntity>
implements UserCommonService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private UserService userService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private PositionService positionService;

    @Override
    public List<UserIdListVo> getList() {
        QueryWrapper commonQueryWrapper = new QueryWrapper();
        commonQueryWrapper.lambda().eq(UserCommonEntity::getCreatorUserId, (Object)this.userProvider.get().getUserId());
        commonQueryWrapper.lambda().orderByDesc(UserCommonEntity::getLastModifyTime, new SFunction[]{UserCommonEntity::getCommonNum});
        commonQueryWrapper.last("LIMIT 20");
        List list = this.list((Wrapper)commonQueryWrapper);
        List<String> userIds = list.stream().map(UserCommonEntity::getUserId).collect(Collectors.toList());
        List<UserEntity> userByIds = this.userService.getUserByIds(userIds);
        List<String> organizeIds = userByIds.stream().map(UserEntity::getOrganizeId).collect(Collectors.toList());
        List<OrganizeEntity> organizeList = this.organizeService.getOrganizeName(organizeIds);
        List<String> companyIds = organizeList.stream().map(OrganizeEntity::getOrganizeId).collect(Collectors.toList());
        List<OrganizeEntity> companyList = this.organizeService.getOrganizeName(companyIds);
        organizeList.addAll(companyList);
        ArrayList<UserIdListVo> jsonToList = new ArrayList<UserIdListVo>();
        for (UserEntity entity : userByIds) {
            OrganizeEntity company;
            OrganizeEntity organize;
            if ("0".equals(String.valueOf(entity.getEnabledMark())) || ObjectUtil.isNull((Object)(organize = (OrganizeEntity)organizeList.stream().filter(t -> t.getId().equals(entity.getOrganizeId())).findFirst().orElse(null)))) continue;
            UserCommonEntity userCommonEntity = list.stream().filter(userCommon -> userCommon.getUserId().equals(entity.getId())).findFirst().orElse(null);
            entity.setLastModifyTime(userCommonEntity.getLastModifyTime());
            UserIdListVo userListVo = (UserIdListVo)JsonUtil.getJsonToBean((Object)entity, UserIdListVo.class);
            userListVo.setOrganizeName(StringUtils.isNotEmpty((String)organize.getShortName()) ? organize.getShortName() : organize.getFullName());
            if (ObjectUtil.isNotEmpty((Object)organize.getOrganizeId()) && null != (company = (OrganizeEntity)organizeList.stream().filter(t -> t.getId().equals(organize.getOrganizeId())).findFirst().orElse(null))) {
                userListVo.setCompanyName(StringUtils.isNotEmpty((String)company.getShortName()) ? company.getShortName() : company.getFullName());
            }
            if (StringUtils.isNotEmpty((String)entity.getPositionId())) {
                List<String> positionIds = Arrays.asList(entity.getPositionId().split(","));
                List<PositionEntity> positionList = this.positionService.getPositionList(positionIds);
                String positionNames = positionList.stream().map(PermissionEntityBase::getFullName).collect(Collectors.joining(","));
                userListVo.setPositionName(positionNames);
            }
            jsonToList.add(userListVo);
        }
        List<UserIdListVo> userList = jsonToList.stream().sorted(Comparator.comparing(UserIdListVo::getLastModifyTime).reversed()).collect(Collectors.toList());
        return userList;
    }

    @Override
    public void update(List<String> userIdList) {
        for (String userId : userIdList) {
            QueryWrapper commonQueryWrapper = new QueryWrapper();
            ((LambdaQueryWrapper)commonQueryWrapper.lambda().eq(UserCommonEntity::getCreatorUserId, (Object)this.userProvider.get().getUserId())).eq(UserCommonEntity::getUserId, (Object)userId);
            UserCommonEntity commonEntity = (UserCommonEntity)this.getOne((Wrapper)commonQueryWrapper);
            if (ObjectUtil.isEmpty((Object)commonEntity)) {
                commonEntity = new UserCommonEntity();
                commonEntity.setUserId(userId);
                commonEntity.setId(RandomUtil.uuId());
                this.save(commonEntity);
                continue;
            }
            commonEntity.setCommonNum(commonEntity.getCommonNum() + 1);
            this.updateById(commonEntity);
        }
    }

    @Override
    public void delete(String userId) {
        QueryWrapper commonQueryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)commonQueryWrapper.lambda().eq(UserCommonEntity::getCreatorUserId, (Object)this.userProvider.get().getUserId())).eq(UserCommonEntity::getUserId, (Object)userId);
        ((UserCommonMapper)this.baseMapper).delete((Wrapper)commonQueryWrapper);
    }
}

