package com.bringspring.system.base.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.treeutil.SumTree;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.system.base.entity.ModuleButtonEntity;
import com.bringspring.system.base.model.button.*;
import com.bringspring.system.base.service.ModuleButtonService;
import com.bringspring.system.base.util.JsonUtilEx;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 按钮权限
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Tag(name = "按钮权限")
@RestController
@RequestMapping("/api/system/ModuleButton")
public class ModuleButtonController {

    @Autowired
    private ModuleButtonService moduleButtonService;

    /**
     * 按钮按钮权限列表
     *
     * @param menuId     功能主键
     * @param pagination 分页参数
     * @return ignore
     */
    @Operation(summary="获取按钮权限列表")
    @GetMapping("/{menuId}/List")
    public ActionResult list(@PathVariable("menuId") String menuId, Pagination pagination) {
        List<ModuleButtonEntity> data = moduleButtonService.getList(menuId, pagination);
        List<ButtonTreeListModel> treeList = JsonUtil.getJsonToList(data, ButtonTreeListModel.class);
        List<SumTree<ButtonTreeListModel>> sumTrees = TreeDotUtils.convertListToTreeDot(treeList);
        if (data.size() > sumTrees.size()) {
            List<ButtonTreeListVO> list = JsonUtil.getJsonToList(sumTrees, ButtonTreeListVO.class);
            ListVO<ButtonTreeListVO> treeVo = new ListVO<>();
            treeVo.setList(list);
            return ActionResult.success(treeVo);
        }
        List<ButtonListVO> list = JsonUtil.getJsonToList(treeList, ButtonListVO.class);
        ListVO<ButtonListVO> treeVo1 = new ListVO<>();
        treeVo1.setList(list);
        return ActionResult.success(treeVo1);
    }


    /**
     * 按钮按钮权限列表
     *
     * @param menuId 功能主键
     * @return ignore
     */
    @Operation(summary="获取按钮权限下拉框")
    @GetMapping("/{menuId}/Selector")
    public ActionResult<ListVO<ButtonTreeListVO>> selectList(@PathVariable("menuId") String menuId) {
        List<ModuleButtonEntity> data = moduleButtonService.getList(menuId);
        List<ButtonTreeListModel> treeList = JsonUtil.getJsonToList(data, ButtonTreeListModel.class);
        List<SumTree<ButtonTreeListModel>> sumTrees = TreeDotUtils.convertListToTreeDot(treeList);
        List<ButtonTreeListVO> list = JsonUtil.getJsonToList(sumTrees, ButtonTreeListVO.class);
        ListVO<ButtonTreeListVO> treeVo = new ListVO<>();
        treeVo.setList(list);
        return ActionResult.success(treeVo);
    }


    /**
     * 获取按钮权限信息
     *
     * @param id 主键值
     * @return ignore
     */
    @Operation(summary="获取按钮权限信息")
    @GetMapping("/{id}")
    public ActionResult<ModuleButtonInfoVO> info(@PathVariable("id") String id) throws DataException {
        ModuleButtonEntity entity = moduleButtonService.getInfo(id);
        ModuleButtonInfoVO vo = JsonUtilEx.getJsonToBeanEx(entity, ModuleButtonInfoVO.class);
        return ActionResult.success(vo);
    }

    /**
     * 新建按钮权限
     *
     * @param moduleButtonCrForm 实体对象
     * @return ignore
     */
    @Operation(summary="新建按钮权限")
    @PostMapping
    public ActionResult create(@RequestBody ModuleButtonCrForm moduleButtonCrForm) {
        ModuleButtonEntity entity = JsonUtil.getJsonToBean(moduleButtonCrForm, ModuleButtonEntity.class);
        if (moduleButtonService.isExistByEnCode(entity.getModuleId(), entity.getEnCode(), entity.getId())) {
            return ActionResult.fail(MsgCode.EXIST002.get());
        }
        moduleButtonService.create(entity);
        return ActionResult.success(MsgCode.SU001.get());
    }

    /**
     * 更新按钮权限
     *
     * @param id                 主键值
     * @param moduleButtonUpForm 更新参数
     * @return ignore
     */
    @Operation(summary="更新按钮权限")
    @PutMapping("/{id}")
    public ActionResult update(@PathVariable("id") String id, @RequestBody ModuleButtonUpForm moduleButtonUpForm) {
        ModuleButtonEntity entity = JsonUtil.getJsonToBean(moduleButtonUpForm, ModuleButtonEntity.class);
        if (moduleButtonService.isExistByEnCode(entity.getModuleId(), entity.getEnCode(), id)) {
            return ActionResult.fail(MsgCode.EXIST002.get());
        }
        boolean flag = moduleButtonService.update(id, entity);
        if (flag == false) {
            return ActionResult.success(MsgCode.FA002.get());
        }
        return ActionResult.success(MsgCode.SU004.get());
    }

    /**
     * 删除按钮权限
     *
     * @param id 主键值
     * @return ignore
     */
    @Operation(summary="删除按钮权限")
    @DeleteMapping("/{id}")
    public ActionResult delete(@PathVariable("id") String id) {
        ModuleButtonEntity entity = moduleButtonService.getInfo(id);
        if (entity != null) {
            moduleButtonService.delete(entity);
            return ActionResult.success(MsgCode.SU003.get());
        }
        return ActionResult.fail(MsgCode.FA003.get());
    }

    /**
     * 更新菜单状态
     *
     * @param id 主键值
     * @return ignore
     */
    @Operation(summary="更新菜单状态")
    @PutMapping("/{id}/Actions/State")
    public ActionResult upState(@PathVariable("id") String id) {
        ModuleButtonEntity entity = moduleButtonService.getInfo(id);
        if (entity.getEnabledMark() == null || "1".equals(String.valueOf(entity.getEnabledMark()))) {
            entity.setEnabledMark(0);
        } else {
            entity.setEnabledMark(1);
        }
        boolean flag = moduleButtonService.update(id, entity);
        if (!flag) {
            return ActionResult.success(MsgCode.FA002.get());
        }
        return ActionResult.success(MsgCode.SU004.get());
    }

}
