package com.bringspring.system.base.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 数据权限方案
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Data
@TableName("BASE_MODULE_DATA_AUTHORIZE_SCHEME")
public class ModuleDataAuthorizeSchemeEntity {
    /**
     * 方案主键
     */
    @TableId("ID")
    private String id;

    /**
     * 方案编码
     */
    @TableField("ENCODE")
    private String enCode;

    /**
     * 方案名称
     */
    @TableField("FULL_NAME")
    private String fullName;

    /**
     * 条件规则Json
     */
    @TableField("CONDITION_JSON")
    private String conditionJson;

    /**
     * 条件规则描述
     */
    @TableField("CONDITION_TEXT")
    private String conditionText;

    /**
     * 功能主键
     */
    @TableField("MODULE_ID")
    private String moduleId;

    /**
     * 全部数据标识
     */
    @TableField("ALL_DATA")
    private Integer allData;

    /**
     * 分组匹配逻辑
     */
    @TableField("MATCH_LOGIC")
    private String matchLogic;

    /**
     * 描述
     */
    @TableField("DESCRIPTION")
    private String description;

    /**
     * 排序码
     */
    @TableField("SORT_CODE")
    private Long sortCode;

    /**
     * 有效标志
     */
    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID",fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME",fill = FieldFill.UPDATE)
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID",fill = FieldFill.UPDATE)
    private String lastModifyUserId;

    /**
     * 删除标志
     */
    @TableField("DELETE_MARK")
    private Integer deleteMark;

    /**
     * 删除时间
     */
    @TableField("DELETE_TIME")
    private Date deleteTime;

    /**
     * 删除用户
     */
    @TableField("DELETE_USER_ID")
    private String deleteUserId;

}
