package com.bringspring.system.external.controller;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.system.external.bean.WeComModel;
import com.bringspring.system.external.config.mutil.WxCpConfiguration;
import com.bringspring.system.external.util.JSSDKUtil;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import static com.bringspring.system.message.util.SynThirdConsts.DATA_TYPE_ORG;
import static com.bringspring.system.message.util.SynThirdConsts.THIRD_TYPE_QY;

/**
 * 企业微信 JS-SDK 公共
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2023-06-20
 */
@Slf4j
@RestController
@RequestMapping("/api/jssdk/common")
public class JSSDKCommonController {

    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    WxCpConfiguration wxCpConfiguration;

    /**
     * 获取 配置微信config信息
     *
     * @param url （当前网页的URL，不包含#及其后面部分）
     * @return
     */
    @GetMapping("/getWxConfig")
    public ActionResult list(String url) {
        UserInfo userInfo = userProvider.get();
        if (ObjectUtil.isEmpty(userInfo)) {
            return ActionResult.fail("获取当前登录用户信息失败");
        }

        if (StringUtils.isNotEmpty(url)) {
            // 当前登录用户所属主部门ID
            final String currentOrganizeId = userInfo.getOrganizeId();
            // 所属主部门对应的企业微信ID
            SynThirdInfoEntity synThirdInfoEntity =
                    synThirdInfoService.getInfoBySysObjId(THIRD_TYPE_QY, DATA_TYPE_ORG, currentOrganizeId);
            String corpId = synThirdInfoEntity.getCropId();
            if (StringUtils.isNotEmpty(corpId)) {
                // 获取到系统配置
                final WeComModel weComModel = wxCpConfiguration.getWeComModel(corpId);
                if (weComModel == null) {
                    return ActionResult.fail(String.format("未找到对应corpId=[%s]的配置", corpId));
                } else {
                    // 初始化企业微信设置
                    String qyhCorpId = weComModel.getQyhCorpId();
                    String qyhAgentSecret = weComModel.getQyhAgentSecret();
                    if (StringUtils.isNotEmpty(qyhCorpId) && StringUtils.isNotEmpty(qyhAgentSecret)) {
                        JSSDKUtil.setCorpId(qyhCorpId);
                        JSSDKUtil.setCorpSecret(qyhAgentSecret);
                    }
                    // 获取signature及其他参数信息
                    JSONObject signAndOtherData = JSSDKUtil.getSignAndOtherData(url);
                    return ActionResult.success("获取成功", signAndOtherData);
                }
            } else {
                return ActionResult.fail("获取当前登录用户所属主部门ID关联企业微信ID失败");
            }
        } else {
            return ActionResult.fail("获取失败,herfUrl不能为空.");
        }
    }


}
