package com.bringspring.system.external.task;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.annotation.JsbosTask;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.system.base.entity.SysConfigEntity;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.listener.DIngStream;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.external.bean.WeComModel;
import com.bringspring.system.external.bean.WxCpDepartTreeNode;
import com.bringspring.system.external.config.mutil.WxCpConfiguration;
import com.bringspring.system.external.service.WxCpCorpService;
import com.bringspring.system.external.util.WxCpCorpValidateUtil;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.UserService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpDepart;
import me.chanjar.weixin.cp.bean.WxCpUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

import static com.bringspring.system.external.constant.WxCpSysConfigConsts.WECOM_KEY_NAME;
import static com.bringspring.system.message.util.SynThirdConsts.DATA_TYPE_ORG;
import static com.bringspring.system.message.util.SynThirdConsts.THIRD_TYPE_QY;

/**
 * 同步企业微信组织架构
 * 定时任务
 */
@Component
public class SyncWxCpOraginazeTask {
    private static final Logger logger = LoggerFactory.getLogger(SyncWxCpOraginazeTask.class);

    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    PositionService positionService;
    @Autowired
    private UserService userService;

    @Autowired
    private DIngStream dIngStream;

    @Autowired
    WxCpConfiguration wxCpConfiguration;

    @Autowired
    WxCpCorpValidateUtil wxCpCorpValidateUtil;

    @Autowired
    private WxCpCorpService wxCpCorpService;


    @Autowired
    private SysConfigService sysConfigService;

    /**
     * 重置菜单ParentIds
     */
    @JsbosTask(fullName = "同步企业微信用户信息", description = "同步企业微信用户信息")
    public void syncWxCpUserList() throws BaseException {
        SysConfigEntity weComInfo = sysConfigService.getConfigByKeyName(WECOM_KEY_NAME);

        if (ObjectUtil.isNotEmpty(weComInfo) && StringUtils.isNotEmpty(weComInfo.getKeyValue())) {
            String keyValue = weComInfo.getKeyValue();
            List<WeComModel> listModel = JsonUtil.getJsonToList(keyValue, WeComModel.class);
            for (WeComModel weComModel : listModel) {
                final WxCpService wxCpService = wxCpConfiguration.getCpService(weComModel.getQyhCorpId(), Integer.parseInt(weComModel.getQyhAgentId()));
                if (wxCpService == null) {
                    logger.error(String.format("未找到对应corpId=[%s]、agentId=[%s]的配置，请核实！", weComModel.getQyhCorpId(), weComModel.getQyhAgentId()));
                }

                try {

                    /**
                     * 获取部门成员详情
                     * WxJava接口WxCpUserService的listByDepartment方法有参数：
                     * departId - 必填。部门id
                     * fetchChild - 非必填。1/0：是否递归获取子部门下面的成员
                     * status - 非必填。0获取全部员工，1获取已关注成员列表，2获取禁用成员列表，4获取未关注成员列表。status可叠加
                     *
                     * 所以利用企业微信通讯录“不允许删除根部门”且“根部门ID为1”的特点，获取全部员工。
                     */
                    Long departId = 1L; // 根部门ID
                    boolean fetchChild = true; // 递归获取子部门下面的成员
                    Integer status = 0; // 获取全部员工
                    List<WxCpUser> users = wxCpService.getUserService().listByDepartment(departId, fetchChild, status);
                    if (users == null || users.size() == 0) {
                        logger.error("企业微信通讯录员工信息为空");
                    }

                    wxCpCorpService.saveOrUpdateUserList(users, wxCpService);
                    //获取结果
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     * 重置菜单ParentIds
     */
    @JsbosTask(fullName = "同步企业微信部门信息", description = "同步企业微信部门信息")
    public void syncWxCpDepartmentList() throws BaseException {
        SysConfigEntity weComInfo = sysConfigService.getConfigByKeyName(WECOM_KEY_NAME);

        if (ObjectUtil.isNotEmpty(weComInfo) && StringUtils.isNotEmpty(weComInfo.getKeyValue())) {
            String keyValue = weComInfo.getKeyValue();
            List<WeComModel> listModel = JsonUtil.getJsonToList(keyValue, WeComModel.class);
            for (WeComModel weComModel : listModel) {
                final WxCpService wxCpService = wxCpConfiguration.getCpService(weComModel.getQyhCorpId(), Integer.parseInt(weComModel.getQyhAgentId()));


                if (wxCpService == null) {
                    logger.error(String.format("未找到对应corpId=[%s]、agentId=[%s]的配置，请核实！", weComModel.getQyhCorpId(), weComModel.getQyhAgentId()));
                }
                try {
                    /**
                     * 第一步：获取部门列表
                     */
                    // 获取部门列表
                    List<WxCpDepart> departList = wxCpService.getDepartmentService().list(null);
                    if (departList == null || departList.size() == 0) {
                        logger.error( "企业微信通讯录部门信息为空");
                    }
                    Long parentid = 0L; // 企业微信默认顶级节点不允许删除，且顶级节点的父级ID为0.
                    SynThirdInfoEntity parentThird = null;
                    if (StringUtils.isNotEmpty(weComModel.getOrgParent())) {
                        // 组织上级，配置的手动维护好的企业上级组织部门。
                        parentThird = synThirdInfoService.getInfoBySysObjId(THIRD_TYPE_QY, DATA_TYPE_ORG,
                                weComModel.getOrgParent());
                        if (ObjectUtil.isNotEmpty(parentThird) && StringUtils.isNotEmpty(parentThird.getThirdObjectId())) {
                            parentid = Long.valueOf(parentThird.getThirdObjectId());
                        }
                    }
                    List<WxCpDepartTreeNode> treeList = JsonUtil.getJsonToList(departList, WxCpDepartTreeNode.class);
                    List<WxCpDepartTreeNode> wxCpDepartTreeNodes = wxCpCorpService.deptListToTree(treeList, parentid);
                    /**
                     * 保存到本地
                     */
                    wxCpCorpService.saveOrUpdateOrganizeList(wxCpDepartTreeNodes, weComModel.getQyhCorpId(), parentThird);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}
