package com.bringspring.system.msgcenter.constant;

/**
 * 工具类拆分常量的类型和用途
 */
public final class Constants {

    private Constants() {
    } // 防止实例化

    // 分隔符常量
    public static final class Delimiters {
        private Delimiters() {} // 私有构造函数
        public static final String VERTICAL = "|";
        public static final String COMMA = ",";
        public static final String HYPHEN = "-";
        public static final String DOT_REGEX = "\\.";
        public static final String VERTICAL_REGEX = "\\|";
    }

    // 状态枚举
    public enum ReadStatus {
        UNREAD(0), READ(1);
        private final int code;

        ReadStatus(int code) {
            this.code = code;
        }

        public int getCode() {
            return code;
        }
    }

    // 配置相关常量
    public static final class MessageConfig {
        private MessageConfig() {} // 私有构造函数
        public static final String ALL_USERS = "@ALL";
        public static final String DEFAULT_TEMPLATE = "default_templtate";
        public static final String MSG_ID = "msg_id";
        public static final String MSG_FORMAT = "JSON";
        public static final String SMS_OK = "Ok";
    }

    // 重试策略
    public static final class RetryPolicy {
        private RetryPolicy() {} // 私有构造函数
        public static final int MAX_AUTO_RETRY = 3;
    }

    // 状态开关枚举
    public enum SslStatus {
        ON("开"), OFF("关");
        private final String display;

        SslStatus(String display) {
            this.display = display;
        }

        public String getDisplay() {
            return display;
        }
    }

    public enum EnableStatus {
        ENABLED("启用"), DISABLED("禁用");
        private final String display;

        EnableStatus(String display) {
            this.display = display;
        }

        public String getDisplay() {
            return display;
        }
    }

    // 唯一性标识
    public static final class Uniqueness {
        private Uniqueness() {} // 私有构造函数
        public static final boolean UNIQUE = true;
        public static final boolean NOT_UNIQUE = false;
    }

    // 缓存相关
    public static final class CacheKeys {
        private CacheKeys() {} // 私有构造函数
        public static final String BLACKLIST = "mcBlacklist";
        public static final String SENSITIVE_WORDS = "mcSensitive";
    }
}