package com.bringspring.system.msgcenter.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.DeleteMarkEnum;
import com.bringspring.common.base.EnabledMarkEnum;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.msgcenter.entity.*;
import com.bringspring.system.msgcenter.model.mcbusiness.McBusinessCrForm;
import com.bringspring.system.msgcenter.model.mcbusiness.McBusinessInfoVO;
import com.bringspring.system.msgcenter.model.mcbusiness.McBusinessUpForm;
import com.bringspring.system.msgcenter.model.mcbusinesskeyword.McBusinessKeywordModel;
import com.bringspring.system.msgcenter.model.mcmsgsend.McMsgSendPagination;
import com.bringspring.system.msgcenter.model.mcmsgsendaggregation.*;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.model.mcmsgtemplatefield.McMsgTemplateFieldModel;
import com.bringspring.system.msgcenter.service.*;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import static com.bringspring.system.msgcenter.constant.DictType.MSG_TYPE;

/**
 * 消息发送配置及模板配置
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2024-06-12
 */
@Slf4j
@RestController
@Tag(name = "消息发送配置及模板配置")
@RequestMapping("/api/msgCenter/mcMsgSendAggregation")
public class McMsgSendAggregationController {

    @Autowired
    private BaseDataUtil baseDataUtil;

    @Autowired
    private McMsgSendService mcMsgSendService;

    @Autowired
    private McMsgSendTemplateService mcMsgSendTemplateService;

    @Autowired
    private McBusinessService mcBusinessService;
    @Autowired
    private McBusinessKeywordService mcBusinessKeywordService;
    @Autowired
    private McMsgTemplateService mcMsgTemplateService;
    @Autowired
    private McMsgTemplateFieldService mcMsgTemplateFieldService;
    @Autowired
    private McMsgAccountService mcMsgAccountService;

    private String tempalteName = "【%s】模板";
    private String tempalteCode = "%s_";

    /**
     * 列表
     *
     * @param mcMsgSendPagination
     * @return
     */
    @PostMapping("/getList")
    public ActionResult list(@RequestBody McMsgSendPagination mcMsgSendPagination) throws IOException {
        List<McMsgSendEntity> list = mcMsgSendService.getList(mcMsgSendPagination);
        List<McMsgSendAggregationListVO> listVO = JsonUtil.getJsonToList(list, McMsgSendAggregationListVO.class);
        for (McMsgSendAggregationListVO vo : listVO) {
            //处理id字段转名称，若无需转或者为空可删除
            List<McMsgSendTemplateEntity> sendTempList = mcMsgSendService.getMcMsgSendTemplateList(vo.getId(), 1);
            List<McMsgSendTemplateModel> modelList = JsonUtil.getJsonToList(sendTempList, McMsgSendTemplateModel.class);
            vo.setSendTemplateList(modelList);
        }

        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = JsonUtil.getJsonToBean(mcMsgSendPagination, PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success(vo);
    }

    /**
     * 列表
     *
     * @param mcMsgSendPagination
     * @return
     */
    @PostMapping("/getListAll")
    public ActionResult getListAll(@RequestBody McMsgSendPagination mcMsgSendPagination) throws IOException {
        List<McMsgSendEntity> list = mcMsgSendService.getListAll(mcMsgSendPagination);
        List<McMsgSendAggregationListVO> listVO = JsonUtil.getJsonToList(list, McMsgSendAggregationListVO.class);
        for (McMsgSendAggregationListVO vo : listVO) {
            //处理id字段转名称，若无需转或者为空可删除
            List<McMsgSendTemplateEntity> sendTempList = mcMsgSendService.getMcMsgSendTemplateList(vo.getId(), 1);
            List<McMsgSendTemplateModel> modelList = JsonUtil.getJsonToList(sendTempList, McMsgSendTemplateModel.class);
            vo.setSendTemplateList(modelList);
        }

        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = JsonUtil.getJsonToBean(mcMsgSendPagination, PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success(vo);
    }


    /**
     * 创建
     *
     * @param crForm
     * @return
     */
    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid McMsgSendAggregationCrForm crForm) throws DataException {
        // 校验编码是否存在重复
        if (!mcMsgSendService.checkEnCodeUnique(crForm.getEnCode(), null)) {
            return ActionResult.fail("编码已存在");
        }
        // 校验名称是否存在重复
        if (!mcMsgSendService.checkFullNameUnique(crForm.getFullName(), null)) {
            return ActionResult.fail("名称已存在");
        }

        // 发送配置编号
        String enCode = crForm.getEnCode();
        // 发送配置名称
        String fullName = crForm.getFullName();
        String businessCode = enCode;
        String businessName = fullName;
        String templateEnCode = String.format(this.tempalteCode, enCode);
        String tempalteFullName = String.format(this.tempalteName, fullName);

        /* == 场景配置 == */
        McBusinessCrForm mcBusinessCrForm = crForm.getBusiness();
        McBusinessEntity businessEntity = JsonUtil.getJsonToBean(mcBusinessCrForm, McBusinessEntity.class);
        String businessId = RandomUtil.uuId();
        businessEntity.setId(businessId); // 场景id
        businessEntity.setEnCode(businessCode); // 场景编码
        businessEntity.setFullName(businessName); // 场景名称
        businessEntity.setEnabledMark(EnabledMarkEnum.ENABLE.getCode()); // 状态：启用
        businessEntity.setDeleteMark(DeleteMarkEnum.NOT_DELETE.getCode()); // 删除状态：否
        mcBusinessService.save(businessEntity); /* == 持久化 场景 == */
        // 子表数据插入
        List<McBusinessKeywordEntity> keywordList =
                JsonUtil.getJsonToList(mcBusinessCrForm.getKeywordList(), McBusinessKeywordEntity.class);
        for (McBusinessKeywordEntity entitys : keywordList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setBusinessCode(businessEntity.getEnCode());
            mcBusinessKeywordService.save(entitys);
        }
        /* == 消息模板配置 == */
        List<McMsgSendTemplateEntity> sendTemplateEntityList = new ArrayList<>();
        List<TemplateCrForm> templateList = crForm.getTemplateList();
        for (int i = 0; i < templateList.size(); i++) {
            TemplateCrForm item = templateList.get(i);
            McMsgTemplateEntity entity = JsonUtil.getJsonToBean(item, McMsgTemplateEntity.class);
            String templateId = RandomUtil.uuId();
            entity.setId(templateId); // 模板id
            entity.setEnCode(templateEnCode + i); // 模板编码
            entity.setFullName(tempalteFullName + i); // 模板名称
            entity.setTemplateType("0"); // 模板类型：自定义模板
            entity.setMessageSource(businessCode); // 消息场景
            entity.setEnabledMark(EnabledMarkEnum.ENABLE.getCode()); // 状态：启用
            mcMsgTemplateService.save(entity); /* == 持久化 消息模板 == */
            // 子表数据插入
            List<McMsgTemplateFieldEntity> fieldList =
                    JsonUtil.getJsonToList(item.getFieldList(), McMsgTemplateFieldEntity.class);
            for (McMsgTemplateFieldEntity entitys : fieldList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setTemplateId(entity.getId());
                mcMsgTemplateFieldService.save(entitys);  /* == 持久化 消息模板变量 == */
            }

            if (StringUtils.isNotEmpty(item.getSendEnabledMark()) && "1".equals(item.getSendEnabledMark())) {
                /* == 发送配置消息模板 == */
                List<McMsgSendTemplateModel> sendTemplateList = item.getSendTemplateList();
                if (CollectionUtil.isNotEmpty(sendTemplateList)) {
                    sendTemplateList.stream().forEach(t -> {
                        McMsgSendTemplateEntity sendTemplateEntity = new McMsgSendTemplateEntity();
                        sendTemplateEntity.setMessageType(entity.getMessageType()); // 消息渠道
                        sendTemplateEntity.setTemplateId(templateId); // 消息模板id
                        sendTemplateEntity.setAccountConfigId(t.getAccountConfigId()); // 应用账号id
                        sendTemplateEntity.setEnabledMark(EnabledMarkEnum.ENABLE.getCode()); // 状态：启用
                        sendTemplateEntityList.add(sendTemplateEntity);
                    });
                }
            }
        }

        /* == 发送配置 == */
        McMsgSendEntity sendEntity = JsonUtil.getJsonToBean(crForm, McMsgSendEntity.class);
        String sendId = RandomUtil.uuId();
        sendEntity.setId(sendId);
        sendEntity.setTemplateType("0"); // 模板类型：自定义模板
        sendEntity.setMessageSource(businessCode); // 消息场景
        sendEntity.setEnabledMark(EnabledMarkEnum.ENABLE.getCode()); // 状态：启用
        sendEntity.setSortCode(0L);
        mcMsgSendService.save(sendEntity);  /* == 持久化 发送配置 == */
        if (CollectionUtil.isNotEmpty(sendTemplateEntityList)) {
            // 子表数据插入
            for (McMsgSendTemplateEntity entitys : sendTemplateEntityList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setSendConfigId(sendId); // 发送配置id
                mcMsgSendTemplateService.save(entitys);
            }
        }
        return ActionResult.success("创建成功");
    }


    /**
     * 信息
     *
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    public ActionResult<McMsgSendAggregationInfoVO> info(@PathVariable("id") String id) {
        /* == 发送配置 == */
        McMsgSendEntity entity = mcMsgSendService.getInfo(id);
        McMsgSendAggregationInfoVO vo = JsonUtil.getJsonToBean(entity, McMsgSendAggregationInfoVO.class);
        String businessCode = vo.getMessageSource(); // 消息场景enCode
        /* == 消息场景 == */
        McBusinessInfoVO business = mcBusinessService.getInfoByEnCode(businessCode);
        // 子表数据转换
        List<McBusinessKeywordEntity> keywords = mcBusinessService.getMcBusinessKeywordList(business.getEnCode());
        List<McBusinessKeywordModel> keywordList = JsonUtil.getJsonToList(keywords, McBusinessKeywordModel.class);
        business.setKeywordList(keywordList);
        vo.setBusiness(business);
        /* == 消息模板配置 == */
        List<McMsgTemplateEntity> templateEntities = mcMsgTemplateService.getInfoByCode(businessCode);
        List<TemplateInfoVO> templateVOList = JsonUtil.getJsonToList(templateEntities, TemplateInfoVO.class);
        templateVOList.stream().forEach(item -> {
            item.setMessageTypeName(baseDataUtil.getDictName(item.getMessageType(), MSG_TYPE.getCode()));
            // 子表数据转换
            String templateId = item.getId();
            List<McMsgTemplateFieldEntity> fieldList = mcMsgTemplateService.getMcMsgTemplateFieldList(templateId);
            item.setFieldList(JsonUtil.getJsonToList(fieldList, McMsgTemplateFieldModel.class));
            /* == 发送配置消息模板 == */
            List<McMsgSendTemplateEntity> sendTempList = mcMsgSendService.getMcMsgSendTemplateList(id, templateId, 1);
            if (CollectionUtil.isNotEmpty(sendTempList)) {
                item.setSendEnabledMark("1");
                List<McMsgSendTemplateModel> modelList = JsonUtil.getJsonToList(sendTempList,
                        McMsgSendTemplateModel.class);
                modelList.stream().forEach(m -> {
                    if (StringUtils.isNotEmpty(m.getAccountConfigId())) {
                        McMsgAccountEntity accountInfo = mcMsgAccountService.getInfo(m.getAccountConfigId());
                        m.setAccountName(accountInfo != null ? accountInfo.getFullName() : null);
                        m.setAccountEnCode(accountInfo != null ? accountInfo.getEnCode() : null);
                    }
                });
                item.setSendTemplateList(modelList);
            } else {
                item.setSendEnabledMark("0");
                item.setSendTemplateList(new ArrayList<>());
            }
        });
        vo.setTemplateList(templateVOList);
        return ActionResult.success(vo);
    }

    /**
     * 更新
     *
     * @param id
     * @return
     */
    @PutMapping("/{id}")
    @DSTransactional
    public ActionResult update(@PathVariable("id") String id, @RequestBody @Valid McMsgSendAggregationUpForm upForm) throws DataException {
        // 校验编码是否存在重复
        if (!mcMsgSendService.checkEnCodeUnique(upForm.getEnCode(), id)) {
            return ActionResult.fail("编码已存在");
        }
        // 校验名称是否存在重复
        if (!mcMsgSendService.checkFullNameUnique(upForm.getFullName(), id)) {
            return ActionResult.fail("名称已存在");
        }

        McMsgSendEntity sendentity = mcMsgSendService.getInfo(id);
        if (sendentity != null) {
            // 发送配置编号
            String enCode = upForm.getEnCode();
            // 发送配置名称
            String fullName = upForm.getFullName();
            String businessCode = enCode;
            String templateEnCode = String.format(this.tempalteCode, enCode);
            String tempalteFullName = String.format(this.tempalteName, fullName);

            /* == 场景配置 == */
            McBusinessUpForm mcBusinessUpForm = upForm.getBusiness();
            McBusinessEntity businessEntity = JsonUtil.getJsonToBean(mcBusinessUpForm, McBusinessEntity.class);
            // 子表数据删除重新插入
            QueryWrapper<McBusinessKeywordEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.lambda().eq(McBusinessKeywordEntity::getBusinessCode, businessEntity.getEnCode());
            mcBusinessKeywordService.remove(queryWrapper);
            List<McBusinessKeywordEntity> keywordList =
                    JsonUtil.getJsonToList(mcBusinessUpForm.getKeywordList(), McBusinessKeywordEntity.class);
            for (McBusinessKeywordEntity entitys : keywordList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setBusinessCode(businessEntity.getEnCode());
                mcBusinessKeywordService.save(entitys);
            }
            mcBusinessService.updateById(businessEntity); /* == 持久化 场景 == */
            /* == 消息模板配置 == */
            List<McMsgSendTemplateEntity> sendTemplateEntityList = new ArrayList<>();
            List<TemplateUpForm> templateList = upForm.getTemplateList();
            for (int i = 0; i < templateList.size(); i++) {
                TemplateUpForm item = templateList.get(i);
                String messageType = item.getMessageType();
                String templateId = item.getId();
                if (StringUtils.isNotEmpty(templateId)) {
                    McMsgTemplateEntity entity = JsonUtil.getJsonToBean(item, McMsgTemplateEntity.class);
                    entity.setEnCode(templateEnCode + i); // 模板编码
                    entity.setFullName(tempalteFullName + i); // 模板名称
                    mcMsgTemplateService.updateById(entity); /* == 持久化 消息模板 == */
                    // 子表数据删除重新插入
                    QueryWrapper<McMsgTemplateFieldEntity> fieldQueryWrapper = new QueryWrapper<>();
                    fieldQueryWrapper.lambda().eq(McMsgTemplateFieldEntity::getTemplateId, templateId);
                    mcMsgTemplateFieldService.remove(fieldQueryWrapper);

                    List<McMsgTemplateFieldEntity> fieldList =
                            JsonUtil.getJsonToList(item.getFieldList(), McMsgTemplateFieldEntity.class);
                    for (McMsgTemplateFieldEntity entitys : fieldList) {
                        entitys.setId(RandomUtil.uuId());
                        entitys.setTemplateId(templateId);
                        mcMsgTemplateFieldService.save(entitys);  /* == 持久化 消息模板变量 == */
                    }


                } else {
                    McMsgTemplateEntity entity = JsonUtil.getJsonToBean(item, McMsgTemplateEntity.class);
                    templateId = RandomUtil.uuId();
                    entity.setId(templateId); // 模板id
                    entity.setEnCode(tempalteCode + i); // 模板编码
                    entity.setFullName(tempalteName + i); // 模板名称
                    entity.setTemplateType("0"); // 模板类型：自定义模板
                    entity.setMessageSource(businessCode); // 消息场景
                    entity.setEnabledMark(EnabledMarkEnum.ENABLE.getCode()); // 状态：启用
                    mcMsgTemplateService.save(entity); /* == 持久化 消息模板 == */
                    // 子表数据插入
                    List<McMsgTemplateFieldEntity> fieldList =
                            JsonUtil.getJsonToList(item.getFieldList(), McMsgTemplateFieldEntity.class);
                    for (McMsgTemplateFieldEntity entitys : fieldList) {
                        entitys.setId(RandomUtil.uuId());
                        entitys.setTemplateId(templateId);
                        mcMsgTemplateFieldService.save(entitys);  /* == 持久化 消息模板变量 == */
                    }
                }


                if (StringUtils.isNotEmpty(item.getSendEnabledMark()) && "1".equals(item.getSendEnabledMark())) {
                    /* == 发送配置消息模板 == */
                    List<McMsgSendTemplateModel> sendTemplateList = item.getSendTemplateList();
                    if (CollectionUtil.isNotEmpty(sendTemplateList)) {
                        for (McMsgSendTemplateModel template : sendTemplateList) {
                            McMsgSendTemplateEntity sendTemplateEntity = new McMsgSendTemplateEntity();
                            sendTemplateEntity.setMessageType(messageType); // 消息渠道
                            sendTemplateEntity.setTemplateId(templateId); // 消息模板id
                            sendTemplateEntity.setAccountConfigId(template.getAccountConfigId()); // 应用账号id
                            sendTemplateEntity.setEnabledMark(EnabledMarkEnum.ENABLE.getCode()); // 状态：启用
                            sendTemplateEntityList.add(sendTemplateEntity);
                        }
                    }
                }
            }

            /* == 发送配置 == */
            McMsgSendEntity sendEntity = JsonUtil.getJsonToBean(upForm, McMsgSendEntity.class);
            sendEntity.setId(id);
            mcMsgSendService.updateById(sendEntity);  /* == 持久化 发送配置 == */
            // 子表数据删除重新插入
            QueryWrapper<McMsgSendTemplateEntity> sendTemplatequeryWrapper = new QueryWrapper<>();
            sendTemplatequeryWrapper.lambda().eq(McMsgSendTemplateEntity::getSendConfigId, sendEntity.getId());
            mcMsgSendTemplateService.remove(sendTemplatequeryWrapper);
            for (McMsgSendTemplateEntity entitys : sendTemplateEntityList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setSendConfigId(sendEntity.getId()); // 发送配置id
                mcMsgSendTemplateService.save(entitys);
            }
            return ActionResult.success("更新成功");
        } else {
            return ActionResult.fail("更新失败，数据不存在");
        }
    }


    /**
     * 删除
     *
     * @param id
     * @return
     */
    @DeleteMapping("/{id}")
    @DSTransactional
    public ActionResult delete(@PathVariable("id") String id) {
        McMsgSendEntity entity = mcMsgSendService.getInfo(id);
        if (entity != null) {
            String messageSource = entity.getMessageSource();
            // 场景管理
            QueryWrapper<McBusinessEntity> businessQueryWrapper = new QueryWrapper<>();
            businessQueryWrapper.lambda().eq(McBusinessEntity::getEnCode, messageSource);
            mcBusinessService.remove(businessQueryWrapper);
            // 子表
            QueryWrapper<McBusinessKeywordEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.lambda().eq(McBusinessKeywordEntity::getBusinessCode, messageSource);
            mcBusinessKeywordService.remove(queryWrapper);

            // 消息模板
            QueryWrapper<McMsgTemplateEntity> templateQueryWrapper = new QueryWrapper<>();
            templateQueryWrapper.lambda().eq(McMsgTemplateEntity::getMessageSource, messageSource);
            List<McMsgTemplateEntity> list = mcMsgTemplateService.list(templateQueryWrapper);
            list.stream().forEach(item -> {
                mcMsgTemplateService.removeById(item.getId());
                // 子表
                QueryWrapper<McMsgTemplateFieldEntity> fieldQueryWrapper = new QueryWrapper<>();
                fieldQueryWrapper.lambda().eq(McMsgTemplateFieldEntity::getTemplateId, item.getId());
                mcMsgTemplateFieldService.remove(fieldQueryWrapper);
            });

            // 发送配置
            mcMsgSendService.removeById(entity.getId());
            // 子表
            QueryWrapper<McMsgSendTemplateEntity> queryWrapperMcMsgSendTemplate = new QueryWrapper<>();
            queryWrapperMcMsgSendTemplate.lambda().eq(McMsgSendTemplateEntity::getSendConfigId, entity.getId());
            mcMsgSendTemplateService.remove(queryWrapperMcMsgSendTemplate);
        }
        return ActionResult.success("删除成功");
    }

}
