package com.bringspring.system.msgcenter.enums;

/**
 * 消息内容类型枚举
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2021/4/23 17:45
 */
public enum ContentTypeEnum {
    /**
     * 文本消息
     */
    TEXT_MSG("textmsg", "文本消息"),
    /**
     * 链接消息
     */
    LINK_MSG("linkmsg", "链接消息"),
    /**
     * 图文消息
     */
    IMG_TEXT_MSG("imgtextmsg", "图文消息");

    private String code;
    private String content;

    ContentTypeEnum(String code, String content) {
        this.code = code;
        this.content = content;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    /**
     * 根据状态code获取枚举值
     *
     * @return
     */
    public static ContentTypeEnum getByCode(String code) {
        for (ContentTypeEnum status : ContentTypeEnum.values()) {
            if (status.getCode().equals(code)) {
                return status;
            }
        }
        return null;
    }
}
