package com.bringspring.system.msgcenter.enums;

/**
 * mc_task_msg_receive表 enabledMark 字段枚举类
 *
 * @版本： V1.0.0
 * @日期： 2021/4/23 17:45
 */
public enum EnabledMarkEnum {
    /**
     * 待下发
     */
    WAIT(0, "待下发"),
    /**
     * 下/重发成功
     */
    SUCCESS(1, "成功"),
    /**
     * 下/重发失败
     */
    FAIL(2, "失败");

    private Integer code;
    private String lable;

    EnabledMarkEnum(Integer code, String lable) {
        this.code = code;
        this.lable = lable;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getLable() {
        return lable;
    }

    public void setLable(String lable) {
        this.lable = lable;
    }

    /**
     * 根据状态code获取枚举值
     *
     * @return
     */
    public static EnabledMarkEnum getByCode(Integer code) {
        for (EnabledMarkEnum v : EnabledMarkEnum.values()) {
            if (v.getCode().equals(code)) {
                return v;
            }
        }
        return null;
    }
}
