package com.bringspring.system.msgcenter.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 消息链接多端类型 1:支持app端；2:支持pc端；3:支持app和pc端
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2021/4/23 17:45
 */
public enum TermTypeEnum {
    TERM_APP("1", "支持app端"),
    TERM_PC("2", "支持pc端"),
    TERM_APP_PC("3", "支持app和pc端");

    private String code;
    private String type;

    TermTypeEnum(String code, String type) {
        this.code = code;
        this.type = type;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    /**
     * 根据状态code获取枚举值
     *
     * @return
     */
    public static TermTypeEnum getByCode(String code) {
        for (TermTypeEnum status : TermTypeEnum.values()) {
            if (status.getCode().equals(code)) {
                return status;
            }
        }
        return null;
    }

    public static Map<String, TermTypeEnum> getAllToMap() {
        Map<String, TermTypeEnum> map = new HashMap<>();
        for (TermTypeEnum alarmType : values()) {
            map.put(alarmType.getCode(), alarmType);
        }
        return map;
    }
}
