package com.bringspring.system.msgcenter.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * mc_task_msg 表 toType 字段枚举类
 *
 * @版本： V1.0.0
 * @日期： 2021/4/23 17:45
 */
public enum ToTypeEnum {
    USER("1", "指定用户"),
    DEPT("2", "指定部门"),
    ALL_USER("3", "全员"),
    NON_USER("4", "非系统用户");

    private String code;
    private String type;

    ToTypeEnum(String code, String type) {
        this.code = code;
        this.type = type;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    /**
     * 根据状态code获取枚举值
     *
     * @return
     */
    public static ToTypeEnum getByCode(String code) {
        for (ToTypeEnum status : ToTypeEnum.values()) {
            if (status.getCode().equals(code)) {
                return status;
            }
        }
        return null;
    }

    public static Map<String, ToTypeEnum> getAllToMap() {
        Map<String, ToTypeEnum> map = new HashMap<>();
        for (ToTypeEnum alarmType : values()) {
            map.put(alarmType.getCode(), alarmType);
        }
        return map;
    }
}
