package com.bringspring.system.msgcenter.exception;

import com.bringspring.system.msgcenter.enums.ResultCode;
import lombok.Getter;

/**
 * 自定义异常
 */
@Getter
public class MsgCenterException extends RuntimeException {
    /**
     * http状态码
     */
    private int code;

    private transient Object object;

    public MsgCenterException(String message, int code, Object object) {
        super(message);
        this.code = code;
        this.object = object;
    }

    public MsgCenterException(ResultCode resultCode) {
        this.code = resultCode.getCode();
        this.object = resultCode.getMessage();
    }

    public MsgCenterException(ResultCode resultCode, String message) {
        this.code = resultCode.getCode();
        this.object = message;
    }

    public MsgCenterException(String message) {
        super(message);
    }
}
