package com.bringspring.system.msgcenter.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.system.msgcenter.entity.McBusinessEntity;
import com.bringspring.system.msgcenter.entity.McBusinessKeywordEntity;
import com.bringspring.system.msgcenter.model.mcbusiness.McBusinessCrForm;
import com.bringspring.system.msgcenter.model.mcbusiness.McBusinessInfoVO;
import com.bringspring.system.msgcenter.model.mcbusiness.McBusinessPagination;
import com.bringspring.system.msgcenter.model.mcbusiness.McBusinessUpForm;

import java.util.List;

/**
 * 消息业务场景信息
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2024-06-06
 */
public interface McBusinessService extends IService<McBusinessEntity> {

    List<McBusinessEntity> getList(McBusinessPagination mcBusinessPagination);

    List<McBusinessEntity> getTypeList(McBusinessPagination mcBusinessPagination, String dataType);


    McBusinessEntity getInfo(String id);

    McBusinessInfoVO getInfoByEnCode(String enCode);

    void delete(McBusinessEntity entity);

    void create(McBusinessCrForm mcBusinessCrForm);

    boolean update(String id, McBusinessUpForm mcBusinessUpForm);

    //  子表方法
    List<McBusinessKeywordEntity> getMcBusinessKeywordList(String enCode);

    /**
     * 校验编码code的唯一
     *
     * @return 结果
     */
    boolean checkEnCodeUnique(String enCode, String id);
    /**
     * 校验名称的唯一
     *
     * @return 结果
     */
    boolean checkFullNameUnique(String fullName, String id);
}
