package com.bringspring.system.msgcenter.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.common.base.UserInfo;
import com.bringspring.system.msgcenter.entity.McTaskMsgEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.model.mctaskmsgreceive.McTaskMsgReceiveCrForm;
import com.bringspring.system.msgcenter.model.mctaskmsgreceive.McTaskMsgReceiveListQuery;
import com.bringspring.system.msgcenter.model.mctaskmsgreceive.McTaskMsgReceivePagination;
import com.bringspring.system.msgcenter.model.mctaskmsgreceive.McTaskMsgReceiveUpForm;
import com.bringspring.system.msgcenter.service.context.SendReceiveParam;
import me.chanjar.weixin.common.error.WxErrorException;

import java.util.List;
import java.util.Map;

/**
 * 业务场景消息接收记录表
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2024-06-14
 */
public interface McTaskMsgReceiveService extends IService<McTaskMsgReceiveEntity> {

    List<McTaskMsgReceiveEntity> getList(McTaskMsgReceivePagination pagination);

    List<McTaskMsgReceiveEntity> getList(McTaskMsgReceiveListQuery listQuery);

    List<McTaskMsgReceiveEntity> getTypeList(McTaskMsgReceivePagination mcTaskMsgReceivePagination, String dataType);

    McTaskMsgReceiveEntity getInfo(String id);

    void delete(Integer deleteMark, List<String> ids);

    void create(McTaskMsgReceiveCrForm mcTaskMsgReceiveCrForm);

    boolean update(String id, McTaskMsgReceiveUpForm mcTaskMsgReceiveUpForm);

    /**
     * 根据message_receive数据，渠道消息下发
     *
     * @param sendReceiveParam 线程参数传递
     */
    void postSendReceive(SendReceiveParam sendReceiveParam);

    /**
     * 重发消息
     *
     * @param list
     * @return
     */
    void againSendMessage(McTaskMsgEntity taskMsgInfo, List<McTaskMsgReceiveEntity> list) throws WxErrorException;

    /**
     * 自动重发
     * 未成功发送的渠道消息，自动尝试重发
     */
    void autoAgainSendMessage();

    void updateByList(boolean isAgain, List<McTaskMsgReceiveEntity> list, Integer enabledMark, String remark,
                      UserInfo currentUserInfo);

    /**
     * 黑名单接收人 保存失败且忽略失败 处理
     *
     * @param receiveBlacklist
     * @param currentUserInfo
     */
    void updateBlacklist(List<McTaskMsgReceiveEntity> receiveBlacklist, UserInfo currentUserInfo);

    /**
     * 设置消息已读
     *
     * @param isAll 是否全部已读：0否 1是
     * @param ids   1或多条已读ids
     */
    void isRead(String isAll, List<String> ids);

    /**
     * 是否已读统计
     *
     * @return
     */
    List<Map<String, Object>> isReadCount();

    /**
     * 根据消息id和用户id更新已读状态
     *
     * @param msgId  消息id
     * @param userId 用户id
     */
    void updateIsReadByMsgIdAndUserId(String msgId, String userId);

    /**
     * 按状态分类统计
     *
     * @return 结果
     */
    List<Map<String, Object>> selectGroupByEnabledMark(McTaskMsgReceivePagination pagination);

    /**
     * 按渠道分类统计
     *
     * @return 结果
     */
    Map<String, Object> selectDataPanel(McTaskMsgReceivePagination pagination);

    /**
     * 按渠道分类统计
     *
     * @return 结果
     */
    List<Map<String, Object>> selectGroupByChannelType(McTaskMsgReceivePagination pagination);

    /**
     * 按发送时间分类统计
     *
     * @return 结果
     */
    List<Map<String, Object>> selectGroupBySendTime(McTaskMsgReceivePagination pagination, int i);
}
