package com.bringspring.system.permission.model.user.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/12 15:31
 */
@Data
public class UserListVO implements Serializable {

    @Schema(description = "工号")
    private String code;
    @Schema(description = "主键")
    private String id;
    @Schema(description = "账号")
    private String account;
    @Schema(description = "姓名")
    private String realName;
    @Schema(description = "性别")
    private String gender;
    @Schema(description = "手机")
    private String mobilePhone;
    @Schema(description = "部门")
    private String organize;
    @Schema(description = "说明")
    private String description;
    @Schema(description = "状态")
    private Integer enabledMark;
    @Schema(description = "添加时间", example = "1")
    private Long creatorTime;
    @Schema(description = "排序")
    private Long sortCode;
    @JsonProperty("addressList")
    private List<String> addressList;
    @JsonProperty("changePasswordDate")
    private Long changePasswordDate;
    @JsonProperty("lastLogTime")
    private Long lastLogTime;

    @JsonProperty("areaManagerFlag")
    private String areaManagerFlag;

    @JsonProperty("companyFlag")
    private String companyFlag;
    private String auditResult;
    private String roleName;
    // 是否显示修改选项（暂时停用）
    // @Schema(description = "是否管理员")
    // private Integer isAdministrator;
//    @Schema(description = "锁定标志")
//    private Integer lockMark;

}
