package com.bringspring.system.scheduletask.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.system.scheduletask.entity.TimeTaskLogEntity;
import com.bringspring.system.scheduletask.mapper.TimeTaskLogMapper;
import com.bringspring.system.scheduletask.service.TimeTaskLogService;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;


/**
 * 执行记录
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Service
public class TimeTaskLogServiceImpl extends ServiceImpl<TimeTaskLogMapper, TimeTaskLogEntity> implements TimeTaskLogService {

    @Override
    public long getTaskLogCount(String taskId) {
        QueryWrapper<TimeTaskLogEntity> taskLog = new QueryWrapper<>();
        taskLog.lambda().in(TimeTaskLogEntity::getTaskId, taskId);
        taskLog.lambda().orderByDesc(TimeTaskLogEntity::getRunTime);
        return this.count(taskLog);
    }

    @Override
    public void delete(String taskId) {
        QueryWrapper<TimeTaskLogEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(TimeTaskLogEntity::getTaskId, taskId);
        this.remove(queryWrapper);
    }


}
