/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.system.base.entity.BaseUserBsbEntity;
import com.bringspring.system.base.model.baseuserbsb.BaseUserBsbCrForm;
import com.bringspring.system.base.model.baseuserbsb.BaseUserBsbInfoVO;
import com.bringspring.system.base.model.baseuserbsb.BaseUserBsbListVO;
import com.bringspring.system.base.model.baseuserbsb.BaseUserBsbPagination;
import com.bringspring.system.base.model.baseuserbsb.BaseUserBsbUpForm;
import com.bringspring.system.base.service.BaseUserBsbService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="\u8363\u79d1\u5e01")
@RequestMapping(value={"/api/system/BaseUserBsb"})
public class BaseUserBsbController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseUserBsbController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private BaseUserBsbService baseUserBsbService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody BaseUserBsbPagination baseUserBsbPagination) throws IOException {
        List<BaseUserBsbEntity> list = this.baseUserBsbService.getList(baseUserBsbPagination);
        List listVO = JsonUtil.getJsonToList(list, BaseUserBsbListVO.class);
        for (BaseUserBsbListVO baseUserBsbVO : listVO) {
            baseUserBsbVO.setUserId(this.baseDataUtil.userSelectValue(baseUserBsbVO.getUserId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)baseUserBsbPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid BaseUserBsbCrForm baseUserBsbCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        BaseUserBsbEntity entity = (BaseUserBsbEntity)JsonUtil.getJsonToBean((Object)baseUserBsbCrForm, BaseUserBsbEntity.class);
        entity.setId(mainId);
        entity.setCreatorTime(DateUtil.getNowDate());
        entity.setEnabledMark(10);
        this.baseUserBsbService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<BaseUserBsbInfoVO> info(@PathVariable(value="id") String id) {
        BaseUserBsbEntity entity = this.baseUserBsbService.getInfo(id);
        BaseUserBsbInfoVO vo = (BaseUserBsbInfoVO)JsonUtil.getJsonToBean((Object)entity, BaseUserBsbInfoVO.class);
        vo.setUserId(this.baseDataUtil.userSelectValue(vo.getUserId()));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<BaseUserBsbInfoVO> detailInfo(@PathVariable(value="id") String id) {
        BaseUserBsbEntity entity = this.baseUserBsbService.getInfo(id);
        BaseUserBsbInfoVO vo = (BaseUserBsbInfoVO)JsonUtil.getJsonToBean((Object)entity, BaseUserBsbInfoVO.class);
        vo.setUserId(this.baseDataUtil.userSelectValue(vo.getUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid BaseUserBsbUpForm baseUserBsbUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        BaseUserBsbEntity entity = this.baseUserBsbService.getInfo(id);
        if (entity != null) {
            BaseUserBsbEntity subentity = (BaseUserBsbEntity)JsonUtil.getJsonToBean((Object)baseUserBsbUpForm, BaseUserBsbEntity.class);
            this.baseUserBsbService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        BaseUserBsbEntity entity = this.baseUserBsbService.getInfo(id);
        if (entity != null) {
            this.baseUserBsbService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/updateIntegral"})
    public ActionResult updateIntegral(@RequestBody BaseUserBsbCrForm baseUserBsbCrForm) throws DataException {
        BaseUserBsbEntity one = (BaseUserBsbEntity)this.baseUserBsbService.getOne((Wrapper)Wrappers.lambdaQuery().eq(BaseUserBsbEntity::getUserId, (Object)baseUserBsbCrForm.getUserId()));
        if (ObjectUtil.isNull((Object)one)) {
            baseUserBsbCrForm.setUserId(baseUserBsbCrForm.getUserId());
            baseUserBsbCrForm.setBsbNum(String.valueOf(100 + Integer.valueOf(baseUserBsbCrForm.getBsbNum())));
            this.create(baseUserBsbCrForm);
        } else {
            one.setBsbNum(one.getBsbNum() + Integer.valueOf(baseUserBsbCrForm.getBsbNum()));
            BaseUserBsbUpForm baseUserBsbUpForm = (BaseUserBsbUpForm)JsonUtil.getJsonToBean((Object)one, BaseUserBsbUpForm.class);
            this.update(one.getId(), baseUserBsbUpForm);
        }
        return ActionResult.success();
    }
}

