/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.system.base.entity.DataInterfaceFormatEntity;
import com.bringspring.system.base.model.datainterfaceformat.BaseDataInterfaceFormatCrForm;
import com.bringspring.system.base.model.datainterfaceformat.BaseDataInterfaceFormatInfoVO;
import com.bringspring.system.base.model.datainterfaceformat.BaseDataInterfaceFormatListVO;
import com.bringspring.system.base.model.datainterfaceformat.BaseDataInterfaceFormatPagination;
import com.bringspring.system.base.model.datainterfaceformat.BaseDataInterfaceFormatUpForm;
import com.bringspring.system.base.service.DataInterfaceFormatService;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="\u63a5\u53e3\u6570\u636e\u683c\u5f0f\u8f6c\u6362\u6837\u4f8b")
@RequestMapping(value={"/api/system/BaseDataInterfaceFormat"})
public class DataInterfaceFormatController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataInterfaceFormatController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private DataInterfaceFormatService baseDataInterfaceFormatService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody BaseDataInterfaceFormatPagination baseDataInterfaceFormatPagination) throws IOException {
        List<DataInterfaceFormatEntity> list = this.baseDataInterfaceFormatService.getList(baseDataInterfaceFormatPagination);
        List listVO = JsonUtil.getJsonToList(list, BaseDataInterfaceFormatListVO.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)baseDataInterfaceFormatPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid BaseDataInterfaceFormatCrForm baseDataInterfaceFormatCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        DataInterfaceFormatEntity entity = (DataInterfaceFormatEntity)JsonUtil.getJsonToBean((Object)baseDataInterfaceFormatCrForm, DataInterfaceFormatEntity.class);
        entity.setId(mainId);
        this.baseDataInterfaceFormatService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<BaseDataInterfaceFormatInfoVO> info(@PathVariable(value="id") String id) {
        DataInterfaceFormatEntity entity = this.baseDataInterfaceFormatService.getInfo(id);
        BaseDataInterfaceFormatInfoVO vo = (BaseDataInterfaceFormatInfoVO)JsonUtil.getJsonToBean((Object)entity, BaseDataInterfaceFormatInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<BaseDataInterfaceFormatInfoVO> detailInfo(@PathVariable(value="id") String id) {
        DataInterfaceFormatEntity entity = this.baseDataInterfaceFormatService.getInfo(id);
        BaseDataInterfaceFormatInfoVO vo = (BaseDataInterfaceFormatInfoVO)JsonUtil.getJsonToBean((Object)entity, BaseDataInterfaceFormatInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid BaseDataInterfaceFormatUpForm baseDataInterfaceFormatUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        DataInterfaceFormatEntity entity = this.baseDataInterfaceFormatService.getInfo(id);
        if (entity != null) {
            DataInterfaceFormatEntity subentity = (DataInterfaceFormatEntity)JsonUtil.getJsonToBean((Object)baseDataInterfaceFormatUpForm, DataInterfaceFormatEntity.class);
            this.baseDataInterfaceFormatService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        DataInterfaceFormatEntity entity = this.baseDataInterfaceFormatService.getInfo(id);
        if (entity != null) {
            this.baseDataInterfaceFormatService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

