/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.ActionResultCode;
import com.bringspring.common.base.NoDataSourceBind;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.database.data.DataSourceContextHolder;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.wxutil.HttpUtil;
import com.bringspring.system.base.service.DataInterfaceService;
import com.bringspring.system.base.util.Props;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u8bbf\u95ee\u6570\u636e\u63a5\u53e3")
@RestController
@RequestMapping(value={"/api/service"})
public class DataInterfaceRestController {
    @Autowired
    private DataInterfaceService dataInterfaceService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private Props props;

    @Operation(summary="\u8bbf\u95ee\u63a5\u53e3")
    @PostMapping(value={"/{code}"})
    @NoDataSourceBind
    public ActionResult getByCode(@PathVariable(value="code") String code, String tenantId, @RequestBody Map<String, String> map) {
        ActionResult actionResult;
        String name = null;
        if (this.configValueUtil.isMultiTenancy()) {
            if (StringUtils.isNotEmpty((String)tenantId)) {
                JSONObject object = HttpUtil.httpRequest((String)(this.props.getPortUrl() + tenantId), (String)"GET", null);
                if (object == null || StringUtils.isEmpty((String)object.getString("data"))) {
                    return ActionResult.fail((String)ActionResultCode.SessionOverdue.getMessage());
                }
                Map resulList = JsonUtil.stringToMap((String)object.getString("data"));
                name = resulList.get("java") != null ? String.valueOf(resulList.get("java")) : String.valueOf(resulList.get("dbName"));
                DataSourceContextHolder.setDatasource((String)tenantId, (String)name);
            } else {
                if (Objects.isNull(this.userProvider.get())) {
                    return ActionResult.fail((String)ActionResultCode.SessionOverdue.getMessage());
                }
                DataSourceContextHolder.setDatasource((String)this.userProvider.get().getTenantId(), (String)this.userProvider.get().getTenantDbConnectionString());
            }
        }
        if ((actionResult = this.dataInterfaceService.getApiByCode(code, name, map)).getCode() == 200) {
            actionResult.setMsg("\u63a5\u53e3\u8bf7\u6c42\u6210\u529f");
        }
        return actionResult;
    }

    @Operation(summary="\u8bbf\u95ee\u63a5\u53e3")
    @GetMapping(value={"/{code}"})
    @NoDataSourceBind
    public ActionResult getByCode(@PathVariable(value="code") String code, String tenantId, HttpServletRequest request) {
        ActionResult actionResult;
        String name = null;
        if (this.configValueUtil.isMultiTenancy()) {
            if (StringUtils.isNotEmpty((String)tenantId)) {
                JSONObject object = HttpUtil.httpRequest((String)(this.props.getPortUrl() + tenantId), (String)"GET", null);
                if (object == null || StringUtils.isEmpty((String)object.getString("data"))) {
                    return ActionResult.fail((String)ActionResultCode.SessionOverdue.getMessage());
                }
                Map resulList = JsonUtil.stringToMap((String)object.getString("data"));
                name = resulList.get("java") != null ? String.valueOf(resulList.get("java")) : String.valueOf(resulList.get("dbName"));
                DataSourceContextHolder.setDatasource((String)tenantId, (String)name);
            } else {
                if (Objects.isNull(this.userProvider.get())) {
                    return ActionResult.fail((String)ActionResultCode.SessionOverdue.getMessage());
                }
                DataSourceContextHolder.setDatasource((String)this.userProvider.get().getTenantId(), (String)this.userProvider.get().getTenantDbConnectionString());
            }
        }
        Map parameterMap = request.getParameterMap();
        HashMap<String, String> map = new HashMap<String, String>();
        if (!parameterMap.isEmpty()) {
            for (Map.Entry entry : parameterMap.entrySet()) {
                String paramName = (String)entry.getKey();
                String[] paramValues = (String[])entry.getValue();
                map.put(paramName, paramValues[0]);
                System.out.println(paramName + paramValues[0]);
            }
        }
        if ((actionResult = this.dataInterfaceService.getApiByCode(code, name, map)).getCode() == 200) {
            actionResult.setMsg("\u63a5\u53e3\u8bf7\u6c42\u6210\u529f");
        }
        return actionResult;
    }
}

