/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.useragent.UserAgent;
import cn.hutool.http.useragent.UserAgentUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.database.util.TenantDataSourceUtil;
import com.bringspring.common.model.UserLogForm;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.IpUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.entity.LogEntity;
import com.bringspring.system.base.enums.LogSortEnum;
import com.bringspring.system.base.mapper.LogMapper;
import com.bringspring.system.base.model.BurialPoint.VisitVO;
import com.bringspring.system.base.model.logs.LoginUserStatistics;
import com.bringspring.system.base.model.logs.LoginUserStatisticsQuery;
import com.bringspring.system.base.model.logs.PaginationLogModel;
import com.bringspring.system.base.service.LogService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogServiceImpl
extends ServiceImpl<LogMapper, LogEntity>
implements LogService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private LogMapper logMapper;
    private List<DateTime> dateTimes;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @Override
    public List<LogEntity> getList(int category, PaginationLogModel paginationTime) {
        String userAccount;
        String keyWord;
        String endTime;
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(LogEntity::getCategory, (Object)category);
        String startTime = paginationTime.getStartTime() != null ? paginationTime.getStartTime() : null;
        String string = endTime = paginationTime.getEndTime() != null ? paginationTime.getEndTime() : null;
        if (!StringUtils.isEmpty((String)startTime) && !StringUtils.isEmpty((String)endTime)) {
            Date startTimes = DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)Long.parseLong(startTime)) + " 00:00:00"));
            Date endTimes = DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)Long.parseLong(endTime)) + " 23:59:59"));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(LogEntity::getCreatorTime, (Object)startTimes)).le(LogEntity::getCreatorTime, (Object)endTimes);
        }
        String string2 = keyWord = paginationTime.getKeyword() != null ? paginationTime.getKeyword() : null;
        if (!StringUtils.isEmpty((String)keyWord)) {
            queryWrapper.lambda().and(t -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(LogEntity::getUserName, (Object)keyWord)).or()).like(LogEntity::getIpAddress, (Object)keyWord)).or()).like(LogEntity::getModuleName, (Object)keyWord)).or()).like(LogEntity::getRequestUrl, (Object)keyWord));
        }
        String userId = userInfo.getUserId() != null ? userInfo.getUserId() : null;
        String string3 = userAccount = userInfo.getUserAccount() != null ? userInfo.getUserAccount() : null;
        if (!(StringUtils.isEmpty((String)userId) || StringUtils.isEmpty((String)userAccount) || userInfo.getIsAdministrator().booleanValue())) {
            queryWrapper.lambda().and(t -> ((LambdaQueryWrapper)((LambdaQueryWrapper)t.eq(LogEntity::getUserId, (Object)userId)).or()).eq(LogEntity::getUserId, (Object)userAccount));
        }
        if (StringUtils.isNotEmpty((String)paginationTime.getIpaddress())) {
            queryWrapper.lambda().like(LogEntity::getIpAddress, (Object)paginationTime.getIpaddress());
        }
        if (StringUtils.isNotEmpty((String)paginationTime.getModuleName())) {
            queryWrapper.lambda().like(LogEntity::getModuleName, (Object)paginationTime.getModuleName());
        }
        if (StringUtils.isNotEmpty((String)paginationTime.getRequestMethod())) {
            queryWrapper.lambda().eq(LogEntity::getRequestMethod, (Object)paginationTime.getRequestMethod());
        }
        if (StringUtils.isEmpty((String)paginationTime.getSidx())) {
            queryWrapper.lambda().orderByDesc(LogEntity::getCreatorTime);
        } else {
            try {
                String sidx = paginationTime.getSidx();
                LogEntity logEntity = new LogEntity();
                Field declaredField = logEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(paginationTime.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        Page page = new Page(paginationTime.getCurrentPage(), paginationTime.getPageSize());
        IPage userPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return paginationTime.setData(userPage.getRecords(), page.getTotal());
    }

    @Override
    public List<LogEntity> getList(UserLogForm userLogForm) {
        String userAccount;
        String keyWord;
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(LogEntity::getCategory, (Object)userLogForm.getCategory());
        if (!StringUtils.isEmpty((String)userLogForm.getStartTime()) && !StringUtils.isEmpty((String)userLogForm.getEndTime())) {
            Date startTimes = DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)Long.parseLong(userLogForm.getStartTime())) + " 00:00:00"));
            Date endTimes = DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)Long.parseLong(userLogForm.getEndTime())) + " 23:59:59"));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(LogEntity::getCreatorTime, (Object)startTimes)).le(LogEntity::getCreatorTime, (Object)endTimes);
        }
        if (!StringUtils.isEmpty((String)(keyWord = userLogForm.getKeyword()))) {
            queryWrapper.lambda().and(t -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(LogEntity::getUserName, (Object)keyWord)).or()).like(LogEntity::getIpAddress, (Object)keyWord)).or()).like(LogEntity::getModuleName, (Object)keyWord));
        }
        String userId = userInfo.getUserId() != null ? userInfo.getUserId() : null;
        String string = userAccount = userInfo.getUserAccount() != null ? userInfo.getUserAccount() : null;
        if (!StringUtils.isEmpty((String)userId) && !StringUtils.isEmpty((String)userAccount)) {
            queryWrapper.lambda().and(t -> ((LambdaQueryWrapper)((LambdaQueryWrapper)t.eq(LogEntity::getUserId, (Object)userId)).or()).eq(LogEntity::getUserId, (Object)userAccount));
        }
        if (StringUtils.isEmpty((String)userLogForm.getSidx())) {
            queryWrapper.lambda().orderByDesc(LogEntity::getCreatorTime);
        } else {
            queryWrapper = "asc".equals(userLogForm.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)userLogForm.getSidx()) : (QueryWrapper)queryWrapper.orderByDesc((Object)userLogForm.getSidx());
        }
        Page page = new Page(userLogForm.getCurrentPage(), userLogForm.getPageSize());
        IPage userPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return userLogForm.setData(userPage.getRecords(), page.getTotal());
    }

    @Override
    public List<LogEntity> getList(int category, PaginationLogModel paginationTime, Boolean filterUser) {
        String keyWord;
        UserInfo userInfo = UserProvider.getUser();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(LogEntity::getType, (Object)category);
        if (filterUser.booleanValue()) {
            String userId = userInfo.getUserId();
            String userAccount = userInfo.getUserAccount();
            queryWrapper.lambda().and(t -> ((LambdaQueryWrapper)((LambdaQueryWrapper)t.eq(LogEntity::getUserId, (Object)userId)).or()).eq(LogEntity::getUserId, (Object)userAccount));
        }
        if (!ObjectUtil.isEmpty((Object)paginationTime.getStartTime()) && !ObjectUtil.isEmpty((Object)paginationTime.getEndTime())) {
            queryWrapper.lambda().between(LogEntity::getCreatorTime, (Object)new Date(paginationTime.getStartTime()), (Object)new Date(paginationTime.getEndTime()));
        }
        if (!StringUtils.isEmpty((String)(keyWord = paginationTime.getKeyword()))) {
            if (category == 1) {
                queryWrapper.lambda().and(t -> ((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(LogEntity::getUserName, (Object)keyWord)).or()).like(LogEntity::getIpAddress, (Object)keyWord));
            } else if (category == 5 || category == 4) {
                queryWrapper.lambda().and(t -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(LogEntity::getUserName, (Object)keyWord)).or()).like(LogEntity::getIpAddress, (Object)keyWord)).or()).like(LogEntity::getRequestUrl, (Object)keyWord));
            } else if (category == 3) {
                queryWrapper.lambda().and(t -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(LogEntity::getUserName, (Object)keyWord)).or()).like(LogEntity::getIpAddress, (Object)keyWord)).or()).like(LogEntity::getRequestUrl, (Object)keyWord)).or()).like(LogEntity::getModuleName, (Object)keyWord));
            }
        }
        if (StringUtils.isNotEmpty((String)paginationTime.getRequestMethod())) {
            queryWrapper.lambda().eq(LogEntity::getRequestMethod, (Object)paginationTime.getRequestMethod());
        }
        if (paginationTime.getLoginType() != null) {
            queryWrapper.lambda().eq(LogEntity::getLoginType, (Object)paginationTime.getLoginType());
        }
        if (paginationTime.getLoginMark() != null) {
            queryWrapper.lambda().eq(LogEntity::getLoginMark, (Object)paginationTime.getLoginMark());
        }
        if (StringUtils.isNotEmpty((String)paginationTime.getDataInterFaceId())) {
            String s = paginationTime.getDataInterFaceId() + "/Actions/Preview";
            String ss = paginationTime.getDataInterFaceId() + "/Actions/Response";
            queryWrapper.lambda().and(query -> ((LambdaQueryWrapper)((LambdaQueryWrapper)query.like(LogEntity::getRequestUrl, (Object)s)).or()).like(LogEntity::getRequestUrl, (Object)ss));
        }
        queryWrapper.lambda().orderByDesc(LogEntity::getCreatorTime);
        Page page = new Page(paginationTime.getCurrentPage(), paginationTime.getPageSize());
        IPage userPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return paginationTime.setData(userPage.getRecords(), page.getTotal());
    }

    @Override
    public LogEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(LogEntity::getId, (Object)id);
        return (LogEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public boolean delete(String[] ids) {
        if (ids.length > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(LogEntity::getId, Arrays.asList(ids).toArray());
            return this.remove((Wrapper)queryWrapper);
        }
        return false;
    }

    @Override
    public void writeLogAsync(String userId, String userName, String abstracts) {
        LogEntity entity = new LogEntity();
        entity.setId(RandomUtil.uuId());
        entity.setUserId(userId);
        entity.setUserName(userName);
        entity.setAbstracts(abstracts);
        entity.setRequestUrl(ServletUtils.getServletPath());
        entity.setRequestMethod(ServletUtils.getRequest().getMethod());
        entity.setIpAddress(IpUtil.getIpAddr());
        entity.setPlatForm(ServletUtils.getUserAgent());
        entity.setCategory(LogSortEnum.Login.getCode());
        this.save(entity);
    }

    @Override
    public void writeLogAsync(String userId, String userName, String abstracts, long requestDuration) {
        this.writeLogAsync(userId, userName, abstracts, null, 1, null, requestDuration);
    }

    @Override
    public void writeLogAsync(String userId, String userName, String abstracts, UserInfo userInfo, int loginMark, Integer loginType, long requestDuration) {
        LogEntity entity = new LogEntity();
        if (this.configValueUtil.isMultiTenancy() && userInfo != null) {
            try {
                TenantDataSourceUtil.switchTenant((String)userInfo.getTenantId());
            }
            catch (Exception e) {
                return;
            }
        }
        String ipAddr = IpUtil.getIpAddr();
        entity.setIpAddress(ipAddr);
        entity.setIpAddressName(IpUtil.getIpCity((String)ipAddr));
        UserAgent userAgent = UserAgentUtil.parse((String)ServletUtil.getUserAgent());
        if (userAgent != null) {
            entity.setPlatForm(userAgent.getPlatform().getName() + " " + userAgent.getOsVersion());
            entity.setBrowser(userAgent.getBrowser().getName() + " " + userAgent.getVersion());
        }
        if (loginType != null) {
            entity.setLoginType(1);
        } else {
            entity.setLoginType(0);
        }
        entity.setLoginMark(loginMark);
        entity.setRequestDuration(Integer.parseInt(String.valueOf(requestDuration)));
        entity.setId(RandomUtil.uuId());
        entity.setUserId(userId);
        entity.setUserName(userName);
        entity.setDescription(abstracts);
        entity.setRequestUrl(ServletUtil.getServletPath());
        entity.setRequestMethod(ServletUtil.getRequest().getMethod());
        entity.setType(LogSortEnum.Login.getCode());
        this.save(entity);
    }

    @Override
    public void writeLogAsync(LogEntity entity) {
        entity.setId(RandomUtil.uuId());
        this.save(entity);
    }

    @Override
    public void deleteHandleLog(String type, Integer userOnline, String dataInterfaceId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(LogEntity::getType, (Object)Integer.valueOf(type));
        if (ObjectUtil.equals((Object)userOnline, (Object)1)) {
            queryWrapper.lambda().eq(LogEntity::getCreatorUserId, (Object)UserProvider.getLoginUserId());
        }
        if (StringUtils.isNotEmpty((String)dataInterfaceId)) {
            String s = dataInterfaceId + "/Actions/Preview";
            String ss = dataInterfaceId + "/Actions/Response";
            queryWrapper.lambda().and(query -> ((LambdaQueryWrapper)((LambdaQueryWrapper)query.like(LogEntity::getRequestUrl, (Object)s)).or()).like(LogEntity::getRequestUrl, (Object)ss));
        }
        queryWrapper.lambda().select(new SFunction[]{LogEntity::getId});
        List ids = this.list((Wrapper)queryWrapper).stream().map(LogEntity::getId).collect(Collectors.toList());
        List lists = Lists.partition(ids, (int)1000);
        for (List list : lists) {
            QueryWrapper deleteWrapper = new QueryWrapper();
            deleteWrapper.lambda().in(LogEntity::getId, (Collection)list);
            this.remove((Wrapper)deleteWrapper);
        }
    }

    @Override
    public void deleteHandleLog(String type) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(LogEntity::getCategory, (Object)type);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public void autoDeleteLog() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(LogEntity::getCategory, new Object[]{LogSortEnum.Login.getCode(), LogSortEnum.Request.getCode()});
        queryWrapper.lambda().lt(LogEntity::getCreatorTime, (Object)DateUtil.offsetMonth((Date)new Date(), (int)-1));
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public Set<String> queryList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(LogEntity::getCategory, (Object)3);
        return this.list((Wrapper)queryWrapper).size() > 0 ? this.list((Wrapper)queryWrapper).stream().map(t -> t.getModuleName()).collect(Collectors.toSet()) : new HashSet<String>(16);
    }

    private QueryWrapper<LogEntity> getQueryWrapper(String category, PaginationLogModel logModel) {
        String endTime;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(LogEntity::getCategory, (Object)category);
        String startTime = logModel.getStartTime() != null ? logModel.getStartTime() : null;
        String string = endTime = logModel.getEndTime() != null ? logModel.getEndTime() : null;
        if (!StringUtils.isEmpty((String)startTime) && !StringUtils.isEmpty((String)endTime)) {
            Date startTimes = DateUtil.stringToDate((String)(startTime + ":00"));
            Date endTimes = DateUtil.stringToDate((String)(endTime + ":00"));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(LogEntity::getCreatorTime, (Object)startTimes)).le(LogEntity::getCreatorTime, (Object)endTimes);
            this.dateTimes = DateUtil.rangeToList((Date)startTimes, (Date)endTimes, (DateField)DateField.MINUTE);
        } else {
            DateTime end = DateUtil.parse((CharSequence)DateUtil.getmmNow());
            Date start = DateUtil.dateAddMinutes((Date)end, (int)-29);
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(LogEntity::getCreatorTime, (Object)start)).le(LogEntity::getCreatorTime, (Object)end);
            this.dateTimes = DateUtil.rangeToList((Date)start, (Date)end, (DateField)DateField.MINUTE);
        }
        return queryWrapper;
    }

    @Override
    public List<Map<String, Object>> selectUserGroupByCreatorTime(String category, PaginationLogModel logModel) {
        ArrayList<Map<String, Object>> resultMap = new ArrayList<Map<String, Object>>();
        QueryWrapper<LogEntity> queryWrapper = this.getQueryWrapper(category, logModel);
        List<Map<String, Object>> maps = this.logMapper.selectUserGroupByCreatorTime((Wrapper)queryWrapper);
        for (DateTime dateTime : this.dateTimes) {
            String dateStr = DateUtil.getDateString((Date)dateTime, (String)"HH:mm");
            HashMap<String, Object> sendTime = maps.stream().filter(t -> t.get("creator_time").equals(dateStr)).findFirst().orElse(null);
            if (CollectionUtil.isEmpty((Map)sendTime)) {
                sendTime = new HashMap<String, Object>();
                sendTime.put("creator_time", dateStr);
                sendTime.put("scount", 0);
            }
            resultMap.add((Map<String, Object>)sendTime);
        }
        return resultMap;
    }

    @Override
    public List<Map<String, Object>> selectModuleGroupByCreatorTime(String category, PaginationLogModel logModel) {
        ArrayList<Map<String, Object>> resultMap = new ArrayList<Map<String, Object>>();
        QueryWrapper<LogEntity> queryWrapper = this.getQueryWrapper(category, logModel);
        List<Map<String, Object>> maps = this.logMapper.selectModuleGroupByCreatorTime((Wrapper)queryWrapper);
        for (DateTime dateTime : this.dateTimes) {
            String dateStr = DateUtil.getDateString((Date)dateTime, (String)"HH:mm");
            HashMap<String, Object> sendTime = maps.stream().filter(t -> t.get("creator_time").equals(dateStr)).findFirst().orElse(null);
            if (CollectionUtil.isEmpty((Map)sendTime)) {
                sendTime = new HashMap<String, Object>();
                sendTime.put("creator_time", dateStr);
                sendTime.put("scount", 0);
            }
            resultMap.add((Map<String, Object>)sendTime);
        }
        return resultMap;
    }

    @Override
    public List<Map<String, Object>> selectGroupByCreatorTime(String category, PaginationLogModel logModel) {
        ArrayList<Map<String, Object>> resultMap = new ArrayList<Map<String, Object>>();
        QueryWrapper<LogEntity> queryWrapper = this.getQueryWrapper(category, logModel);
        List<Map<String, Object>> maps = this.logMapper.selectGroupByCreatorTime((Wrapper)queryWrapper);
        for (DateTime dateTime : this.dateTimes) {
            String dateStr = DateUtil.getDateString((Date)dateTime, (String)"HH:mm");
            HashMap<String, Object> sendTime = maps.stream().filter(t -> t.get("creator_time").equals(dateStr)).findFirst().orElse(null);
            if (CollectionUtil.isEmpty((Map)sendTime)) {
                sendTime = new HashMap<String, Object>();
                sendTime.put("creator_time", dateStr);
                sendTime.put("scount", 0);
            }
            resultMap.add((Map<String, Object>)sendTime);
        }
        return resultMap;
    }

    @Override
    public List<Map<String, Object>> selectMixedGroupByCreatorTime(String category, PaginationLogModel logModel) {
        ArrayList<Map<String, Object>> resultMap = new ArrayList<Map<String, Object>>();
        QueryWrapper<LogEntity> queryWrapper = this.getQueryWrapper(category, logModel);
        List<Map<String, Object>> userMaps = this.logMapper.selectUserGroupByCreatorTime((Wrapper)queryWrapper);
        List<Map<String, Object>> moduleMaps = this.logMapper.selectModuleGroupByCreatorTime((Wrapper)queryWrapper);
        List<Map<String, Object>> reqMaps = this.logMapper.selectGroupByCreatorTime((Wrapper)queryWrapper);
        for (DateTime dateTime : this.dateTimes) {
            String dateStr = DateUtil.getDateString((Date)dateTime, (String)"HH:mm");
            HashMap<String, Object> createTimes = new HashMap<String, Object>();
            createTimes.put("creator_time", dateStr);
            Map userMap = userMaps.stream().filter(t -> t.get("creator_time").equals(dateStr)).findFirst().orElse(null);
            createTimes.put("usercount", CollectionUtil.isEmpty((Map)userMap) ? Integer.valueOf(0) : userMap.get("scount"));
            Map moduleMap = moduleMaps.stream().filter(t -> t.get("creator_time").equals(dateStr)).findFirst().orElse(null);
            createTimes.put("modulecount", CollectionUtil.isEmpty((Map)moduleMap) ? Integer.valueOf(0) : moduleMap.get("scount"));
            Map reqMap = reqMaps.stream().filter(t -> t.get("creator_time").equals(dateStr)).findFirst().orElse(null);
            createTimes.put("reqcount", CollectionUtil.isEmpty((Map)reqMap) ? Integer.valueOf(0) : reqMap.get("scount"));
            resultMap.add(createTimes);
        }
        return resultMap;
    }

    @Override
    public List<Map<String, Object>> selectGroupByModule(String category, PaginationLogModel logModel) {
        QueryWrapper<LogEntity> queryWrapper = this.getQueryWrapper(category, logModel);
        List<Map<String, Object>> resultMap = this.logMapper.selectGroupByModule((Wrapper)queryWrapper);
        return resultMap;
    }

    @Override
    public List<VisitVO> userVisit(VisitVO visitVO) {
        List<Object> resultMap = new ArrayList();
        if (ObjectUtil.isEmpty(visitVO.getCreatorTime())) {
            ArrayList<String> creatorTime = new ArrayList<String>();
            creatorTime.add(DateUtil.daFormat((Date)DateUtil.getBeginDayOfWeek()));
            creatorTime.add(DateUtil.getmmNow());
            visitVO.setCreatorTime(creatorTime);
        }
        PageHelper.startPage((int)((int)visitVO.getCurrentPage()), (int)((int)visitVO.getPageSize()));
        resultMap = this.logMapper.userVisit(visitVO);
        PageInfo pageInfo = new PageInfo(resultMap);
        return visitVO.setData(pageInfo.getList(), pageInfo.getTotal());
    }

    @Override
    public List<VisitVO> functionVisit(VisitVO visitVO) {
        List<Object> resultMap = new ArrayList();
        if (ObjectUtil.isEmpty(visitVO.getCreatorTime())) {
            ArrayList<String> creatorTime = new ArrayList<String>();
            creatorTime.add(DateUtil.daFormat((Date)DateUtil.getBeginDayOfWeek()));
            creatorTime.add(DateUtil.getmmNow());
            visitVO.setCreatorTime(creatorTime);
        }
        PageHelper.startPage((int)((int)visitVO.getCurrentPage()), (int)((int)visitVO.getPageSize()));
        resultMap = this.logMapper.functionVisit(visitVO);
        PageInfo pageInfo = new PageInfo(resultMap);
        return visitVO.setData(pageInfo.getList(), pageInfo.getTotal());
    }

    @Override
    public List<VisitVO> functionUserVisit(VisitVO visitVO) {
        ArrayList<VisitVO> resultMap = new ArrayList();
        if (ObjectUtil.isEmpty(visitVO.getCreatorTime())) {
            ArrayList<String> creatorTime = new ArrayList<String>();
            creatorTime.add(DateUtil.daFormat((Date)DateUtil.getBeginDayOfWeek()));
            creatorTime.add(DateUtil.getmmNow());
            visitVO.setCreatorTime(creatorTime);
        }
        resultMap = this.logMapper.functionUserVisit(visitVO);
        return resultMap;
    }

    @Override
    public List<VisitVO> functionUserCountVisit(VisitVO visitVO) {
        ArrayList<VisitVO> resultMap = new ArrayList();
        if (ObjectUtil.isEmpty(visitVO.getCreatorTime())) {
            ArrayList<String> creatorTime = new ArrayList<String>();
            creatorTime.add(DateUtil.daFormat((Date)DateUtil.getBeginDayOfWeek()));
            creatorTime.add(DateUtil.getmmNow());
            visitVO.setCreatorTime(creatorTime);
        }
        resultMap = this.logMapper.functionUserCountVisit(visitVO);
        return resultMap;
    }

    @Override
    public List<VisitVO> functionList(VisitVO visitVO) {
        ArrayList<VisitVO> resultMap = new ArrayList();
        resultMap = this.logMapper.functionList();
        return resultMap;
    }

    @Override
    public LoginUserStatistics loginUserStatistics(LoginUserStatisticsQuery loginUserStatisticsQuery) {
        return this.logMapper.loginUserStatistics(loginUserStatisticsQuery);
    }
}

