/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.external.config.single;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.systemconfig.QyChatModel;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.service.SysConfigService;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.api.impl.WxCpServiceImpl;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import me.chanjar.weixin.cp.config.impl.WxCpDefaultConfigImpl;
import me.chanjar.weixin.cp.message.WxCpMessageRouter;
import org.springframework.beans.factory.annotation.Autowired;

public class WxCpConfiguration {
    private Map<Integer, WxCpMessageRouter> routers = Maps.newHashMap();
    private Map<Integer, WxCpService> cpServices = Maps.newHashMap();
    @Autowired
    private SysConfigService sysConfigService;

    @Autowired
    public WxCpConfiguration() {
    }

    public Map<Integer, WxCpMessageRouter> getRouters() {
        return this.routers;
    }

    public WxCpService getCpService(Integer agentId) {
        WxCpService wxCpService = this.cpServices.get(agentId);
        if (ObjectUtil.isEmpty((Object)wxCpService)) {
            this.initServices();
            wxCpService = this.cpServices.get(agentId);
        }
        return wxCpService;
    }

    public void initServices() {
        try {
            QyChatModel qyChatInfo = this.sysConfigService.getQyChatInfo();
            if (ObjectUtil.isNotEmpty((Object)qyChatInfo)) {
                ArrayList<QyChatModel> listModel = new ArrayList<QyChatModel>();
                listModel.add(qyChatInfo);
                this.cpServices = listModel.stream().map(a -> {
                    Integer agentId = Integer.valueOf(a.getQyhAgentId());
                    WxCpDefaultConfigImpl configStorage = new WxCpDefaultConfigImpl();
                    configStorage.setCorpId(a.getQyhCorpId());
                    configStorage.setAgentId(agentId);
                    configStorage.setCorpSecret(a.getQyhAgentSecret());
                    configStorage.setToken(a.getToken());
                    configStorage.setAesKey(a.getEncodingAESKey());
                    WxCpServiceImpl service = new WxCpServiceImpl();
                    service.setWxCpConfigStorage((WxCpConfigStorage)configStorage);
                    this.routers.put(agentId, this.newRouter((WxCpService)service));
                    return service;
                }).collect(Collectors.toMap(service -> service.getWxCpConfigStorage().getAgentId(), a -> a));
            }
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
    }

    private WxCpMessageRouter newRouter(WxCpService wxCpService) {
        WxCpMessageRouter newRouter = new WxCpMessageRouter(wxCpService);
        return newRouter;
    }
}

