/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.external.controller;

import cn.hutool.core.map.MapUtil;
import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.system.external.config.mutil.WxMpConfiguration;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.HashMap;
import lombok.Generated;
import me.chanjar.weixin.common.bean.WxOAuth2UserInfo;
import me.chanjar.weixin.common.bean.oauth2.WxOAuth2AccessToken;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u5fae\u4fe1\u516c\u4f17\u53f7")
@RestController
@RequestMapping(value={"wxMp"})
public class WxMpController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WxMpController.class);
    @Autowired
    private WxMpConfiguration wxMpConfiguration;
    @Autowired
    private CacheUtil cacheUtil;

    @NotCheckLogin
    @GetMapping(value={"loginByCode"})
    public ActionResult loginByCode(String code) {
        WxMpService wxMpService = this.wxMpConfiguration.getWxMpService("wx08d904a944bfaa20");
        WxOAuth2AccessToken wxOAuth2AccessToken = null;
        try {
            wxOAuth2AccessToken = wxMpService.getOAuth2Service().getAccessToken(code);
        }
        catch (WxErrorException e) {
            e.printStackTrace();
            return ActionResult.fail((String)e.getMessage());
        }
        WxOAuth2UserInfo wxMpUser = null;
        try {
            wxMpUser = wxMpService.getOAuth2Service().getUserInfo(wxOAuth2AccessToken, null);
        }
        catch (WxErrorException e) {
            e.printStackTrace();
            return ActionResult.fail((String)e.getMessage());
        }
        String openid = wxMpUser.getOpenid();
        this.cacheUtil.insert("oneWeekCacheSpace", openid, (Object)wxMpUser, 604800L);
        HashMap map = MapUtil.newHashMap();
        map.put("openid", openid);
        return ActionResult.success((Object)map);
    }
}

