/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.external.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import me.chanjar.weixin.cp.bean.WxCpUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WxCpCorpValidateUtil {
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private UserService userService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    PositionService positionService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserRelationService userRelationService;
    Map<String, SynThirdInfoEntity> thirdCorpOrgMap = new HashMap<String, SynThirdInfoEntity>();
    Map<String, OrganizeEntity> organizeMap = new HashMap<String, OrganizeEntity>();
    Map<String, SynThirdInfoEntity> thirdCorpUserMap = new HashMap<String, SynThirdInfoEntity>();
    Map<String, UserEntity> userIdMap = new HashMap<String, UserEntity>();
    Map<String, UserEntity> accountMap = new HashMap<String, UserEntity>();
    Map<String, UserEntity> phoneMap = new HashMap<String, UserEntity>();
    Map<String, UserEntity> emailMap = new HashMap<String, UserEntity>();
    Map<String, PositionEntity> positionIdMap = new HashMap<String, PositionEntity>();
    String defaultRoleId = "";

    public void initData(String corpId) {
        List<SynThirdInfoEntity> thirdList = this.synThirdInfoService.getListByCrop("1", "1", corpId);
        this.thirdCorpOrgMap.clear();
        if (StringUtils.isNotEmpty(thirdList)) {
            for (SynThirdInfoEntity entity : thirdList) {
                this.thirdCorpOrgMap.put(entity.getThirdObjectId(), entity);
            }
        }
    }

    public void initDataByUser(String corpId) {
        List<RoleEntity> list;
        List<SynThirdInfoEntity> orgThirdList = this.synThirdInfoService.getListByCrop("1", "1", corpId);
        this.thirdCorpOrgMap.clear();
        ArrayList<String> orgIds = new ArrayList<String>();
        if (StringUtils.isNotEmpty(orgThirdList)) {
            for (SynThirdInfoEntity synThirdInfoEntity : orgThirdList) {
                this.thirdCorpOrgMap.put(synThirdInfoEntity.getThirdObjectId(), synThirdInfoEntity);
                orgIds.add(synThirdInfoEntity.getSystemObjectId());
            }
        }
        List<PositionEntity> positionList = this.positionService.getListByOrgIds(orgIds);
        this.positionIdMap.clear();
        if (StringUtils.isNotEmpty(positionList)) {
            for (PositionEntity entity : positionList) {
                this.positionIdMap.put(entity.getFullName() + "/" + entity.getOrganizeId(), entity);
            }
        }
        List<SynThirdInfoEntity> list2 = this.synThirdInfoService.getListByCrop("1", "2", corpId);
        this.thirdCorpUserMap.clear();
        ArrayList<String> userIds = new ArrayList<String>();
        if (StringUtils.isNotEmpty(list2)) {
            for (SynThirdInfoEntity synThirdInfoEntity : list2) {
                if (StringUtils.isNotEmpty((String)synThirdInfoEntity.getThirdObjectId()) && synThirdInfoEntity.getThirdObjectId().contains("/")) {
                    String thirdObjectId = synThirdInfoEntity.getThirdObjectId().substring(synThirdInfoEntity.getThirdObjectId().lastIndexOf("/") + 1);
                    this.thirdCorpUserMap.put(thirdObjectId, synThirdInfoEntity);
                } else {
                    this.thirdCorpUserMap.put(synThirdInfoEntity.getThirdObjectId(), synThirdInfoEntity);
                }
                userIds.add(synThirdInfoEntity.getSystemObjectId());
            }
        }
        List<UserEntity> userList = this.userService.getUserByIds(userIds);
        this.userIdMap.clear();
        this.accountMap.clear();
        this.phoneMap.clear();
        this.emailMap.clear();
        if (StringUtils.isNotEmpty(userList)) {
            for (UserEntity entity : userList) {
                this.userIdMap.put(entity.getId(), entity);
                this.accountMap.put(entity.getAccount(), entity);
                this.phoneMap.put(entity.getMobilePhone(), entity);
                this.emailMap.put(entity.getEmail(), entity);
            }
        }
        if (CollectionUtil.isNotEmpty(list = this.roleService.getListByEnCode("SimpleUser"))) {
            this.defaultRoleId = list.get(0).getId();
        }
    }

    public SynThirdInfoEntity getThirdCorpOrgByThirdId(String thirdObjid) {
        if (this.thirdCorpOrgMap.containsKey(thirdObjid)) {
            return this.thirdCorpOrgMap.get(thirdObjid);
        }
        return null;
    }

    public SynThirdInfoEntity newSynThirdInfoForWxDept(String corpId, String thirdObjid) {
        SynThirdInfoEntity synThirdInfoEntity = new SynThirdInfoEntity();
        synThirdInfoEntity.setId(RandomUtil.uuId());
        synThirdInfoEntity.setCropId(corpId);
        synThirdInfoEntity.setThirdType(Integer.valueOf("1"));
        synThirdInfoEntity.setDataType(Integer.valueOf("1"));
        synThirdInfoEntity.setThirdObjectId(thirdObjid);
        return synThirdInfoEntity;
    }

    public String getAccount(WxCpUser wxCpUser) {
        if (StringUtils.isNotEmpty((String)wxCpUser.getMobile())) {
            return wxCpUser.getMobile();
        }
        if (StringUtils.isNotEmpty((String)wxCpUser.getEmail())) {
            return wxCpUser.getEmail();
        }
        return wxCpUser.getUserId();
    }

    public SynThirdInfoEntity getThirdCorpUserByThirdId(String thirdObjid) {
        if (this.thirdCorpUserMap.containsKey(thirdObjid)) {
            return this.thirdCorpUserMap.get(thirdObjid);
        }
        return null;
    }

    public SynThirdInfoEntity newSynThirdInfoForWxUser(String thirdObjid) {
        SynThirdInfoEntity synThirdInfoEntity = new SynThirdInfoEntity();
        synThirdInfoEntity.setId(RandomUtil.uuId());
        synThirdInfoEntity.setThirdType(Integer.valueOf("1"));
        synThirdInfoEntity.setDataType(Integer.valueOf("2"));
        synThirdInfoEntity.setThirdObjectId(thirdObjid);
        return synThirdInfoEntity;
    }

    public UserEntity getUserEntity(String account, String phone, String email) {
        if (StringUtils.isNotEmpty((String)account) && this.accountMap.containsKey(account)) {
            return this.accountMap.get(account);
        }
        if (StringUtils.isNotEmpty((String)phone) && this.phoneMap.containsKey(phone)) {
            return this.phoneMap.get(phone);
        }
        if (StringUtils.isNotEmpty((String)email) && this.emailMap.containsKey(email)) {
            return this.emailMap.get(email);
        }
        return null;
    }

    public UserEntity getUserEntityByUserid(String userid) {
        if (this.userIdMap.containsKey(userid)) {
            return this.userIdMap.get(userid);
        }
        return null;
    }

    public UserEntity getUserEntityByAccount(String account) {
        if (this.accountMap.containsKey(account)) {
            return this.accountMap.get(account);
        }
        return null;
    }

    public String getCode(WxCpUser wxCpUser) {
        List extAttrs;
        String value = null;
        if (StringUtils.isNotEmpty((Collection)wxCpUser.getExtAttrs()) && (extAttrs = wxCpUser.getExtAttrs()).size() != 0) {
            for (WxCpUser.Attr attr : extAttrs) {
                String name = attr.getName();
                if (!StringUtils.isNotEmpty((String)name) || !name.contains("\u5de5\u53f7")) continue;
                value = attr.getTextValue();
            }
        }
        return value;
    }

    public void mergeDistinctOrganize(UserEntity aEntity, UserEntity bEntity) {
        String orgId1 = aEntity.getOrganizeId();
        String[] arr1 = StringUtils.isNotEmpty((String)orgId1) ? orgId1.split(",") : new String[]{};
        String orgId2 = bEntity.getOrganizeId();
        String[] arr2 = StringUtils.isNotEmpty((String)orgId2) ? orgId2.split(",") : new String[]{};
        Object[] arrAll = (String[])ArrayUtil.addAll((Object[][])new String[][]{arr1, arr2});
        Object[] distinct = (String[])ArrayUtil.distinct((Object[])arrAll);
        String orgId3 = ArrayUtil.join((Object[])distinct, (CharSequence)",");
        aEntity.setOrganizeId(orgId3);
    }

    public void mergeDistinctPosition(UserEntity aEntity, UserEntity bEntity) {
        String posId1 = aEntity.getPositionId();
        String[] posArr1 = StringUtils.isNotEmpty((String)posId1) ? posId1.split(",") : new String[]{};
        String posId2 = bEntity.getPositionId();
        String[] posArr2 = StringUtils.isNotEmpty((String)posId2) ? posId2.split(",") : new String[]{};
        Object[] posArrAll = (String[])ArrayUtil.addAll((Object[][])new String[][]{posArr1, posArr2});
        Object[] distinctPos = (String[])ArrayUtil.distinct((Object[])posArrAll);
        String posId3 = ArrayUtil.join((Object[])distinctPos, (CharSequence)",");
        aEntity.setPositionId(posId3);
    }

    public PositionEntity getPositionByUserid(String poitionKey) {
        if (this.positionIdMap.containsKey(poitionKey)) {
            return this.positionIdMap.get(poitionKey);
        }
        return null;
    }

    public void convertPosition(Map<String, PositionEntity> savePositionMap, UserEntity userEntity) {
        String positionId = userEntity.getPositionId();
        String[] posArr = StringUtils.isNotEmpty((String)positionId) ? positionId.split(",") : new String[]{};
        int posLength = posArr.length;
        Object[] positionIdArr = new String[posLength];
        for (int i = 0; i < posLength; ++i) {
            String poitionKey = posArr[i];
            PositionEntity positionEntity = this.getPositionByUserid(poitionKey);
            if (ObjectUtil.isNotEmpty((Object)positionEntity)) {
                positionIdArr[i] = positionEntity.getId();
                continue;
            }
            if (savePositionMap.containsKey(poitionKey)) {
                positionIdArr[i] = savePositionMap.get(poitionKey).getId();
                continue;
            }
            if (!poitionKey.contains("/")) continue;
            String position = poitionKey.substring(0, poitionKey.lastIndexOf("/"));
            String deptId = poitionKey.substring(poitionKey.lastIndexOf("/") + 1);
            if (!StringUtils.isNotEmpty((String)position)) continue;
            PositionEntity posEntity = new PositionEntity();
            posEntity.setId(RandomUtil.uuId());
            posEntity.setFullName(position);
            posEntity.setOrganizeId(deptId);
            posEntity.setSortCode(0L);
            savePositionMap.put(poitionKey, posEntity);
            positionIdArr[i] = posEntity.getId();
        }
        String posId3 = ArrayUtil.join((Object[])positionIdArr, (CharSequence)",");
        userEntity.setPositionId(posId3);
    }

    public void setUserRelation(UserEntity userEntity) {
        String organizeIds = "";
        String positionIds = "";
        Object roleIds = "";
        Object groupIds = "";
        List<UserRelationEntity> relationList = this.userRelationService.getListByUserId(userEntity.getId());
        if (StringUtils.isNotEmpty(relationList)) {
            for (UserRelationEntity item : relationList) {
                switch (item.getObjectType()) {
                    case "Role": {
                        roleIds = (String)roleIds + item.getObjectId() + ",";
                        break;
                    }
                    case "Group": {
                        groupIds = (String)groupIds + item.getObjectId() + ",";
                        break;
                    }
                }
            }
        }
        userEntity.setRoleId((String)roleIds);
        userEntity.setGroupId((String)groupIds);
    }

    @Generated
    public WxCpCorpValidateUtil() {
    }

    @Generated
    public SynThirdInfoService getSynThirdInfoService() {
        return this.synThirdInfoService;
    }

    @Generated
    public UserService getUserService() {
        return this.userService;
    }

    @Generated
    public OrganizeService getOrganizeService() {
        return this.organizeService;
    }

    @Generated
    public PositionService getPositionService() {
        return this.positionService;
    }

    @Generated
    public RoleService getRoleService() {
        return this.roleService;
    }

    @Generated
    public UserRelationService getUserRelationService() {
        return this.userRelationService;
    }

    @Generated
    public Map<String, SynThirdInfoEntity> getThirdCorpOrgMap() {
        return this.thirdCorpOrgMap;
    }

    @Generated
    public Map<String, OrganizeEntity> getOrganizeMap() {
        return this.organizeMap;
    }

    @Generated
    public Map<String, SynThirdInfoEntity> getThirdCorpUserMap() {
        return this.thirdCorpUserMap;
    }

    @Generated
    public Map<String, UserEntity> getUserIdMap() {
        return this.userIdMap;
    }

    @Generated
    public Map<String, UserEntity> getAccountMap() {
        return this.accountMap;
    }

    @Generated
    public Map<String, UserEntity> getPhoneMap() {
        return this.phoneMap;
    }

    @Generated
    public Map<String, UserEntity> getEmailMap() {
        return this.emailMap;
    }

    @Generated
    public Map<String, PositionEntity> getPositionIdMap() {
        return this.positionIdMap;
    }

    @Generated
    public String getDefaultRoleId() {
        return this.defaultRoleId;
    }

    @Generated
    public void setSynThirdInfoService(SynThirdInfoService synThirdInfoService) {
        this.synThirdInfoService = synThirdInfoService;
    }

    @Generated
    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @Generated
    public void setOrganizeService(OrganizeService organizeService) {
        this.organizeService = organizeService;
    }

    @Generated
    public void setPositionService(PositionService positionService) {
        this.positionService = positionService;
    }

    @Generated
    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }

    @Generated
    public void setUserRelationService(UserRelationService userRelationService) {
        this.userRelationService = userRelationService;
    }

    @Generated
    public void setThirdCorpOrgMap(Map<String, SynThirdInfoEntity> thirdCorpOrgMap) {
        this.thirdCorpOrgMap = thirdCorpOrgMap;
    }

    @Generated
    public void setOrganizeMap(Map<String, OrganizeEntity> organizeMap) {
        this.organizeMap = organizeMap;
    }

    @Generated
    public void setThirdCorpUserMap(Map<String, SynThirdInfoEntity> thirdCorpUserMap) {
        this.thirdCorpUserMap = thirdCorpUserMap;
    }

    @Generated
    public void setUserIdMap(Map<String, UserEntity> userIdMap) {
        this.userIdMap = userIdMap;
    }

    @Generated
    public void setAccountMap(Map<String, UserEntity> accountMap) {
        this.accountMap = accountMap;
    }

    @Generated
    public void setPhoneMap(Map<String, UserEntity> phoneMap) {
        this.phoneMap = phoneMap;
    }

    @Generated
    public void setEmailMap(Map<String, UserEntity> emailMap) {
        this.emailMap = emailMap;
    }

    @Generated
    public void setPositionIdMap(Map<String, PositionEntity> positionIdMap) {
        this.positionIdMap = positionIdMap;
    }

    @Generated
    public void setDefaultRoleId(String defaultRoleId) {
        this.defaultRoleId = defaultRoleId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxCpCorpValidateUtil)) {
            return false;
        }
        WxCpCorpValidateUtil other = (WxCpCorpValidateUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SynThirdInfoService this$synThirdInfoService = this.getSynThirdInfoService();
        SynThirdInfoService other$synThirdInfoService = other.getSynThirdInfoService();
        if (this$synThirdInfoService == null ? other$synThirdInfoService != null : !this$synThirdInfoService.equals(other$synThirdInfoService)) {
            return false;
        }
        UserService this$userService = this.getUserService();
        UserService other$userService = other.getUserService();
        if (this$userService == null ? other$userService != null : !this$userService.equals(other$userService)) {
            return false;
        }
        OrganizeService this$organizeService = this.getOrganizeService();
        OrganizeService other$organizeService = other.getOrganizeService();
        if (this$organizeService == null ? other$organizeService != null : !this$organizeService.equals(other$organizeService)) {
            return false;
        }
        PositionService this$positionService = this.getPositionService();
        PositionService other$positionService = other.getPositionService();
        if (this$positionService == null ? other$positionService != null : !this$positionService.equals(other$positionService)) {
            return false;
        }
        RoleService this$roleService = this.getRoleService();
        RoleService other$roleService = other.getRoleService();
        if (this$roleService == null ? other$roleService != null : !this$roleService.equals(other$roleService)) {
            return false;
        }
        UserRelationService this$userRelationService = this.getUserRelationService();
        UserRelationService other$userRelationService = other.getUserRelationService();
        if (this$userRelationService == null ? other$userRelationService != null : !this$userRelationService.equals(other$userRelationService)) {
            return false;
        }
        Map<String, SynThirdInfoEntity> this$thirdCorpOrgMap = this.getThirdCorpOrgMap();
        Map<String, SynThirdInfoEntity> other$thirdCorpOrgMap = other.getThirdCorpOrgMap();
        if (this$thirdCorpOrgMap == null ? other$thirdCorpOrgMap != null : !((Object)this$thirdCorpOrgMap).equals(other$thirdCorpOrgMap)) {
            return false;
        }
        Map<String, OrganizeEntity> this$organizeMap = this.getOrganizeMap();
        Map<String, OrganizeEntity> other$organizeMap = other.getOrganizeMap();
        if (this$organizeMap == null ? other$organizeMap != null : !((Object)this$organizeMap).equals(other$organizeMap)) {
            return false;
        }
        Map<String, SynThirdInfoEntity> this$thirdCorpUserMap = this.getThirdCorpUserMap();
        Map<String, SynThirdInfoEntity> other$thirdCorpUserMap = other.getThirdCorpUserMap();
        if (this$thirdCorpUserMap == null ? other$thirdCorpUserMap != null : !((Object)this$thirdCorpUserMap).equals(other$thirdCorpUserMap)) {
            return false;
        }
        Map<String, UserEntity> this$userIdMap = this.getUserIdMap();
        Map<String, UserEntity> other$userIdMap = other.getUserIdMap();
        if (this$userIdMap == null ? other$userIdMap != null : !((Object)this$userIdMap).equals(other$userIdMap)) {
            return false;
        }
        Map<String, UserEntity> this$accountMap = this.getAccountMap();
        Map<String, UserEntity> other$accountMap = other.getAccountMap();
        if (this$accountMap == null ? other$accountMap != null : !((Object)this$accountMap).equals(other$accountMap)) {
            return false;
        }
        Map<String, UserEntity> this$phoneMap = this.getPhoneMap();
        Map<String, UserEntity> other$phoneMap = other.getPhoneMap();
        if (this$phoneMap == null ? other$phoneMap != null : !((Object)this$phoneMap).equals(other$phoneMap)) {
            return false;
        }
        Map<String, UserEntity> this$emailMap = this.getEmailMap();
        Map<String, UserEntity> other$emailMap = other.getEmailMap();
        if (this$emailMap == null ? other$emailMap != null : !((Object)this$emailMap).equals(other$emailMap)) {
            return false;
        }
        Map<String, PositionEntity> this$positionIdMap = this.getPositionIdMap();
        Map<String, PositionEntity> other$positionIdMap = other.getPositionIdMap();
        if (this$positionIdMap == null ? other$positionIdMap != null : !((Object)this$positionIdMap).equals(other$positionIdMap)) {
            return false;
        }
        String this$defaultRoleId = this.getDefaultRoleId();
        String other$defaultRoleId = other.getDefaultRoleId();
        return !(this$defaultRoleId == null ? other$defaultRoleId != null : !this$defaultRoleId.equals(other$defaultRoleId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WxCpCorpValidateUtil;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SynThirdInfoService $synThirdInfoService = this.getSynThirdInfoService();
        result = result * 59 + ($synThirdInfoService == null ? 43 : $synThirdInfoService.hashCode());
        UserService $userService = this.getUserService();
        result = result * 59 + ($userService == null ? 43 : $userService.hashCode());
        OrganizeService $organizeService = this.getOrganizeService();
        result = result * 59 + ($organizeService == null ? 43 : $organizeService.hashCode());
        PositionService $positionService = this.getPositionService();
        result = result * 59 + ($positionService == null ? 43 : $positionService.hashCode());
        RoleService $roleService = this.getRoleService();
        result = result * 59 + ($roleService == null ? 43 : $roleService.hashCode());
        UserRelationService $userRelationService = this.getUserRelationService();
        result = result * 59 + ($userRelationService == null ? 43 : $userRelationService.hashCode());
        Map<String, SynThirdInfoEntity> $thirdCorpOrgMap = this.getThirdCorpOrgMap();
        result = result * 59 + ($thirdCorpOrgMap == null ? 43 : ((Object)$thirdCorpOrgMap).hashCode());
        Map<String, OrganizeEntity> $organizeMap = this.getOrganizeMap();
        result = result * 59 + ($organizeMap == null ? 43 : ((Object)$organizeMap).hashCode());
        Map<String, SynThirdInfoEntity> $thirdCorpUserMap = this.getThirdCorpUserMap();
        result = result * 59 + ($thirdCorpUserMap == null ? 43 : ((Object)$thirdCorpUserMap).hashCode());
        Map<String, UserEntity> $userIdMap = this.getUserIdMap();
        result = result * 59 + ($userIdMap == null ? 43 : ((Object)$userIdMap).hashCode());
        Map<String, UserEntity> $accountMap = this.getAccountMap();
        result = result * 59 + ($accountMap == null ? 43 : ((Object)$accountMap).hashCode());
        Map<String, UserEntity> $phoneMap = this.getPhoneMap();
        result = result * 59 + ($phoneMap == null ? 43 : ((Object)$phoneMap).hashCode());
        Map<String, UserEntity> $emailMap = this.getEmailMap();
        result = result * 59 + ($emailMap == null ? 43 : ((Object)$emailMap).hashCode());
        Map<String, PositionEntity> $positionIdMap = this.getPositionIdMap();
        result = result * 59 + ($positionIdMap == null ? 43 : ((Object)$positionIdMap).hashCode());
        String $defaultRoleId = this.getDefaultRoleId();
        result = result * 59 + ($defaultRoleId == null ? 43 : $defaultRoleId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WxCpCorpValidateUtil(synThirdInfoService=" + String.valueOf(this.getSynThirdInfoService()) + ", userService=" + String.valueOf(this.getUserService()) + ", organizeService=" + String.valueOf(this.getOrganizeService()) + ", positionService=" + String.valueOf(this.getPositionService()) + ", roleService=" + String.valueOf(this.getRoleService()) + ", userRelationService=" + String.valueOf(this.getUserRelationService()) + ", thirdCorpOrgMap=" + String.valueOf(this.getThirdCorpOrgMap()) + ", organizeMap=" + String.valueOf(this.getOrganizeMap()) + ", thirdCorpUserMap=" + String.valueOf(this.getThirdCorpUserMap()) + ", userIdMap=" + String.valueOf(this.getUserIdMap()) + ", accountMap=" + String.valueOf(this.getAccountMap()) + ", phoneMap=" + String.valueOf(this.getPhoneMap()) + ", emailMap=" + String.valueOf(this.getEmailMap()) + ", positionIdMap=" + String.valueOf(this.getPositionIdMap()) + ", defaultRoleId=" + this.getDefaultRoleId() + ")";
    }
}

