/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.message.service.impl;

import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.systemconfig.SysConfigCropModel;
import com.bringspring.common.model.login.BaseSystemInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.entity.SysConfigEntity;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.base.util.RegexUtils;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.model.message.DingTalkDeptModel;
import com.bringspring.system.message.model.message.DingTalkUserModel;
import com.bringspring.system.message.service.SynThirdDingTalkService;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.message.util.SynDingTalkUtil;
import com.bringspring.system.message.util.SynThirdConsts;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.PositionService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SynThirdDingTalkServiceImpl
implements SynThirdDingTalkService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private PositionService positionService;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private SynThirdInfoService synThirdInfoService;

    @Override
    public BaseSystemInfo getDingTalkConfig() {
        HashMap<String, String> objModel = new HashMap<String, String>();
        List<SysConfigEntity> configList = this.sysConfigService.getList();
        for (SysConfigEntity entity : configList) {
            objModel.put(entity.getKeyName(), entity.getKeyValue());
        }
        BaseSystemInfo baseSystemInfo = (BaseSystemInfo)JsonUtil.getJsonToBean(objModel, BaseSystemInfo.class);
        return baseSystemInfo;
    }

    public JSONObject checkDepartmentSysToDing(SynThirdInfoEntity synThirdInfoEntity) {
        JSONObject retMsg = new JSONObject();
        retMsg.put("code", (Object)true);
        retMsg.put("flag", (Object)"");
        retMsg.put("error", (Object)"");
        if (synThirdInfoEntity != null) {
            if ("".equals(String.valueOf(synThirdInfoEntity.getThirdObjectId())) || "null".equals(String.valueOf(synThirdInfoEntity.getThirdObjectId()))) {
                retMsg.put("code", (Object)false);
                retMsg.put("flag", (Object)"2");
                retMsg.put("error", (Object)"\u540c\u6b65\u8868\u4e2d\u90e8\u95e8\u5bf9\u5e94\u7684\u9489\u9489ID\u4e3a\u7a7a!");
            }
        } else {
            retMsg.put("code", (Object)false);
            retMsg.put("flag", (Object)"3");
            retMsg.put("error", (Object)"\u90e8\u95e8\u672a\u540c\u6b65\u5230\u9489\u9489!");
        }
        return retMsg;
    }

    public JSONObject checkDeptName(String deptName, String opType, SynThirdInfoEntity synThirdInfoEntity, Integer thirdType, Integer dataType, String sysObjId, String thirdObjId, String deptFlag) {
        JSONObject retMsg = new JSONObject();
        retMsg.put("code", (Object)true);
        retMsg.put("error", (Object)"");
        if (deptName.indexOf("-") > -1 || deptName.indexOf(",") > -1 || deptName.indexOf("\uff0c") > -1) {
            Integer synState = SynThirdConsts.SYN_STATE_FAIL;
            String description = deptFlag + "\u90e8\u95e8\u540d\u79f0\u4e0d\u80fd\u542b\u6709,\u3001\uff0c\u3001-\u4e09\u79cd\u7279\u6b8a\u5b57\u7b26";
            this.saveSynThirdInfoEntity(opType, synThirdInfoEntity, thirdType, dataType, sysObjId, thirdObjId, synState, description);
            retMsg.put("code", (Object)false);
            retMsg.put("error", (Object)description);
        }
        return retMsg;
    }

    public void saveSynThirdInfoEntity(String opType, SynThirdInfoEntity synThirdInfoEntity, Integer thirdType, Integer dataType, String sysObjId, String thirdObjId, Integer synState, String description) {
        UserInfo userInfo = this.userProvider.get();
        SynThirdInfoEntity entity = new SynThirdInfoEntity();
        String compValue = "add";
        if (compValue.equals(opType)) {
            entity.setId(RandomUtil.uuId());
            entity.setThirdType(thirdType);
            entity.setDataType(dataType);
            entity.setSystemObjectId(sysObjId);
            entity.setThirdObjectId(thirdObjId);
            entity.setSynState(synState);
            entity.setDescription(description);
            entity.setCreatorUserId(userInfo.getUserId());
            entity.setCreatorTime(DateUtil.getNowDate());
            entity.setLastModifyUserId(userInfo.getUserId());
            entity.setLastModifyTime(DateUtil.getNowDate());
            this.synThirdInfoService.create(entity);
        } else {
            entity = synThirdInfoEntity;
            entity.setThirdType(thirdType);
            entity.setDataType(dataType);
            entity.setThirdObjectId(thirdObjId);
            entity.setSynState(synState);
            entity.setDescription(description);
            entity.setLastModifyUserId(userInfo.getUserId());
            entity.setLastModifyTime(DateUtil.getNowDate());
            this.synThirdInfoService.update(entity.getId(), entity);
        }
    }

    @Override
    public JSONObject createDepartmentSysToDing(boolean isBatch, OrganizeEntity deptEntity, String accessToken) throws Exception {
        SynThirdInfoEntity synThirdInfoEntity;
        List<SynThirdInfoEntity> infoBySysObjIds;
        BaseSystemInfo config = this.getDingTalkConfig();
        String corpId = config.getDingSynAppKey();
        String corpSecret = config.getDingSynAppSecret();
        String compValue = "company";
        int dingIsSyn = isBatch ? 1 : config.getDingSynIsSynOrg();
        JSONObject tokenObject = new JSONObject();
        String access_token = "";
        JSONObject retMsg = new JSONObject();
        DingTalkDeptModel deptModel = new DingTalkDeptModel();
        String thirdObjId = "";
        Integer synState = 0;
        Object description = "";
        boolean isDeptDiff = true;
        String deptFlag = "\u521b\u5efa\uff1a";
        if (ObjectUtil.isEmpty((Object)accessToken)) {
            infoBySysObjIds = this.synThirdInfoService.getInfoBySysObjIds("2", "1", deptEntity.getParentId());
            if (ObjectUtil.isEmpty(infoBySysObjIds)) {
                return null;
            }
            synThirdInfoEntity = (SynThirdInfoEntity)infoBySysObjIds.stream().filter(v -> !ObjectUtil.isEmpty((Object)v.getSystemObjectId())).collect(Collectors.toList()).get(0);
            config.getDingCom();
            SysConfigEntity dingCom = this.sysConfigService.getConfigByKeyName("dingCom");
            List jsonToList = JsonUtil.getJsonToList((String)String.valueOf(dingCom.getKeyValue()), SysConfigCropModel.class);
            List collectCrop = jsonToList.stream().filter(v -> synThirdInfoEntity.getCropId().equals(v.getClientId())).collect(Collectors.toList());
            corpId = ((SysConfigCropModel)collectCrop.get(0)).getClientId();
            corpSecret = ((SysConfigCropModel)collectCrop.get(0)).getClientSecrent();
            accessToken = SynDingTalkUtil.getAccessToken(corpId, corpSecret).getString("access_token");
        }
        retMsg.put("code", (Object)true);
        retMsg.put("error", (Object)"\u521b\u5efa\uff1a\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65");
        if (dingIsSyn == 1) {
            if (isBatch) {
                access_token = accessToken;
            } else {
                tokenObject = SynDingTalkUtil.getAccessToken(corpId, corpSecret);
                access_token = tokenObject.getString("access_token");
            }
            if (access_token != null && !"".equals(access_token)) {
                deptModel.setDeptId(null);
                deptModel.setName(deptEntity.getFullName());
                if (compValue.equals(deptEntity.getCategory())) {
                    deptModel.setParentId(SynThirdConsts.DING_ROOT_DEPT_ID);
                } else {
                    infoBySysObjIds = this.synThirdInfoService.getInfoBySysObjIds("2", "1", deptEntity.getParentId());
                    synThirdInfoEntity = new SynThirdInfoEntity();
                    if (!ObjectUtil.isEmpty(infoBySysObjIds)) {
                        synThirdInfoEntity = (SynThirdInfoEntity)infoBySysObjIds.stream().filter(v -> !ObjectUtil.isEmpty((Object)v.getSystemObjectId())).collect(Collectors.toList()).get(0);
                    }
                    if (isDeptDiff = (retMsg = this.checkDepartmentSysToDing(synThirdInfoEntity)).getBoolean("code").booleanValue()) {
                        deptModel.setParentId(Long.parseLong(synThirdInfoEntity.getThirdObjectId()));
                    }
                }
                deptModel.setOrder(deptEntity.getSortCode());
                deptModel.setCreateDeptGroup(false);
                retMsg = this.checkDeptName(deptEntity.getFullName(), "add", null, Integer.parseInt("2"), Integer.parseInt("1"), deptEntity.getId(), thirdObjId, deptFlag);
                if (!retMsg.getBoolean("code").booleanValue()) {
                    return retMsg;
                }
                if (dingIsSyn == 1) {
                    retMsg = SynDingTalkUtil.createDepartment(deptModel, access_token);
                    if (retMsg.getBoolean("code").booleanValue()) {
                        thirdObjId = retMsg.getString("retDeptId");
                        retMsg.put("retDeptId", (Object)thirdObjId);
                        synState = SynThirdConsts.SYN_STATE_OK;
                    } else {
                        synState = SynThirdConsts.SYN_STATE_FAIL;
                        description = deptFlag + retMsg.getString("error");
                    }
                } else {
                    synState = SynThirdConsts.SYN_STATE_NO;
                    description = deptFlag + "\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65";
                    retMsg.put("code", (Object)true);
                    retMsg.put("error", description);
                    retMsg.put("retDeptId", (Object)"0");
                }
            } else {
                synState = SynThirdConsts.SYN_STATE_FAIL;
                description = deptFlag + "access_token\u503c\u4e3a\u7a7a,\u4e0d\u80fd\u540c\u6b65\u4fe1\u606f";
                retMsg.put("code", (Object)false);
                retMsg.put("error", description);
                retMsg.put("retDeptId", (Object)"0");
            }
        }
        this.saveSynThirdInfoEntity("add", null, Integer.parseInt("2"), Integer.parseInt("1"), deptEntity.getId(), thirdObjId, synState, (String)description);
        return retMsg;
    }

    @Override
    public JSONObject updateDepartmentSysToDing(boolean isBatch, OrganizeEntity deptEntity, String accessToken) throws Exception {
        BaseSystemInfo config = this.getDingTalkConfig();
        String corpId = config.getDingSynAppKey();
        String corpSecret = config.getDingSynAppSecret();
        if (ObjectUtil.isEmpty((Object)accessToken)) {
            SynThirdInfoEntity synThirdInfoEntity = (SynThirdInfoEntity)this.synThirdInfoService.getInfoBySysObjIds("2", "1", deptEntity.getId()).stream().filter(v -> !ObjectUtil.isEmpty((Object)v.getSystemObjectId())).collect(Collectors.toList()).get(0);
            config.getDingCom();
            SysConfigEntity dingCom = this.sysConfigService.getConfigByKeyName("dingCom");
            List jsonToList = JsonUtil.getJsonToList((String)String.valueOf(dingCom.getKeyValue()), SysConfigCropModel.class);
            List collectCrop = jsonToList.stream().filter(v -> synThirdInfoEntity.getCropId().equals(v.getClientId())).collect(Collectors.toList());
            corpId = ((SysConfigCropModel)collectCrop.get(0)).getClientId();
            corpSecret = ((SysConfigCropModel)collectCrop.get(0)).getClientSecrent();
            accessToken = SynDingTalkUtil.getAccessToken(corpId, corpSecret).getString("access_token");
        }
        String compValue = "company";
        int dingIsSyn = isBatch ? 1 : config.getDingSynIsSynOrg();
        JSONObject tokenObject = new JSONObject();
        String access_token = "";
        JSONObject retMsg = new JSONObject();
        DingTalkDeptModel deptModel = new DingTalkDeptModel();
        SynThirdInfoEntity synThirdInfoEntity = new SynThirdInfoEntity();
        String opType = "";
        Integer synState = 0;
        Object description = "";
        String thirdObjId = "";
        SynThirdInfoEntity synThirdInfoPara = new SynThirdInfoEntity();
        boolean isDeptDiff = true;
        String deptFlag = "\u66f4\u65b0\uff1a";
        retMsg.put("code", (Object)true);
        retMsg.put("error", (Object)"\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65");
        if (dingIsSyn == 1) {
            if (isBatch) {
                access_token = accessToken;
            } else {
                tokenObject = SynDingTalkUtil.getAccessToken(corpId, corpSecret);
                access_token = tokenObject.getString("access_token");
            }
            synThirdInfoEntity = (SynThirdInfoEntity)this.synThirdInfoService.getInfoBySysObjIds("2", "1", deptEntity.getId()).stream().filter(v -> !ObjectUtil.isEmpty((Object)v.getSystemObjectId())).collect(Collectors.toList()).get(0);
            if (access_token != null && !"".equals(access_token)) {
                deptModel.setDeptId(null);
                deptModel.setName(deptEntity.getFullName());
                if (compValue.equals(deptEntity.getCategory()) && "-1".equals(deptEntity.getParentId())) {
                    deptModel.setParentId(SynThirdConsts.DING_ROOT_DEPT_ID);
                } else {
                    synThirdInfoEntity = this.synThirdInfoService.getInfoBySysObjId("2", "1", deptEntity.getParentId());
                    retMsg = this.checkDepartmentSysToDing(synThirdInfoEntity);
                    isDeptDiff = retMsg.getBoolean("code");
                    if (isDeptDiff) {
                        deptModel.setParentId(Long.parseLong(synThirdInfoEntity.getThirdObjectId()));
                    }
                }
                deptModel.setOrder(deptEntity.getSortCode());
                synThirdInfoEntity = (SynThirdInfoEntity)this.synThirdInfoService.getInfoBySysObjIds("2", "1", deptEntity.getId()).stream().filter(v -> !ObjectUtil.isEmpty((Object)v.getSystemObjectId())).collect(Collectors.toList()).get(0);
                retMsg = this.checkDepartmentSysToDing(synThirdInfoEntity);
                if (!retMsg.getBoolean("code").booleanValue()) {
                    if ("3".equals(retMsg.getString("flag")) || "1".equals(retMsg.getString("flag"))) {
                        if ("1".equals(retMsg.getString("flag"))) {
                            this.synThirdInfoService.delete(synThirdInfoEntity);
                        }
                        opType = "add";
                        synThirdInfoPara = null;
                        thirdObjId = "";
                        retMsg = this.checkDeptName(deptEntity.getFullName(), opType, synThirdInfoPara, Integer.parseInt("2"), Integer.parseInt("1"), deptEntity.getId(), thirdObjId, deptFlag);
                        if (!retMsg.getBoolean("code").booleanValue()) {
                            return retMsg;
                        }
                        retMsg = SynDingTalkUtil.createDepartment(deptModel, access_token);
                        if (retMsg.getBoolean("code").booleanValue()) {
                            thirdObjId = retMsg.getString("retDeptId");
                            retMsg.put("retDeptId", (Object)thirdObjId);
                            synState = SynThirdConsts.SYN_STATE_OK;
                            description = "";
                        } else {
                            synState = SynThirdConsts.SYN_STATE_FAIL;
                            description = deptFlag + retMsg.getString("error");
                        }
                    }
                    if ("2".equals(retMsg.getString("flag"))) {
                        opType = "upd";
                        synThirdInfoPara = synThirdInfoEntity;
                        thirdObjId = "";
                        retMsg = this.checkDeptName(deptEntity.getFullName(), opType, synThirdInfoPara, Integer.parseInt("2"), Integer.parseInt("1"), deptEntity.getId(), thirdObjId, deptFlag);
                        if (!retMsg.getBoolean("code").booleanValue()) {
                            return retMsg;
                        }
                        retMsg = SynDingTalkUtil.createDepartment(deptModel, access_token);
                        if (retMsg.getBoolean("code").booleanValue()) {
                            thirdObjId = retMsg.getString("retDeptId");
                            retMsg.put("retDeptId", (Object)thirdObjId);
                            synState = SynThirdConsts.SYN_STATE_OK;
                            description = "";
                        } else {
                            synState = SynThirdConsts.SYN_STATE_FAIL;
                            description = deptFlag + retMsg.getString("error");
                        }
                    }
                } else {
                    SynThirdInfoEntity userThirdInfo;
                    opType = "upd";
                    synThirdInfoPara = synThirdInfoEntity;
                    thirdObjId = synThirdInfoEntity.getThirdObjectId();
                    retMsg = this.checkDeptName(deptEntity.getFullName(), opType, synThirdInfoPara, Integer.parseInt("2"), Integer.parseInt("1"), deptEntity.getId(), thirdObjId, deptFlag);
                    if (!retMsg.getBoolean("code").booleanValue()) {
                        return retMsg;
                    }
                    deptModel.setDeptId(Long.parseLong(synThirdInfoEntity.getThirdObjectId()));
                    if (StringUtils.isNotEmpty((String)deptEntity.getManagerId()) && (userThirdInfo = this.synThirdInfoService.getInfoBySysObjId("2", "2", deptEntity.getManagerId())) != null && StringUtils.isNotEmpty((String)userThirdInfo.getThirdObjectId())) {
                        deptModel.setDeptManagerUseridList(userThirdInfo.getThirdObjectId());
                    }
                    if ((retMsg = SynDingTalkUtil.updateDepartment(deptModel, access_token)).getBoolean("code").booleanValue()) {
                        synState = SynThirdConsts.SYN_STATE_OK;
                        description = "";
                    } else {
                        synState = SynThirdConsts.SYN_STATE_FAIL;
                        description = deptFlag + retMsg.getString("error");
                    }
                }
            } else {
                if (synThirdInfoEntity != null) {
                    opType = "upd";
                    synThirdInfoPara = synThirdInfoEntity;
                    thirdObjId = synThirdInfoEntity.getThirdObjectId();
                } else {
                    opType = "add";
                    synThirdInfoPara = null;
                    thirdObjId = "";
                }
                synState = SynThirdConsts.SYN_STATE_FAIL;
                description = deptFlag + "access_token\u503c\u4e3a\u7a7a,\u4e0d\u80fd\u540c\u6b65\u4fe1\u606f";
                retMsg.put("code", (Object)true);
                retMsg.put("error", description);
            }
        } else {
            synThirdInfoEntity = this.synThirdInfoService.getInfoBySysObjId("2", "1", deptEntity.getId());
            if (synThirdInfoEntity != null) {
                opType = "upd";
                synThirdInfoPara = synThirdInfoEntity;
                thirdObjId = synThirdInfoEntity.getThirdObjectId();
            } else {
                opType = "add";
                synThirdInfoPara = null;
                thirdObjId = "";
            }
            synState = SynThirdConsts.SYN_STATE_NO;
            description = deptFlag + "\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65";
            retMsg.put("code", (Object)true);
            retMsg.put("error", description);
        }
        this.saveSynThirdInfoEntity(opType, synThirdInfoPara, Integer.parseInt("2"), Integer.parseInt("1"), deptEntity.getId(), thirdObjId, synState, (String)description);
        return retMsg;
    }

    @Override
    public JSONObject deleteDepartmentSysToDing(boolean isBatch, String id, String accessToken) {
        BaseSystemInfo config = this.getDingTalkConfig();
        String corpId = config.getDingSynAppKey();
        String corpSecret = config.getDingSynAppSecret();
        int dingIsSyn = isBatch ? 1 : config.getDingSynIsSynOrg();
        JSONObject tokenObject = new JSONObject();
        String access_token = "";
        JSONObject retMsg = new JSONObject();
        SynThirdInfoEntity synThirdInfoEntity = this.synThirdInfoService.getInfoBySysObjId("2", "1", id);
        String deptFlag = "\u5220\u9664\uff1a";
        retMsg.put("code", (Object)true);
        retMsg.put("error", (Object)"\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65");
        if (synThirdInfoEntity != null) {
            if (dingIsSyn == 1) {
                if (isBatch) {
                    access_token = accessToken;
                } else {
                    tokenObject = SynDingTalkUtil.getAccessToken(corpId, corpSecret);
                    access_token = tokenObject.getString("access_token");
                }
                if (access_token != null && !"".equals(access_token)) {
                    if (!"".equals(String.valueOf(synThirdInfoEntity.getThirdObjectId())) && !"null".equals(String.valueOf(synThirdInfoEntity.getThirdObjectId()))) {
                        retMsg = SynDingTalkUtil.deleteDepartment(Long.parseLong(synThirdInfoEntity.getThirdObjectId()), access_token);
                        if (retMsg.getBoolean("code").booleanValue()) {
                            this.synThirdInfoService.delete(synThirdInfoEntity);
                        } else {
                            this.saveSynThirdInfoEntity("upd", synThirdInfoEntity, Integer.parseInt("2"), Integer.parseInt("1"), id, synThirdInfoEntity.getThirdObjectId(), SynThirdConsts.SYN_STATE_FAIL, deptFlag + retMsg.getString("error"));
                        }
                    } else {
                        this.synThirdInfoService.delete(synThirdInfoEntity);
                    }
                } else {
                    this.saveSynThirdInfoEntity("upd", synThirdInfoEntity, Integer.parseInt("2"), Integer.parseInt("1"), id, synThirdInfoEntity.getThirdObjectId(), SynThirdConsts.SYN_STATE_FAIL, deptFlag + "access_token\u503c\u4e3a\u7a7a,\u4e0d\u80fd\u540c\u6b65\u4fe1\u606f");
                    retMsg.put("code", (Object)false);
                    retMsg.put("error", (Object)(deptFlag + "access_token\u503c\u4e3a\u7a7a,\u4e0d\u80fd\u540c\u6b65\u4fe1\u606f\uff01"));
                }
            } else {
                this.saveSynThirdInfoEntity("upd", synThirdInfoEntity, Integer.parseInt("2"), Integer.parseInt("1"), id, synThirdInfoEntity.getThirdObjectId(), SynThirdConsts.SYN_STATE_NO, deptFlag + "\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65");
                retMsg.put("code", (Object)true);
                retMsg.put("error", (Object)(deptFlag + "\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65"));
            }
        }
        return retMsg;
    }

    public JSONObject setDingUserObject(UserEntity userEntity) throws ParseException {
        List<SynThirdInfoEntity> infoBySysObjIds1;
        DingTalkUserModel userModel = new DingTalkUserModel();
        JSONObject retMsg = new JSONObject();
        retMsg.put("code", (Object)true);
        retMsg.put("error", (Object)"");
        if (StringUtils.isNotEmpty((String)userEntity.getEmail()) && !Validator.isEmail((CharSequence)userEntity.getEmail())) {
            retMsg.put("code", (Object)false);
            retMsg.put("error", (Object)"\u90ae\u7bb1\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
            retMsg.put("dingUserObject", null);
            return retMsg;
        }
        if (StringUtils.isNotEmpty((String)userEntity.getMobilePhone()) && !RegexUtils.checkMobile(userEntity.getMobilePhone())) {
            retMsg.put("code", (Object)false);
            retMsg.put("error", (Object)"\u624b\u673a\u53f7\u4e0d\u5408\u6cd5\uff01");
            retMsg.put("dingUserObject", null);
            return retMsg;
        }
        userModel.setName(userEntity.getRealName());
        userModel.setMobile(userEntity.getMobilePhone());
        userModel.setTelephone(userEntity.getLandline());
        userModel.setJobNumber(userEntity.getAccount());
        PositionEntity positionEntity = this.positionService.getInfo(userEntity.getPositionId());
        String jobName = "";
        if (positionEntity != null) {
            jobName = positionEntity.getFullName();
            userModel.setTitle(jobName);
        }
        userModel.setWorkPlace(userEntity.getPostalAddress());
        if (userEntity.getEntryDate() != null) {
            String entryDate = DateUtil.daFormat((Date)userEntity.getEntryDate());
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            if (df.parse(entryDate).getTime() > 0L) {
                userModel.setHiredDate(df.parse(entryDate).getTime());
            }
        }
        List<SynThirdInfoEntity> infoBySysObjIds = this.synThirdInfoService.getInfoBySysObjIds("2", "1", userEntity.getOrganizeId());
        SynThirdInfoEntity synThirdInfoEntity = new SynThirdInfoEntity();
        if (!ObjectUtil.isEmpty(infoBySysObjIds)) {
            synThirdInfoEntity = (SynThirdInfoEntity)infoBySysObjIds.stream().filter(v -> !ObjectUtil.isEmpty((Object)v.getCropId())).collect(Collectors.toList()).get(0);
            retMsg = this.checkDepartmentSysToDing(synThirdInfoEntity);
        }
        if (!ObjectUtil.isEmpty(infoBySysObjIds1 = this.synThirdInfoService.getInfoBySysObjIds("2", "2", userEntity.getId()))) {
            SynThirdInfoEntity synThirdInfoUserEntity = (SynThirdInfoEntity)this.synThirdInfoService.getInfoBySysObjIds("2", "2", userEntity.getId()).stream().filter(v -> !ObjectUtil.isEmpty((Object)v.getCropId())).collect(Collectors.toList()).get(0);
            userModel.setUserid(synThirdInfoUserEntity.getThirdObjectId());
        }
        if (!retMsg.getBoolean("code").booleanValue()) {
            retMsg.put("code", (Object)false);
            retMsg.put("dingUserObject", null);
            return retMsg;
        }
        userModel.setDeptIdList(synThirdInfoEntity.getThirdObjectId());
        userModel.setEmail(userEntity.getEmail());
        retMsg.put("dingUserObject", (Object)userModel);
        return retMsg;
    }

    public JSONObject checkUserMobileEmailRepeat(String mobile, String email, String userId, List<DingTalkUserModel> dingUserList, String opType, SynThirdInfoEntity synThirdInfoEntity, Integer thirdType, Integer dataType, String sysObjId, String thirdObjId, String deptFlag) {
        boolean isDiff = true;
        Object description = "";
        JSONObject retMsg = new JSONObject();
        if (StringUtils.isNotEmpty((String)mobile)) {
            if (StringUtils.isNotEmpty((String)userId)) {
                if (dingUserList.stream().filter(t -> String.valueOf(t.getMobile()).equals(mobile) && !t.getUserid().equals(userId)).count() > 0L) {
                    isDiff = false;
                    description = deptFlag + "\u9489\u9489\u5185\u5df2\u6709\u7ed1\u5b9a\u624b\u673a\u53f7:" + mobile;
                }
            } else if (dingUserList.stream().filter(t -> String.valueOf(t.getMobile()).equals(mobile)).count() > 0L) {
                isDiff = false;
                description = deptFlag + "\u9489\u9489\u5185\u5df2\u6709\u7ed1\u5b9a\u624b\u673a\u53f7:" + mobile;
            }
        }
        if (StringUtils.isNotEmpty((String)email)) {
            if (StringUtils.isNotEmpty((String)userId)) {
                if (dingUserList.stream().filter(t -> String.valueOf(t.getEmail()).equals(email) && !t.getUserid().equals(userId)).count() > 0L) {
                    isDiff = false;
                    description = deptFlag + "\u9489\u9489\u5185\u5df2\u6709\u7ed1\u5b9a\u6b64\u90ae\u7bb1:" + email;
                }
            } else if (dingUserList.stream().filter(t -> String.valueOf(t.getEmail()).equals(email)).count() > 0L) {
                isDiff = false;
                description = deptFlag + "\u9489\u9489\u5185\u5df2\u6709\u7ed1\u5b9a\u6b64\u90ae\u7bb1:" + email;
            }
        }
        retMsg.put("code", (Object)isDiff);
        retMsg.put("error", description);
        if (!isDiff) {
            Integer synState = SynThirdConsts.SYN_STATE_FAIL;
            this.saveSynThirdInfoEntity(opType, synThirdInfoEntity, thirdType, dataType, sysObjId, thirdObjId, synState, (String)description);
        }
        return retMsg;
    }

    public JSONObject checkUserSysToDing(SynThirdInfoEntity synThirdInfoEntity) {
        JSONObject retMsg = new JSONObject();
        retMsg.put("code", (Object)true);
        retMsg.put("flag", (Object)"");
        retMsg.put("error", (Object)"");
        if (synThirdInfoEntity != null) {
            if ("".equals(String.valueOf(synThirdInfoEntity.getThirdObjectId())) || "null".equals(String.valueOf(synThirdInfoEntity.getThirdObjectId()))) {
                retMsg.put("code", (Object)false);
                retMsg.put("flag", (Object)"2");
                retMsg.put("error", (Object)"\u540c\u6b65\u8868\u4e2d\u7528\u6237\u5bf9\u5e94\u7684\u9489\u9489ID\u4e3a\u7a7a!");
            }
        } else {
            retMsg.put("code", (Object)false);
            retMsg.put("flag", (Object)"3");
            retMsg.put("error", (Object)"\u7528\u6237\u672a\u540c\u6b65!");
        }
        return retMsg;
    }

    @Override
    public JSONObject createUserSysToDing(boolean isBatch, UserEntity userEntity, String accessToken) throws Exception {
        BaseSystemInfo config = this.getDingTalkConfig();
        String corpId = config.getDingSynAppKey();
        String corpSecret = config.getDingSynAppSecret();
        int dingIsSyn = isBatch ? 1 : config.getDingSynIsSynUser();
        JSONObject tokenObject = new JSONObject();
        String access_token = "";
        JSONObject retMsg = new JSONObject();
        DingTalkUserModel userObjectModel = new DingTalkUserModel();
        String thirdObjId = "";
        Integer synState = 0;
        Object description = "";
        String userFlag = "\u521b\u5efa\uff1a";
        retMsg.put("code", (Object)true);
        retMsg.put("error", (Object)(userFlag + "\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65"));
        if (ObjectUtil.isEmpty((Object)accessToken)) {
            List<SynThirdInfoEntity> infoBySysObjIds = this.synThirdInfoService.getInfoBySysObjIds("2", "1", userEntity.getOrganizeId());
            if (ObjectUtil.isEmpty(infoBySysObjIds)) {
                return null;
            }
            SynThirdInfoEntity synThirdInfoEntity1 = (SynThirdInfoEntity)infoBySysObjIds.stream().filter(v -> !ObjectUtil.isEmpty((Object)v.getSystemObjectId())).collect(Collectors.toList()).get(0);
            config.getDingCom();
            SysConfigEntity dingCom = this.sysConfigService.getConfigByKeyName("dingCom");
            List jsonToList = JsonUtil.getJsonToList((String)String.valueOf(dingCom.getKeyValue()), SysConfigCropModel.class);
            List collectCrop = jsonToList.stream().filter(v -> synThirdInfoEntity1.getCropId().equals(v.getClientId())).collect(Collectors.toList());
            corpId = ((SysConfigCropModel)collectCrop.get(0)).getClientId();
            corpSecret = ((SysConfigCropModel)collectCrop.get(0)).getClientSecrent();
            accessToken = SynDingTalkUtil.getAccessToken(corpId, corpSecret).getString("access_token");
        }
        if (dingIsSyn == 1) {
            if (isBatch) {
                access_token = accessToken;
            } else {
                tokenObject = SynDingTalkUtil.getAccessToken(corpId, corpSecret);
                access_token = tokenObject.getString("access_token");
            }
            if (access_token != null && !"".equals(access_token)) {
                retMsg = this.setDingUserObject(userEntity);
                if (retMsg.getBoolean("code").booleanValue()) {
                    userObjectModel = (DingTalkUserModel)retMsg.getObject("dingUserObject", DingTalkUserModel.class);
                    if ((retMsg = SynDingTalkUtil.createUser(userObjectModel, access_token)).getBoolean("code").booleanValue()) {
                        thirdObjId = userEntity.getId();
                        synState = SynThirdConsts.SYN_STATE_OK;
                    } else {
                        synState = SynThirdConsts.SYN_STATE_FAIL;
                        description = userFlag + retMsg.getString("error");
                    }
                } else {
                    synState = SynThirdConsts.SYN_STATE_FAIL;
                    description = userFlag + retMsg.getString("error");
                }
            } else {
                synState = SynThirdConsts.SYN_STATE_FAIL;
                description = userFlag + "access_token\u503c\u4e3a\u7a7a,\u4e0d\u80fd\u540c\u6b65\u4fe1\u606f";
                retMsg.put("code", (Object)false);
                retMsg.put("error", description);
            }
        } else {
            synState = SynThirdConsts.SYN_STATE_NO;
            description = userFlag + "\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65";
            retMsg.put("code", (Object)true);
            retMsg.put("error", description);
        }
        this.saveSynThirdInfoEntity("add", null, Integer.parseInt("2"), Integer.parseInt("2"), userEntity.getId(), thirdObjId, synState, (String)description);
        return retMsg;
    }

    @Override
    public JSONObject updateUserSysToDing(boolean isBatch, UserEntity userEntity, String accessToken) throws Exception {
        BaseSystemInfo config = this.getDingTalkConfig();
        String corpId = config.getDingSynAppKey();
        String corpSecret = config.getDingSynAppSecret();
        int dingIsSyn = isBatch ? 1 : config.getDingSynIsSynUser();
        JSONObject tokenObject = new JSONObject();
        String access_token = "";
        JSONObject retMsg = new JSONObject();
        DingTalkUserModel userObjectModel = new DingTalkUserModel();
        SynThirdInfoEntity synThirdInfoEntity = new SynThirdInfoEntity();
        SynThirdInfoEntity entity = new SynThirdInfoEntity();
        String opType = "";
        SynThirdInfoEntity synThirdInfoPara = new SynThirdInfoEntity();
        String thirdObjId = "";
        Integer synState = 0;
        Object description = "";
        String userFlag = "\u66f4\u65b0\uff1a";
        if (ObjectUtil.isEmpty((Object)accessToken)) {
            SynThirdInfoEntity synThirdInfoEntity1 = (SynThirdInfoEntity)this.synThirdInfoService.getInfoBySysObjIds("2", "2", userEntity.getId()).stream().filter(v -> !ObjectUtil.isEmpty((Object)v.getSystemObjectId())).collect(Collectors.toList()).get(0);
            config.getDingCom();
            SysConfigEntity dingCom = this.sysConfigService.getConfigByKeyName("dingCom");
            List jsonToList = JsonUtil.getJsonToList((String)String.valueOf(dingCom.getKeyValue()), SysConfigCropModel.class);
            List collectCrop = jsonToList.stream().filter(v -> synThirdInfoEntity1.getCropId().equals(v.getClientId())).collect(Collectors.toList());
            corpId = ((SysConfigCropModel)collectCrop.get(0)).getClientId();
            corpSecret = ((SysConfigCropModel)collectCrop.get(0)).getClientSecrent();
            accessToken = SynDingTalkUtil.getAccessToken(corpId, corpSecret).getString("access_token");
        }
        retMsg.put("code", (Object)true);
        retMsg.put("error", (Object)(userFlag + "\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65"));
        if (dingIsSyn == 1) {
            if (isBatch) {
                access_token = accessToken;
            } else {
                tokenObject = SynDingTalkUtil.getAccessToken(corpId, corpSecret);
                access_token = tokenObject.getString("access_token");
            }
            synThirdInfoEntity = this.synThirdInfoService.getInfoBySysObjId("2", "2", userEntity.getId());
            if (access_token != null && !"".equals(access_token)) {
                retMsg = this.setDingUserObject(userEntity);
                if (retMsg.getBoolean("code").booleanValue()) {
                    userObjectModel = (DingTalkUserModel)retMsg.getObject("dingUserObject", DingTalkUserModel.class);
                    retMsg = this.checkUserSysToDing(synThirdInfoEntity);
                    if (!retMsg.getBoolean("code").booleanValue()) {
                        if ("3".equals(retMsg.getString("flag")) || "1".equals(retMsg.getString("flag"))) {
                            if ("1".equals(retMsg.getString("flag"))) {
                                this.synThirdInfoService.delete(synThirdInfoEntity);
                            }
                            opType = "add";
                            synThirdInfoPara = null;
                            thirdObjId = "";
                            retMsg = SynDingTalkUtil.createUser(userObjectModel, access_token);
                            if (retMsg.getBoolean("code").booleanValue()) {
                                thirdObjId = userEntity.getId();
                                synState = SynThirdConsts.SYN_STATE_OK;
                                description = "";
                            } else {
                                synState = SynThirdConsts.SYN_STATE_FAIL;
                                description = userFlag + retMsg.getString("error");
                            }
                        }
                        if ("2".equals(retMsg.getString("flag"))) {
                            opType = "upd";
                            synThirdInfoPara = synThirdInfoEntity;
                            thirdObjId = "";
                            retMsg = SynDingTalkUtil.createUser(userObjectModel, access_token);
                            if (retMsg.getBoolean("code").booleanValue()) {
                                thirdObjId = userEntity.getId();
                                synState = SynThirdConsts.SYN_STATE_OK;
                                description = "";
                            } else {
                                synState = SynThirdConsts.SYN_STATE_FAIL;
                                description = userFlag + retMsg.getString("error");
                            }
                        }
                    } else {
                        opType = "upd";
                        synThirdInfoPara = synThirdInfoEntity;
                        thirdObjId = synThirdInfoEntity.getThirdObjectId();
                        retMsg = SynDingTalkUtil.updateUser(userObjectModel, access_token);
                        if (retMsg.getBoolean("code").booleanValue()) {
                            synState = SynThirdConsts.SYN_STATE_OK;
                            description = "";
                        } else {
                            synState = SynThirdConsts.SYN_STATE_FAIL;
                            description = userFlag + retMsg.getString("error");
                        }
                    }
                } else {
                    if (synThirdInfoEntity != null) {
                        opType = "upd";
                        synThirdInfoPara = synThirdInfoEntity;
                        thirdObjId = synThirdInfoEntity.getThirdObjectId();
                    } else {
                        opType = "add";
                        synThirdInfoPara = null;
                        thirdObjId = "";
                    }
                    synState = SynThirdConsts.SYN_STATE_FAIL;
                    description = userFlag + retMsg.getString("error");
                    retMsg.put("code", (Object)false);
                    retMsg.put("error", description);
                }
            } else {
                if (synThirdInfoEntity != null) {
                    opType = "upd";
                    synThirdInfoPara = synThirdInfoEntity;
                    thirdObjId = synThirdInfoEntity.getThirdObjectId();
                } else {
                    opType = "add";
                    synThirdInfoPara = null;
                    thirdObjId = "";
                }
                synState = SynThirdConsts.SYN_STATE_FAIL;
                description = userFlag + "access_token\u503c\u4e3a\u7a7a,\u4e0d\u80fd\u540c\u6b65\u4fe1\u606f";
                retMsg.put("code", (Object)true);
                retMsg.put("error", description);
            }
        } else {
            synThirdInfoEntity = this.synThirdInfoService.getInfoBySysObjId("2", "2", userEntity.getId());
            if (synThirdInfoEntity != null) {
                opType = "upd";
                synThirdInfoPara = synThirdInfoEntity;
                thirdObjId = synThirdInfoEntity.getThirdObjectId();
            } else {
                opType = "add";
                synThirdInfoPara = null;
                thirdObjId = "";
            }
            synState = SynThirdConsts.SYN_STATE_NO;
            description = userFlag + "\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65";
            retMsg.put("code", (Object)true);
            retMsg.put("error", description);
        }
        this.saveSynThirdInfoEntity(opType, synThirdInfoPara, Integer.parseInt("2"), Integer.parseInt("2"), userEntity.getId(), thirdObjId, synState, (String)description);
        return retMsg;
    }

    @Override
    public JSONObject deleteUserSysToDing(boolean isBatch, String id, String accessToken) {
        BaseSystemInfo config = this.getDingTalkConfig();
        String corpId = config.getDingSynAppKey();
        String corpSecret = config.getDingSynAppSecret();
        int dingIsSyn = isBatch ? 1 : config.getDingSynIsSynUser();
        JSONObject tokenObject = new JSONObject();
        String access_token = "";
        JSONObject retMsg = new JSONObject();
        SynThirdInfoEntity synThirdInfoEntity = this.synThirdInfoService.getInfoBySysObjId("2", "2", id);
        retMsg.put("code", (Object)true);
        retMsg.put("error", (Object)"\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65");
        if (synThirdInfoEntity != null) {
            if (dingIsSyn == 1) {
                if (isBatch) {
                    access_token = accessToken;
                } else {
                    tokenObject = SynDingTalkUtil.getAccessToken(corpId, corpSecret);
                    access_token = tokenObject.getString("access_token");
                }
                if (access_token != null && !"".equals(access_token)) {
                    if (!"".equals(String.valueOf(synThirdInfoEntity.getThirdObjectId())) && !"null".equals(String.valueOf(synThirdInfoEntity.getThirdObjectId()))) {
                        retMsg = SynDingTalkUtil.deleteUser(synThirdInfoEntity.getThirdObjectId(), access_token);
                        if (retMsg.getBoolean("code").booleanValue()) {
                            this.synThirdInfoService.delete(synThirdInfoEntity);
                        } else {
                            this.saveSynThirdInfoEntity("upd", synThirdInfoEntity, Integer.parseInt("2"), Integer.parseInt("2"), id, synThirdInfoEntity.getThirdObjectId(), SynThirdConsts.SYN_STATE_FAIL, retMsg.getString("error"));
                        }
                    } else {
                        this.synThirdInfoService.delete(synThirdInfoEntity);
                    }
                } else {
                    this.saveSynThirdInfoEntity("upd", synThirdInfoEntity, Integer.parseInt("2"), Integer.parseInt("2"), id, synThirdInfoEntity.getThirdObjectId(), SynThirdConsts.SYN_STATE_FAIL, "access_token\u503c\u4e3a\u7a7a,\u4e0d\u80fd\u540c\u6b65\u4fe1\u606f");
                    retMsg.put("code", (Object)false);
                    retMsg.put("error", (Object)"access_token\u503c\u4e3a\u7a7a,\u4e0d\u80fd\u540c\u6b65\u4fe1\u606f\uff01");
                }
            } else {
                this.saveSynThirdInfoEntity("upd", synThirdInfoEntity, Integer.parseInt("2"), Integer.parseInt("2"), id, synThirdInfoEntity.getThirdObjectId(), SynThirdConsts.SYN_STATE_NO, "\u7cfb\u7edf\u672a\u8bbe\u7f6e\u540c\u6b65");
                retMsg.put("code", (Object)true);
                retMsg.put("error", (Object)"\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65");
            }
        }
        return retMsg;
    }
}

