/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.msgcenter.constant.Constants;
import com.bringspring.system.msgcenter.constant.DictType;
import com.bringspring.system.msgcenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgcenter.entity.McMsgSendEntity;
import com.bringspring.system.msgcenter.entity.McMsgSendTemplateEntity;
import com.bringspring.system.msgcenter.entity.McMsgTemplateEntity;
import com.bringspring.system.msgcenter.model.mcbusiness.McBusinessInfoVO;
import com.bringspring.system.msgcenter.model.mcmsgsend.McMsgSendCrForm;
import com.bringspring.system.msgcenter.model.mcmsgsend.McMsgSendInfoVO;
import com.bringspring.system.msgcenter.model.mcmsgsend.McMsgSendListVO;
import com.bringspring.system.msgcenter.model.mcmsgsend.McMsgSendPagination;
import com.bringspring.system.msgcenter.model.mcmsgsend.McMsgSendSelector;
import com.bringspring.system.msgcenter.model.mcmsgsend.McMsgSendUpForm;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.service.McBusinessService;
import com.bringspring.system.msgcenter.service.McMsgAccountService;
import com.bringspring.system.msgcenter.service.McMsgSendService;
import com.bringspring.system.msgcenter.service.McMsgSendTemplateService;
import com.bringspring.system.msgcenter.service.McMsgTemplateService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="\u6d88\u606f\u53d1\u9001\u914d\u7f6e\u8868")
@RequestMapping(value={"/api/msgCenter/mcMsgSend"})
public class McMsgSendController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(McMsgSendController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private McMsgSendService mcMsgSendService;
    @Autowired
    private McMsgSendTemplateService mcMsgSendTemplateService;
    @Autowired
    private McBusinessService mcBusinessService;
    @Autowired
    private McMsgTemplateService mcMsgTemplateService;
    @Autowired
    private McMsgAccountService mcMsgAccountService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody McMsgSendPagination mcMsgSendPagination) throws IOException {
        List<McMsgSendEntity> list = this.mcMsgSendService.getList(mcMsgSendPagination);
        List listVO = JsonUtil.getJsonToList(list, McMsgSendListVO.class);
        for (McMsgSendListVO vo : listVO) {
            vo.setTaskCode(this.baseDataUtil.getDictName(vo.getTaskCode(), DictType.TASK_CODE.getCode()));
            McBusinessInfoVO business = this.mcBusinessService.getInfoByEnCode(vo.getMessageSource());
            vo.setMessageSource(business != null ? business.getFullName() : null);
            vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
            vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
            vo.setDeleteUserId(this.baseDataUtil.userSelectValue(vo.getDeleteUserId()));
            List<McMsgSendTemplateEntity> sendTempList = this.mcMsgSendService.getMcMsgSendTemplateList(vo.getId(), 1);
            List modelList = JsonUtil.getJsonToList(sendTempList, McMsgSendTemplateModel.class);
            for (McMsgSendTemplateModel templateEntity : modelList) {
                templateEntity.setMessageTypeName(this.baseDataUtil.getDictName(templateEntity.getMessageType(), DictType.MSG_TYPE.getCode()));
            }
            vo.setSendTemplateList(modelList);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)mcMsgSendPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid McMsgSendCrForm mcMsgSendCrForm) throws DataException {
        if (StringUtils.isEmpty((String)mcMsgSendCrForm.getTaskCode())) {
            return ActionResult.fail((String)"taskCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)this.baseDataUtil.getDictName(mcMsgSendCrForm.getTaskCode(), DictType.TASK_CODE.getCode()))) {
            return ActionResult.fail((String)"\u65e0\u6548\u7684taskCode");
        }
        if (!this.mcMsgSendService.checkEnCodeUnique(mcMsgSendCrForm.getEnCode(), null)) {
            return ActionResult.fail((String)"\u7f16\u7801\u5df2\u5b58\u5728");
        }
        if (!this.mcMsgSendService.checkFullNameUnique(mcMsgSendCrForm.getFullName(), null)) {
            return ActionResult.fail((String)"\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (!this.mcMsgSendTemplateService.checkTemplateUnique(mcMsgSendCrForm.getSendTemplateList())) {
            return ActionResult.fail((String)"\u6a21\u677f+\u8d26\u53f7\u91cd\u590d");
        }
        this.mcMsgSendService.create(mcMsgSendCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<McMsgSendInfoVO> info(@PathVariable(value="id") String id) {
        McMsgSendInfoVO vo;
        McMsgSendEntity entity = this.mcMsgSendService.getInfo(id);
        McBusinessInfoVO business = this.mcBusinessService.getInfoByEnCode((vo = (McMsgSendInfoVO)JsonUtil.getJsonToBean((Object)entity, McMsgSendInfoVO.class)).getMessageSource());
        vo.setMessageSourceName(business != null ? business.getFullName() : null);
        List<McMsgSendTemplateEntity> mcMsgSendTemplateList = this.mcMsgSendService.getMcMsgSendTemplateList(id);
        List modelList = JsonUtil.getJsonToList(mcMsgSendTemplateList, McMsgSendTemplateModel.class);
        Iterator iterator = modelList.iterator();
        while (iterator.hasNext()) {
            McMsgSendTemplateModel templateEntity;
            McMsgTemplateEntity templateInfo = this.mcMsgTemplateService.getInfo((templateEntity = (McMsgSendTemplateModel)iterator.next()).getTemplateId());
            templateEntity.setTemplateName(templateInfo != null ? templateInfo.getFullName() : null);
            templateEntity.setTemplateEnCode(templateInfo != null ? templateInfo.getEnCode() : null);
            McMsgAccountEntity accountInfo = this.mcMsgAccountService.getInfo(templateEntity.getAccountConfigId());
            templateEntity.setAccountName(accountInfo != null ? accountInfo.getFullName() : null);
            templateEntity.setAccountEnCode(accountInfo != null ? accountInfo.getEnCode() : null);
            templateEntity.setMessageTypeName(this.baseDataUtil.getDictName(templateEntity.getMessageType(), DictType.MSG_TYPE.getCode()));
        }
        vo.setSendTemplateList(modelList);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/getInfoByEnCode/{enCode}"})
    public ActionResult<McMsgSendInfoVO> infoByEnCode(@PathVariable(value="enCode") String enCode) {
        McMsgSendEntity entity = this.mcMsgSendService.getEntityByEnCode(enCode);
        if (ObjectUtil.isNotNull((Object)entity)) {
            McMsgSendInfoVO vo;
            McBusinessInfoVO business = this.mcBusinessService.getInfoByEnCode((vo = (McMsgSendInfoVO)JsonUtil.getJsonToBean((Object)entity, McMsgSendInfoVO.class)).getMessageSource());
            vo.setMessageSourceName(business != null ? business.getFullName() : null);
            List<McMsgSendTemplateEntity> mcMsgSendTemplateList = this.mcMsgSendService.getMcMsgSendTemplateList(vo.getId());
            List modelList = JsonUtil.getJsonToList(mcMsgSendTemplateList, McMsgSendTemplateModel.class);
            Iterator iterator = modelList.iterator();
            while (iterator.hasNext()) {
                McMsgSendTemplateModel templateEntity;
                McMsgTemplateEntity templateInfo = this.mcMsgTemplateService.getInfo((templateEntity = (McMsgSendTemplateModel)iterator.next()).getTemplateId());
                templateEntity.setTemplateName(templateInfo != null ? templateInfo.getFullName() : null);
                templateEntity.setTemplateEnCode(templateInfo != null ? templateInfo.getEnCode() : null);
                McMsgAccountEntity accountInfo = this.mcMsgAccountService.getInfo(templateEntity.getAccountConfigId());
                templateEntity.setAccountName(accountInfo != null ? accountInfo.getFullName() : null);
                templateEntity.setAccountEnCode(accountInfo != null ? accountInfo.getEnCode() : null);
                templateEntity.setMessageTypeName(this.baseDataUtil.getDictName(templateEntity.getMessageType(), DictType.MSG_TYPE.getCode()));
            }
            vo.setSendTemplateList(modelList);
            return ActionResult.success((Object)vo);
        }
        return ActionResult.fail((String)"\u53d1\u9001\u914d\u7f6e[enCode]\u4e0d\u5b58\u5728");
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<McMsgSendInfoVO> detailInfo(@PathVariable(value="id") String id) {
        McMsgSendEntity entity = this.mcMsgSendService.getInfo(id);
        McMsgSendInfoVO vo = (McMsgSendInfoVO)JsonUtil.getJsonToBean((Object)entity, McMsgSendInfoVO.class);
        List<McMsgSendTemplateEntity> mcMsgSendTemplateList = this.mcMsgSendService.getMcMsgSendTemplateList(id);
        List mcMsgSendTemplateModelList = JsonUtil.getJsonToList(mcMsgSendTemplateList, McMsgSendTemplateModel.class);
        for (McMsgSendTemplateModel mcMsgSendTemplateModel : mcMsgSendTemplateModelList) {
        }
        vo.setSendTemplateList(mcMsgSendTemplateModelList);
        vo.setTaskCode(this.baseDataUtil.getDictName(vo.getTaskCode(), DictType.TASK_CODE.getCode()));
        McBusinessInfoVO business = this.mcBusinessService.getInfoByEnCode(vo.getMessageSource());
        vo.setMessageSource(business != null ? business.getFullName() : null);
        vo.setEnabledMark(this.baseDataUtil.switchSelectValue(vo.getEnabledMark(), Constants.EnableStatus.ENABLED.getDisplay(), Constants.EnableStatus.DISABLED.getDisplay()));
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        vo.setDeleteUserId(this.baseDataUtil.userSelectValue(vo.getDeleteUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid McMsgSendUpForm mcMsgSendUpForm) throws DataException {
        if (StringUtils.isEmpty((String)mcMsgSendUpForm.getTaskCode())) {
            return ActionResult.fail((String)"taskCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)this.baseDataUtil.getDictName(mcMsgSendUpForm.getTaskCode(), DictType.TASK_CODE.getCode()))) {
            return ActionResult.fail((String)"\u65e0\u6548\u7684taskCode");
        }
        if (!this.mcMsgSendService.checkEnCodeUnique(mcMsgSendUpForm.getEnCode(), id)) {
            return ActionResult.fail((String)"\u7f16\u7801\u5df2\u5b58\u5728");
        }
        if (!this.mcMsgSendService.checkFullNameUnique(mcMsgSendUpForm.getFullName(), id)) {
            return ActionResult.fail((String)"\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (!this.mcMsgSendTemplateService.checkTemplateUnique(mcMsgSendUpForm.getSendTemplateList())) {
            return ActionResult.fail((String)"\u6a21\u677f+\u8d26\u53f7\u91cd\u590d");
        }
        McMsgSendEntity entity = this.mcMsgSendService.getInfo(id);
        if (entity != null) {
            this.mcMsgSendService.update(id, mcMsgSendUpForm);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        McMsgSendEntity entity = this.mcMsgSendService.getInfo(id);
        if (entity != null) {
            this.mcMsgSendService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Operation(summary="\u53d1\u9001\u914d\u7f6e\u5206\u9875\u9009\u62e9\u6846")
    @GetMapping(value={"/Selector"})
    public ActionResult<PageListVO<McMsgSendSelector>> selector(McMsgSendPagination pagination) {
        List<McMsgSendEntity> list = this.mcMsgSendService.getList(pagination);
        List listSelector = JsonUtil.getJsonToList(list, McMsgSendSelector.class);
        if (CollectionUtil.isNotEmpty((Collection)listSelector)) {
            for (McMsgSendSelector selector : listSelector) {
                McBusinessInfoVO mcBusinessInfoVO = this.mcBusinessService.getInfoByEnCode(selector.getMessageSource());
                selector.setBusinessInfoVO(mcBusinessInfoVO);
            }
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        return ActionResult.page((List)listSelector, (PaginationVO)paginationVO);
    }
}

