/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.service.strategy.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.external.config.mutil.WxMpConfiguration;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.msgcenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgcenter.entity.McMsgTemplateEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgcenter.enums.EnabledMarkEnum;
import com.bringspring.system.msgcenter.enums.ToTypeEnum;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.model.mcwxtemplate.McWxSendResult;
import com.bringspring.system.msgcenter.service.context.SendMessageContext;
import com.bringspring.system.msgcenter.service.strategy.AbstractMessageSender;
import com.bringspring.system.msgcenter.util.BlacklistUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateData;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MsgToWxMpService
extends AbstractMessageSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MsgToWxMpService.class);
    private final WxMpConfiguration wxMpConfiguration;
    private WxMpService wxMpService;

    public MsgToWxMpService(WxMpConfiguration wxMpConfiguration) {
        this.wxMpConfiguration = wxMpConfiguration;
    }

    @Override
    protected int getBatchSize() {
        return 1000;
    }

    @Override
    public ChannelTypeEnum getChannelType() {
        return ChannelTypeEnum.WX_MP;
    }

    @Override
    protected void sendBatchNonSystemUser(boolean isAgain, McMsgSendTemplateModel sendTemplate, McTaskMsgContentEntity taskMsgContent, List<McTaskMsgReceiveEntity> receiveListS, UserInfo currentUserInfo) {
        if (ObjectUtil.isEmpty((Object)taskMsgContent) || CollectionUtil.isEmpty(receiveListS)) {
            log.error("~\u00b7~\u00b7~\u00b7~\u8c03\u7528\u4e86 \u5fae\u4fe1\u516c\u4f17\u53f7\u3010\u975e\u7cfb\u7edf\u7528\u6237\u3011\u6d88\u606f\u4e0b\u53d1\uff0c\u4f46message info\u4e3a\u7a7a \u6216 \u63a5\u6536\u4eba\u5217\u8868\u4e3a\u7a7a~\u00b7~\u00b7~\u00b7~");
        }
        List receiveList = JsonUtil.getJsonToList(receiveListS, McTaskMsgReceiveEntity.class);
        McMsgTemplateEntity templateInfo = this.mcMsgTemplateService.getInfo(sendTemplate.getTemplateId());
        McMsgAccountEntity msgAccount = this.mcMsgAccountService.getInfo(sendTemplate.getAccountConfigId());
        if (ObjectUtil.isNotNull((Object)templateInfo) && ObjectUtil.isNotNull((Object)msgAccount)) {
            List<String> openidList;
            String appId = msgAccount.getAppId();
            this.wxMpService = this.wxMpConfiguration.getWxMpService(appId);
            if (CollectionUtil.isNotEmpty((Collection)receiveList) && CollectionUtil.isNotEmpty(openidList = receiveList.stream().map(r -> r.getReceiveUserId()).collect(Collectors.toList()))) {
                Object errMsg;
                List<McWxSendResult> failList = this.postMessageSend(taskMsgContent, templateInfo, openidList);
                Object object = errMsg = isAgain ? "\u91cd\u53d1" : "\u4e0b\u53d1";
                if (CollectionUtil.isNotEmpty((Collection)receiveList)) {
                    errMsg = (String)errMsg + "\u6210\u529f";
                    this.mcTaskMsgReceiveService.updateByList(isAgain, receiveList, 1, (String)errMsg, currentUserInfo);
                }
                if (CollectionUtil.isNotEmpty(failList)) {
                    ArrayList updateBatch = new ArrayList();
                    for (McWxSendResult result : failList) {
                        Integer errCode = result.getErrCode();
                        String description = (String)errMsg + (errCode == 1 ? "\u6210\u529f\uff1a" : "\u5931\u8d25\uff1a") + result.getErrMsg();
                        String openid = result.getFailUser();
                        List receiveEntityList = receiveList.stream().filter(r -> openid.equals(r.getReceiveUserId())).collect(Collectors.toList());
                        if (!CollectionUtil.isNotEmpty(receiveEntityList)) continue;
                        for (McTaskMsgReceiveEntity receiveEntity : receiveEntityList) {
                            receiveEntity.setSendTime(new Date());
                            receiveEntity.setSendUserId(currentUserInfo.getUserId());
                            receiveEntity.setEnabledMark(errCode);
                            receiveEntity.setDescription(description);
                            if (ObjectUtil.isEmpty((Object)receiveEntity.getAutoAgainNum())) {
                                receiveEntity.setAutoAgainNum(0);
                                continue;
                            }
                            receiveEntity.setAutoAgainNum(receiveEntity.getAutoAgainNum() + 1);
                        }
                        updateBatch.addAll(receiveEntityList);
                    }
                    if (CollectionUtil.isNotEmpty(updateBatch)) {
                        this.mcTaskMsgReceiveService.updateBatchById(updateBatch);
                    }
                }
            }
        }
    }

    @Override
    protected void sendBatch(boolean isAgain, McMsgSendTemplateModel sendTemplate, McTaskMsgContentEntity taskMsgContent, List<McTaskMsgReceiveEntity> receiveListS, UserInfo currentUserInfo) {
        if (ObjectUtil.isEmpty((Object)taskMsgContent) || CollectionUtil.isEmpty(receiveListS)) {
            log.error("~\u00b7~\u00b7~\u00b7~\u8c03\u7528\u4e86 \u5fae\u4fe1\u516c\u4f17\u53f7\u6d88\u606f\u4e0b\u53d1\uff0c\u4f46message info\u4e3a\u7a7a \u6216 \u63a5\u6536\u4eba\u5217\u8868\u4e3a\u7a7a~\u00b7~\u00b7~\u00b7~");
        }
        List receiveList = JsonUtil.getJsonToList(receiveListS, McTaskMsgReceiveEntity.class);
        McMsgTemplateEntity templateInfo = this.mcMsgTemplateService.getInfo(sendTemplate.getTemplateId());
        McMsgAccountEntity msgAccount = this.mcMsgAccountService.getInfo(sendTemplate.getAccountConfigId());
        if (ObjectUtil.isNotNull((Object)templateInfo) && ObjectUtil.isNotNull((Object)msgAccount)) {
            String appId = msgAccount.getAppId();
            this.wxMpService = this.wxMpConfiguration.getWxMpService(appId);
            List<McTaskMsgReceiveEntity> receiveBlacklist = BlacklistUtil.receiveListFilter(receiveList);
            if (CollectionUtil.isNotEmpty((Collection)receiveList)) {
                List<McTaskMsgReceiveEntity> thirdNullList = receiveList.stream().filter(r -> StringUtils.isEmpty((String)r.getReceiveUserId())).collect(Collectors.toList());
                List thirdNotNullList = receiveList.stream().filter(r -> StringUtils.isNotEmpty((String)r.getReceiveUserId())).collect(Collectors.toList());
                List thirdInfoIds = thirdNotNullList.stream().map(r -> r.getReceiveUserId()).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(thirdInfoIds)) {
                    List<McWxSendResult> failList;
                    List thirdInfoList = this.synThirdInfoService.listByIds(thirdInfoIds);
                    List thirdUseridNullList = thirdInfoList.stream().filter(r -> StringUtils.isEmpty((String)r.getThirdObjectId())).collect(Collectors.toList());
                    List<McTaskMsgReceiveEntity> useridNullList = thirdNotNullList.stream().filter(r -> thirdUseridNullList.stream().map(e -> e.getId()).collect(Collectors.toList()).contains(r.getReceiveUserId())).collect(Collectors.toList());
                    List<SynThirdInfoEntity> thirdUseridNotNullList = thirdInfoList.stream().filter(r -> StringUtils.isNotEmpty((String)r.getThirdObjectId())).collect(Collectors.toList());
                    List<McTaskMsgReceiveEntity> useridNotNullList = thirdNotNullList.stream().filter(r -> thirdUseridNotNullList.stream().map(e -> e.getId()).collect(Collectors.toList()).contains(r.getReceiveUserId())).collect(Collectors.toList());
                    List<String> openidList = thirdUseridNotNullList.stream().map(r -> r.getThirdObjectId()).collect(Collectors.toList());
                    if (CollectionUtil.isNotEmpty(openidList) && CollectionUtil.isNotEmpty(failList = this.postMessageSend(taskMsgContent, templateInfo, openidList))) {
                        this.wxMpSendMessageResult(isAgain, taskMsgContent, useridNotNullList, thirdUseridNotNullList, failList, currentUserInfo);
                    }
                    if (CollectionUtil.isNotEmpty(useridNullList)) {
                        String errMsg = (isAgain ? "\u91cd\u53d1\u5931\u8d25\uff1a" : "\u4e0b\u53d1\u5931\u8d25\uff1a") + "third\u65e0userid";
                        this.mcTaskMsgReceiveService.updateByList(isAgain, useridNullList, 2, errMsg, currentUserInfo);
                    }
                }
                if (CollectionUtil.isNotEmpty(thirdNullList)) {
                    String errMsg = (isAgain ? "\u91cd\u53d1\u5931\u8d25\uff1a" : "\u4e0b\u53d1\u5931\u8d25\uff1a") + "\u65e0third\u7ed1\u5b9a\u6570\u636e";
                    this.mcTaskMsgReceiveService.updateByList(isAgain, thirdNullList, 2, errMsg, currentUserInfo);
                }
            }
            if (CollectionUtil.isNotEmpty(receiveBlacklist)) {
                this.mcTaskMsgReceiveService.updateBlacklist(receiveBlacklist, currentUserInfo);
            }
        }
    }

    @Override
    protected void doSend(SendMessageContext context) {
        if (CollectionUtil.isNotEmpty(context.getValidList())) {
            List<McTaskMsgReceiveEntity> receiveList = context.getValidList();
            McMsgAccountEntity account = context.getMsgAccount();
            String appId = account.getAppId();
            this.wxMpService = this.wxMpConfiguration.getWxMpService(appId);
            McMsgTemplateEntity templateInfo = context.getTemplateInfo();
            String templateCode = templateInfo.getTemplateCode();
            String wxSkip = templateInfo.getWxSkip();
            String xcxAppId = templateInfo.getXcxAppId();
            McTaskMsgContentEntity taskMsgContent = context.getTaskMsgContent();
            ArrayList<WxMpTemplateData> msgDataList = new ArrayList<WxMpTemplateData>();
            if (StringUtils.isNotEmpty((String)taskMsgContent.getContent())) {
                Map map = (Map)JSONObject.parseObject((String)taskMsgContent.getContent(), Map.class);
                for (Map.Entry entry : map.entrySet()) {
                    msgDataList.add(new WxMpTemplateData((String)entry.getKey(), (String)entry.getValue()));
                }
            }
            String toType = context.getToType();
            Map<String, SynThirdInfoEntity> thirdInfoMap = context.getThirdInfoMap();
            ArrayList<McTaskMsgReceiveEntity> validList = new ArrayList<McTaskMsgReceiveEntity>();
            ArrayList<McTaskMsgReceiveEntity> invalidList = new ArrayList<McTaskMsgReceiveEntity>();
            for (McTaskMsgReceiveEntity receiveEntity : receiveList) {
                WxMpTemplateMessage templateMessage;
                String opneid = receiveEntity.getReceiveUserId();
                if (!ToTypeEnum.NON_USER.getCode().equals(toType)) {
                    opneid = thirdInfoMap.get(opneid).getThirdObjectId();
                }
                if ("1".equals(wxSkip)) {
                    WxMpTemplateMessage.MiniProgram miniProgram = new WxMpTemplateMessage.MiniProgram();
                    miniProgram.setAppid(xcxAppId);
                    miniProgram.setPagePath(taskMsgContent.getLinkUrl());
                    templateMessage = WxMpTemplateMessage.builder().toUser(opneid).templateId(templateCode).data(msgDataList).miniProgram(miniProgram).clientMsgId(taskMsgContent.getMsgId()).build();
                } else {
                    templateMessage = WxMpTemplateMessage.builder().toUser(opneid).templateId(templateCode).data(msgDataList).url(taskMsgContent.getLinkUrl()).clientMsgId(taskMsgContent.getMsgId()).build();
                }
                try {
                    String msgid = this.wxMpService.getTemplateMsgService().sendTemplateMsg(templateMessage);
                    receiveEntity.setEnabledMark(EnabledMarkEnum.SUCCESS.getCode());
                    receiveEntity.setDescription(msgid);
                    validList.add(receiveEntity);
                }
                catch (WxErrorException e) {
                    e.printStackTrace();
                    receiveEntity.setEnabledMark(EnabledMarkEnum.FAIL.getCode());
                    receiveEntity.setDescription(e.getMessage());
                    invalidList.add(receiveEntity);
                }
            }
            context.getInvalidList().addAll(invalidList);
            context.setValidList(validList);
        }
    }

    @Override
    protected void validateParameters(SendMessageContext context) {
        this.validateTemplate(context);
        this.validateAccount(context);
    }

    public List<McWxSendResult> postMessageSend(McTaskMsgContentEntity taskMsgContent, McMsgTemplateEntity templateInfo, List<String> openidList) {
        if (ObjectUtil.isEmpty((Object)taskMsgContent) || ObjectUtil.isEmpty((Object)templateInfo) || CollectionUtil.isEmpty(openidList)) {
            log.error("~\u00b7~\u00b7~\u00b7~\u6267\u884c \u5fae\u4fe1\u516c\u4f17\u53f7\u5e94\u7528\u6d88\u606fpost\u4e0b\u53d1\uff0c\u4f46message info \u6216 templateInfo \u6216 openidList\u4e3a\u7a7a~\u00b7~\u00b7~\u00b7~");
        }
        String templateCode = templateInfo.getTemplateCode();
        String wxSkip = templateInfo.getWxSkip();
        String xcxAppId = templateInfo.getXcxAppId();
        ArrayList<WxMpTemplateData> msgDataList = new ArrayList<WxMpTemplateData>();
        if (StringUtils.isNotEmpty((String)taskMsgContent.getContent())) {
            Map map = (Map)JSONObject.parseObject((String)taskMsgContent.getContent(), Map.class);
            for (Map.Entry entry : map.entrySet()) {
                msgDataList.add(new WxMpTemplateData((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        ArrayList<McWxSendResult> failList = new ArrayList<McWxSendResult>();
        for (String string : openidList) {
            WxMpTemplateMessage templateMessage;
            if ("1".equals(wxSkip)) {
                WxMpTemplateMessage.MiniProgram miniProgram = new WxMpTemplateMessage.MiniProgram();
                miniProgram.setAppid(xcxAppId);
                miniProgram.setPagePath(taskMsgContent.getLinkUrl());
                templateMessage = WxMpTemplateMessage.builder().toUser(string).templateId(templateCode).data(msgDataList).miniProgram(miniProgram).clientMsgId(taskMsgContent.getMsgId()).build();
            } else {
                templateMessage = WxMpTemplateMessage.builder().toUser(string).templateId(templateCode).data(msgDataList).url(taskMsgContent.getLinkUrl()).clientMsgId(taskMsgContent.getMsgId()).build();
            }
            McWxSendResult mcWxSendResult = new McWxSendResult();
            try {
                String msgId = this.wxMpService.getTemplateMsgService().sendTemplateMsg(templateMessage);
                mcWxSendResult.setErrCode(1);
                mcWxSendResult.setFailUser(string);
                mcWxSendResult.setMsgId(msgId);
            }
            catch (WxErrorException e) {
                e.printStackTrace();
                mcWxSendResult.setErrCode(2);
                mcWxSendResult.setErrMsg(e.getMessage());
                mcWxSendResult.setFailUser(string);
            }
            failList.add(mcWxSendResult);
        }
        return failList;
    }

    public void wxMpSendMessageResult(boolean isAgain, McTaskMsgContentEntity taskMsgContent, List<McTaskMsgReceiveEntity> receiveList, List<SynThirdInfoEntity> thirdInfoList, List<McWxSendResult> failList, UserInfo currentUserInfo) {
        if (CollectionUtil.isNotEmpty(receiveList)) {
            String errMsg = isAgain ? "\u91cd\u53d1\u6210\u529f\uff1a" : "\u4e0b\u53d1\u6210\u529f\uff1a";
            this.mcTaskMsgReceiveService.updateByList(isAgain, receiveList, 1, errMsg, currentUserInfo);
        }
        if (CollectionUtil.isNotEmpty(failList)) {
            ArrayList updateBatch = new ArrayList();
            for (McWxSendResult result : failList) {
                List receiveEntityList;
                String errMsg = (StringUtils.isEmpty((String)result.getErrMsg()) ? "" : result.getErrMsg()) + result.getMsgId();
                String openid = result.getFailUser();
                List thirdInfo = thirdInfoList.stream().filter(r -> openid.equals(r.getThirdObjectId())).collect(Collectors.toList());
                if (!CollectionUtil.isNotEmpty(thirdInfo) || !CollectionUtil.isNotEmpty(receiveEntityList = receiveList.stream().filter(r -> thirdInfo.stream().map(e -> e.getId()).collect(Collectors.toList()).contains(r.getReceiveUserId())).collect(Collectors.toList()))) continue;
                if (!isAgain) {
                    receiveEntityList.stream().forEach(s -> {
                        s.setSendTime(new Date());
                        s.setSendUserId(currentUserInfo.getUserId());
                        s.setEnabledMark(result.getErrCode());
                        s.setDescription((result.getErrCode() == 1 ? "\u4e0b\u53d1\u6210\u529f\uff1a" : "\u4e0b\u53d1\u5931\u8d25\uff1a") + errMsg);
                        s.setAutoAgainNum(0);
                    });
                } else {
                    receiveEntityList.stream().forEach(s -> {
                        s.setAgainTime(new Date());
                        s.setAgainUserId(currentUserInfo.getUserId());
                        s.setEnabledMark(result.getErrCode());
                        s.setDescription((result.getErrCode() == 1 ? "\u91cd\u53d1\u6210\u529f\uff1a" : "\u91cd\u53d1\u5931\u8d25\uff1a") + errMsg);
                        if (ObjectUtil.isEmpty((Object)s.getAutoAgainNum())) {
                            s.setAutoAgainNum(0);
                        } else {
                            s.setAutoAgainNum(s.getAutoAgainNum() + 1);
                        }
                    });
                }
                updateBatch.addAll(receiveEntityList);
            }
            if (CollectionUtil.isNotEmpty(updateBatch)) {
                this.mcTaskMsgReceiveService.updateBatchById(updateBatch);
            }
        }
    }
}

