/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.service.strategy.impl;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.msgcenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgcenter.entity.McMsgTemplateEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.service.McMsgTemplateService;
import com.bringspring.system.msgcenter.service.context.TaskMsgReceiveMetadata;
import com.bringspring.system.msgcenter.service.strategy.AbstractMessageChannelStrategy;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WxQyWechatStrategy
extends AbstractMessageChannelStrategy {
    @Autowired
    private McMsgTemplateService mcMsgTemplateService;
    @Autowired
    private UserService userService;

    @Override
    public ChannelTypeEnum getChannelType() {
        return ChannelTypeEnum.QY_MSG;
    }

    @Override
    public void processMessage(McTaskMsgEntity taskMsg, McMsgSendTemplateModel sendTemplate, Map<String, McTaskMsgContentEntity> contentMap, Map<String, List<McTaskMsgReceiveEntity>> receiveMap, Set<String> userSet) {
        McTaskMsgContentEntity qyContent;
        String taskMsgId = taskMsg.getId();
        String templateId = sendTemplate.getId();
        String channelType = sendTemplate.getMessageType();
        String msgTemplateId = sendTemplate.getTemplateId();
        String msgAccountId = sendTemplate.getAccountConfigId();
        McMsgAccountEntity account = this.mcMsgAccountService.getInfo(sendTemplate.getAccountConfigId());
        McMsgTemplateEntity msgTemplate = this.mcMsgTemplateService.getInfo(sendTemplate.getTemplateId());
        String qyContentKey = channelType + msgTemplateId + msgAccountId;
        String qyReceiveKey = channelType + msgTemplateId;
        if (!contentMap.containsKey(qyContentKey)) {
            qyContent = this.getTaskMsgContent(templateId, channelType, taskMsg, msgTemplate, account);
            contentMap.put(qyContentKey, qyContent);
        } else {
            qyContent = contentMap.get(qyContentKey);
        }
        if ("4".equals(taskMsg.getToType())) {
            receiveMap.computeIfAbsent(qyContentKey, k -> this.packNonSystemReceive(userSet, taskMsgId, templateId, channelType, msgTemplateId, msgAccountId, qyContent.getId()));
        } else {
            List<UserEntity> receiveUsers = this.userService.getUserByIds(new ArrayList<String>(userSet));
            String isLinkedCorp = ObjectUtil.isEmpty((Object)account) ? null : account.getProgramState();
            String qyCrop = ObjectUtil.isEmpty((Object)account) ? null : account.getEnterpriseId();
            List<SynThirdInfoEntity> qyThirdList = this.synThirdInfoService.getThirdInfoList("1", "2", qyCrop, userSet, Boolean.parseBoolean(isLinkedCorp));
            List<McTaskMsgReceiveEntity> receiveList = null;
            if (receiveMap.containsKey(qyReceiveKey)) {
                receiveList = receiveMap.get(qyReceiveKey);
            }
            TaskMsgReceiveMetadata metadata = TaskMsgReceiveMetadata.builder().taskMsgId(taskMsgId).templateId(templateId).channelType(channelType).msgTemplateId(msgTemplateId).msgAccountId(msgAccountId).contentId(qyContent.getId()).build();
            List<McTaskMsgReceiveEntity> qyReceiveList = this.packThirdReceive(receiveUsers, qyThirdList, metadata, receiveList);
            receiveMap.put(qyReceiveKey, qyReceiveList);
        }
    }
}

