/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.system.permission.entity.BasePositionRelationEntity;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.model.basepositionrelation.BasePositionRelationInfoVO;
import com.bringspring.system.permission.model.basepositionrelation.BasePositionRelationListVO;
import com.bringspring.system.permission.model.basepositionrelation.BasePositionRelationPagination;
import com.bringspring.system.permission.model.basepositionrelation.BasePositionRelationPaginationExportModel;
import com.bringspring.system.permission.model.basepositionrelation.BasePositionRelationUpForm;
import com.bringspring.system.permission.model.organize.OrganizeDepartSelectorListVO;
import com.bringspring.system.permission.model.organize.OrganizeModel;
import com.bringspring.system.permission.service.BasePositionRelationService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.system.permission.util.PermissionUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="\u5c97\u4f4d\u5173\u7cfb", description="PositionRelation")
@RequestMapping(value={"/api/permission/PositionRelation"})
public class PositionRelationController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PositionRelationController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private BasePositionRelationService basePositionRelationService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private OrganizeService organizeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody BasePositionRelationPagination basePositionRelationPagination) throws IOException {
        List listOrg = this.organizeService.getList().stream().filter(t -> "1".equals(String.valueOf(t.getEnabledMark()))).collect(Collectors.toList());
        List<BasePositionRelationEntity> list = this.basePositionRelationService.getList(basePositionRelationPagination);
        List listVO = JsonUtil.getJsonToList(list, BasePositionRelationListVO.class);
        for (BasePositionRelationListVO basePositionRelationVO : listVO) {
            PositionEntity infoPosition;
            RoleEntity infoRole;
            if ("Role".equals(basePositionRelationVO.getObjectType()) && !ObjectUtil.isEmpty((Object)(infoRole = this.roleService.getInfo(basePositionRelationVO.getObjectId())))) {
                basePositionRelationVO.setObjectIdName(infoRole.getFullName());
                basePositionRelationVO.setEnCode(infoRole.getEnCode());
                basePositionRelationVO.setRoleType(infoRole.getType());
                basePositionRelationVO.setOrganizeInfo(infoRole.getEnCode());
            }
            if (ObjectUtil.isEmpty((Object)(infoPosition = this.positionService.getInfo(basePositionRelationVO.getPositionId())))) continue;
            OrganizeEntity entity = listOrg.stream().filter(t -> t.getId().equals(infoPosition.getOrganizeId())).findFirst().orElse(new OrganizeEntity());
            if (infoPosition.getOrganizeId().equals(entity.getId())) {
                basePositionRelationVO.setOrganizeInfo(entity.getFullName());
            }
            basePositionRelationVO.setOrganizeInfo(PermissionUtil.getLinkInfoByOrgId(infoPosition.getOrganizeId(), this.organizeService, false));
            basePositionRelationVO.setPositionName(infoPosition.getFullName());
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)basePositionRelationPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid BasePositionRelationUpForm basePositionRelationUpForm) throws DataException {
        String mainId = RandomUtil.uuId();
        if (!ObjectUtil.isEmpty(basePositionRelationUpForm.getObjectIdList())) {
            List<String> objectIdList = basePositionRelationUpForm.getObjectIdList();
            for (int i = 0; i < objectIdList.size(); ++i) {
                String v = objectIdList.get(i);
                BasePositionRelationEntity entitySave = new BasePositionRelationEntity();
                entitySave.setId(RandomUtil.uuId());
                entitySave.setPositionId(basePositionRelationUpForm.getPositionId());
                entitySave.setObjectType(basePositionRelationUpForm.getObjectType());
                entitySave.setObjectId(v);
                entitySave.setSortCode(Long.valueOf(i + 1));
                this.basePositionRelationService.save(entitySave);
            }
        }
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @Operation(summary="\u83b7\u53d6\u90e8\u95e8\u4e0b\u62c9\u6846\u5217\u8868")
    @GetMapping(value={"/UserDepartPosi/Selector/{menuId}"})
    public ActionResult<ListVO<OrganizeDepartSelectorListVO>> getListUserDepartment(@PathVariable(value="menuId") String menuId) {
        List<OrganizeEntity> list = this.organizeService.getOrganizeListDataPermission(menuId);
        List models = JsonUtil.getJsonToList(list, OrganizeModel.class);
        List<PositionEntity> listPosition = this.positionService.getList();
        ArrayList modelsPosition = new ArrayList();
        for (OrganizeModel model : models) {
            if ("department".equals(model.getType())) {
                model.setIcon("icon-ym icon-ym-tree-department1");
                continue;
            }
            if (!"company".equals(model.getType())) continue;
            model.setIcon("icon-ym icon-ym-tree-organization3");
        }
        listPosition.stream().forEach(v -> {
            OrganizeModel organizeModel = (OrganizeModel)((Object)((Object)JsonUtil.getJsonToBean((Object)v, OrganizeModel.class)));
            organizeModel.setParentId(v.getOrganizeId());
            organizeModel.setType("position");
            modelsPosition.add(organizeModel);
        });
        models.addAll(modelsPosition);
        List trees = TreeDotUtils.convertListToTreeDotFilter((List)models);
        List listVO = JsonUtil.getJsonToList((Object)trees, OrganizeDepartSelectorListVO.class);
        if (!CollectionUtil.isEmpty((Collection)listVO)) {
            Collections.sort(((OrganizeDepartSelectorListVO)listVO.get(0)).getChildren());
            if (!CollectionUtil.isEmpty(((OrganizeDepartSelectorListVO)listVO.get(0)).getChildren().get(0).getChildren())) {
                Collections.sort(((OrganizeDepartSelectorListVO)listVO.get(0)).getChildren().get(0).getChildren());
            }
        }
        ListVO vo = new ListVO();
        vo.setList(listVO);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(BasePositionRelationPaginationExportModel basePositionRelationPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)basePositionRelationPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        BasePositionRelationPagination basePositionRelationPagination = (BasePositionRelationPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)basePositionRelationPaginationExportModel), BasePositionRelationPagination.class));
        List<BasePositionRelationEntity> list = this.basePositionRelationService.getTypeList(basePositionRelationPagination, basePositionRelationPaginationExportModel.getDataType());
        for (BasePositionRelationEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, BasePositionRelationListVO.class);
        for (BasePositionRelationListVO basePositionRelationListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)basePositionRelationPaginationExportModel.getSelectKey()) ? basePositionRelationPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block18: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "positionId": {
                        entitys.add(new ExcelExportEntity("\u89d2\u8272\u4e3b\u952e", (Object)"positionId"));
                        continue block18;
                    }
                    case "objectType": {
                        entitys.add(new ExcelExportEntity("\u5bf9\u8c61\u7c7b\u578b\uff08\u89d2\u8272\uff1aRole\uff09", (Object)"objectType"));
                        continue block18;
                    }
                    case "objectId": {
                        entitys.add(new ExcelExportEntity("\u5bf9\u8c61\u4e3b\u952e", (Object)"objectId"));
                        continue block18;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @DeleteMapping(value={"/batchRemove/{ids}"})
    @Transactional
    public ActionResult batchRemove(@PathVariable(value="ids") String ids) {
        String[] idList = ids.split(",");
        int i = 0;
        for (String allId : idList) {
            this.delete(allId);
            ++i;
        }
        if (i == 0) {
            return ActionResult.fail((String)"\u5220\u9664\u5931\u8d25");
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<BasePositionRelationInfoVO> info(@PathVariable(value="id") String id) {
        BasePositionRelationEntity entity = this.basePositionRelationService.getInfo(id);
        BasePositionRelationInfoVO vo = (BasePositionRelationInfoVO)JsonUtil.getJsonToBean((Object)entity, BasePositionRelationInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/infoByPosition/{id}"})
    public ActionResult<BasePositionRelationInfoVO> infoByPosition(@PathVariable(value="id") String id) {
        List<BasePositionRelationEntity> entity = this.basePositionRelationService.infoByPosition(id);
        ArrayList<String> objectIdList = new ArrayList<String>();
        BasePositionRelationInfoVO vo = new BasePositionRelationInfoVO();
        entity.stream().forEach(v -> objectIdList.add(v.getObjectId()));
        vo.setId(id);
        vo.setPositionId(id);
        vo.setObjectIdList(objectIdList);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<BasePositionRelationInfoVO> detailInfo(@PathVariable(value="id") String id) {
        BasePositionRelationEntity entity = this.basePositionRelationService.getInfo(id);
        BasePositionRelationInfoVO vo = (BasePositionRelationInfoVO)JsonUtil.getJsonToBean((Object)entity, BasePositionRelationInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid BasePositionRelationUpForm basePositionRelationUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        List<BasePositionRelationEntity> entity = this.basePositionRelationService.infoByPosition(id);
        if (entity != null) {
            this.basePositionRelationService.deleteByPosition(basePositionRelationUpForm);
            if (!ObjectUtil.isEmpty(basePositionRelationUpForm.getObjectIdList())) {
                List<String> objectIdList = basePositionRelationUpForm.getObjectIdList();
                for (int i = 0; i < objectIdList.size(); ++i) {
                    String v = objectIdList.get(i);
                    BasePositionRelationEntity entitySave = new BasePositionRelationEntity();
                    entitySave.setId(RandomUtil.uuId());
                    entitySave.setPositionId(basePositionRelationUpForm.getPositionId());
                    entitySave.setObjectType(basePositionRelationUpForm.getObjectType());
                    entitySave.setObjectId(v);
                    entitySave.setSortCode(Long.valueOf(i + 1));
                    this.basePositionRelationService.save(entitySave);
                }
            }
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        BasePositionRelationEntity entity = this.basePositionRelationService.getInfo(id);
        if (entity != null) {
            this.basePositionRelationService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

