

package com.bringspring.system.base.controller;

import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.base.entity.BaseVersionEntity;
import com.bringspring.system.base.enums.BaseVersionSendMarkEnum;
import com.bringspring.system.base.model.baseversion.*;
import com.bringspring.system.base.service.BaseVersionService;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.RangeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 系统版本管理
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2025-01-13
 */
@Slf4j
@RestController
@Tag(name = "系统版本管理")
@RequestMapping("/api/logistics/BaseVersion")
public class BaseVersionController {

    @Autowired
    private BaseDataUtil baseDataUtil;


    @Autowired
    private UserProvider userProvider;

    @Autowired
    private BaseVersionService baseVersionService;

    @Autowired
    private RangeService rangeService;

    /**
     * 列表
     *
     * @param baseVersionPagination
     * @return
     */
    @PostMapping("/getList")
    public ActionResult list(@RequestBody BaseVersionPagination baseVersionPagination) throws IOException {
        List<BaseVersionEntity> list = baseVersionService.getList(baseVersionPagination);
        //处理id字段转名称，若无需转或者为空可删除
        List<BaseVersionListVO> listVO = JsonUtil.getJsonToList(list, BaseVersionListVO.class);
        for (BaseVersionListVO vo : listVO) {
            if("2".equals(vo.getSendType())){
                List<UserEntity> rangeUserList = rangeService.getRangeUserList(vo.getSendRange());
                String userNames = rangeUserList.stream().map(UserEntity::getRealName)
                        .collect(Collectors.joining(","));
                vo.setSendRangUsers(userNames);
            }
            vo.setIsSend(BaseVersionSendMarkEnum.getDescByCode(vo.getIsSend()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = JsonUtil.getJsonToBean(baseVersionPagination, PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success(vo);
    }


    /**
     * 创建
     *
     * @param baseVersionCrForm
     * @return
     */
    @PostMapping
    public ActionResult create(@RequestBody @Valid BaseVersionCrForm baseVersionCrForm) throws DataException {
        baseVersionService.create(baseVersionCrForm);
        return ActionResult.success("创建成功");
    }

    @GetMapping("/release/{id}")
    public ActionResult release(@PathVariable("id") String id) {
        return baseVersionService.release(id);
    }

    /**
     * 信息
     *
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    public ActionResult<BaseVersionInfoVO> info(@PathVariable("id") String id) {
        BaseVersionEntity entity = baseVersionService.getInfo(id);
        BaseVersionInfoVO vo = JsonUtil.getJsonToBean(entity, BaseVersionInfoVO.class);

        //子表
        //副表
        return ActionResult.success(vo);
    }

    /**
     * 表单信息(详情页)
     *
     * @param id
     * @return
     */
    @GetMapping("/detail/{id}")
    public ActionResult<BaseVersionInfoVO> detailInfo(@PathVariable("id") String id) {
        BaseVersionEntity entity = baseVersionService.getInfo(id);
        BaseVersionInfoVO vo = JsonUtil.getJsonToBean(entity, BaseVersionInfoVO.class);
        if("2".equals(vo.getSendType())){
            List<UserEntity> rangeUserList = rangeService.getRangeUserList(vo.getSendRange());
            String userNames = rangeUserList.stream().map(UserEntity::getRealName)
                    .collect(Collectors.joining(","));
            vo.setSendRangUsers(userNames);
        }
        vo.setIsSend(BaseVersionSendMarkEnum.getDescByCode(vo.getIsSend()));
        return ActionResult.success(vo);
    }

    @GetMapping("/info")
    public ActionResult<BaseVersionEntity> info() {
        BaseVersionEntity version = baseVersionService.getVersion();
        return ActionResult.success(version);
    }


    /**
     * 更新
     *
     * @param id
     * @return
     */
    @PutMapping("/{id}")
    public ActionResult update(@PathVariable("id") String id, @RequestBody @Valid BaseVersionUpForm baseVersionUpForm) throws DataException {
        baseVersionService.update(id, baseVersionUpForm);
        return ActionResult.success("更新成功");
    }


    /**
     * 删除
     *
     * @param id
     * @return
     */
    @DeleteMapping("/{id}")
    public ActionResult delete(@PathVariable("id") String id) {
        BaseVersionEntity entity = baseVersionService.getInfo(id);
        if (entity != null) {
            baseVersionService.delete(entity);

        }
        return ActionResult.success("删除成功");
    }


}
