package com.bringspring.system.base.model.dbtable;

import com.bringspring.common.database.model.DbTableFieldModel;
import com.bringspring.common.database.model.DbTableModel;
import com.bringspring.common.util.JsonUtil;
import lombok.Data;

import java.util.List;

/**
 * 建表参数对象
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/12 15:31
 */
@Data
public class DbTableCreate {

    /**
     * 数据库连接
     */
    private String dbLinkId;

    /**
     * 新表名
     */
    private String newTable;

    /**
     * 注释
     */
    private String tableComment;

    /**
     * 字段集合
     */
    private List<DbTableFieldModel> dbTableFieldModelList;

    /**
     * 表基本信息
     */
    private DbTableForm tableInfo;

    /**
     * 字段信息
     */
    private List<DbTableFieldForm> tableFieldList;

    /**
     * 初始化对象信息
     * @param dbLinkId 数据库连接ID
     */
    public String initCreate(String dbLinkId){
        this.dbLinkId = dbLinkId;
        DbTableModel dbTableModel = JsonUtil.getJsonToBean(this.getTableInfo(), DbTableModel.class);
        this.dbTableFieldModelList = JsonUtil.getJsonToList(this.getTableFieldList(), DbTableFieldModel.class);
        this.newTable = dbTableModel.getNewTable();
        this.tableComment = dbTableModel.getTableName();
        return dbTableModel.getTable();
    }

}
