package com.bringspring.system.base.model.messagetemplate;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 消息模板
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021-12-09
 */
@Data
public class MessageTemplateListVO implements Serializable {
    @Schema(description="主键")
    private String id;
    @Schema(description="消息类型")
    private String category;
    @Schema(description="模板名称")
    private String fullName;
    private String creatorUserId;
    private Date creatorTime;
    private Date lastModifyTime;

    /**
     * 通知方式
     */
    private String noticeMethod;

    /**
     * 标题
     */
    private String title;
    /**
     * 内容
     */
    private String content;
    /**
     * 有效标志
     */
    private Integer enabledMark;

    private String enCode;

    @JsonIgnore
    private Integer isStationLetter;
    @JsonIgnore
    private Integer isEmail;
    @JsonIgnore
    private Integer isWecom;
    @JsonIgnore
    private Integer isDingTalk;
    @JsonIgnore
    private Integer isSms;

}
