package com.bringspring.system.base.model.module;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.List;

/**
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/12 15:31
 */
@Data
public class MenuSelectAllVO {
    @Schema(description = "主键")
    private String id;
    @Schema(description = "是否有下级菜单")
    private Boolean hasChildren;
    @Schema(description = "上级ID")
    private String parentId;
    @Schema(description = "状态")
    private Integer enabledMark;
    @Schema(description = "菜单名称")
    private String fullName;
    @Schema(description = " 图标")
    private String icon;
    @Schema(description = "链接地址")
    private String urlAddress;

    /**
     * 菜单类型 0-系统、1-目录、2-页面、3-菜单、4-字典、5- reports、6-大屏、7-外链、8-门户、
     */
    @Schema(description = "菜单类型",example = "1")
    private Integer type;
    @Schema(description = "下级菜单列表")
    private List<MenuSelectAllVO> children;
    private Long sortCode;
    @Schema(description = "配置")
    private String propertyJson;

    private String linkTarget;
    private String enCode;
}
