package com.bringspring.system.base.service.impl;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.system.base.entity.DataInterfaceFormatEntity;
import com.bringspring.system.base.mapper.DataInterfaceFormatMapper;
import com.bringspring.system.base.model.datainterfaceformat.BaseDataInterfaceFormatPagination;
import com.bringspring.system.base.service.DataInterfaceFormatService;
import com.github.pagehelper.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

/**
 * 接口数据格式转换样例
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2024-08-15
 */
@Service
public class DataInterfaceFormatServiceImpl extends ServiceImpl<DataInterfaceFormatMapper, DataInterfaceFormatEntity> implements DataInterfaceFormatService {


    @Autowired
    private UserProvider userProvider;

    @Override
    public List<DataInterfaceFormatEntity> getList(BaseDataInterfaceFormatPagination baseDataInterfaceFormatPagination) {
        String userId = userProvider.get().getUserId();
        List<String> AllIdList = new ArrayList();
        int total = 0;
        int baseDataInterfaceFormatNum = 0;
        QueryWrapper<DataInterfaceFormatEntity> baseDataInterfaceFormatQueryWrapper = new QueryWrapper<>();
        if (StringUtil.isNotEmpty(baseDataInterfaceFormatPagination.getName())) {
            baseDataInterfaceFormatNum++;
            baseDataInterfaceFormatQueryWrapper.lambda().like(DataInterfaceFormatEntity::getName, baseDataInterfaceFormatPagination.getName());
        }

        if (AllIdList.size() > 0) {
            baseDataInterfaceFormatQueryWrapper.lambda().in(DataInterfaceFormatEntity::getId, AllIdList);
        }
        //排序
        if (StringUtil.isEmpty(baseDataInterfaceFormatPagination.getSidx())) {
            baseDataInterfaceFormatQueryWrapper.lambda().orderByAsc(DataInterfaceFormatEntity::getSortCode);
        } else {
            try {
                String sidx = baseDataInterfaceFormatPagination.getSidx();
                DataInterfaceFormatEntity baseDataInterfaceFormatEntity = new DataInterfaceFormatEntity();
                Field declaredField = baseDataInterfaceFormatEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                baseDataInterfaceFormatQueryWrapper = "asc".equals(baseDataInterfaceFormatPagination.getSort().toLowerCase()) ? baseDataInterfaceFormatQueryWrapper.orderByAsc(value) : baseDataInterfaceFormatQueryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ((total > 0 && AllIdList.size() > 0) || total == 0) {
            Page<DataInterfaceFormatEntity> page = new Page<>(baseDataInterfaceFormatPagination.getCurrentPage(), baseDataInterfaceFormatPagination.getPageSize());
            IPage<DataInterfaceFormatEntity> userIPage = this.page(page, baseDataInterfaceFormatQueryWrapper);
            return baseDataInterfaceFormatPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        } else {
            List<DataInterfaceFormatEntity> list = new ArrayList();
            return baseDataInterfaceFormatPagination.setData(list, list.size());
        }
    }

    @Override
    public List<DataInterfaceFormatEntity> getTypeList(BaseDataInterfaceFormatPagination baseDataInterfaceFormatPagination, String dataType) {
        String userId = userProvider.get().getUserId();
        List<String> AllIdList = new ArrayList();
        int total = 0;
        int baseDataInterfaceFormatNum = 0;
        QueryWrapper<DataInterfaceFormatEntity> baseDataInterfaceFormatQueryWrapper = new QueryWrapper<>();
        if (StringUtil.isNotEmpty(baseDataInterfaceFormatPagination.getName())) {
            baseDataInterfaceFormatNum++;
            baseDataInterfaceFormatQueryWrapper.lambda().like(DataInterfaceFormatEntity::getName, baseDataInterfaceFormatPagination.getName());
        }

        if (AllIdList.size() > 0) {
            baseDataInterfaceFormatQueryWrapper.lambda().in(DataInterfaceFormatEntity::getId, AllIdList);
        }
        //排序
        if (StringUtil.isEmpty(baseDataInterfaceFormatPagination.getSidx())) {
            baseDataInterfaceFormatQueryWrapper.lambda().orderByAsc(DataInterfaceFormatEntity::getName);
        } else {
            try {
                String sidx = baseDataInterfaceFormatPagination.getSidx();
                DataInterfaceFormatEntity baseDataInterfaceFormatEntity = new DataInterfaceFormatEntity();
                Field declaredField = baseDataInterfaceFormatEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                baseDataInterfaceFormatQueryWrapper = "asc".equals(baseDataInterfaceFormatPagination.getSort().toLowerCase()) ? baseDataInterfaceFormatQueryWrapper.orderByAsc(value) : baseDataInterfaceFormatQueryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if ((total > 0 && AllIdList.size() > 0) || total == 0) {
                Page<DataInterfaceFormatEntity> page = new Page<>(baseDataInterfaceFormatPagination.getCurrentPage(), baseDataInterfaceFormatPagination.getPageSize());
                IPage<DataInterfaceFormatEntity> userIPage = this.page(page, baseDataInterfaceFormatQueryWrapper);
                return baseDataInterfaceFormatPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            } else {
                List<DataInterfaceFormatEntity> list = new ArrayList();
                return baseDataInterfaceFormatPagination.setData(list, list.size());
            }
        } else {
            return this.list(baseDataInterfaceFormatQueryWrapper);
        }
    }

    @Override
    public DataInterfaceFormatEntity getInfo(String id) {
        QueryWrapper<DataInterfaceFormatEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(DataInterfaceFormatEntity::getId, id);
        return this.getOne(queryWrapper);
    }

    @Override
    public void create(DataInterfaceFormatEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, DataInterfaceFormatEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(DataInterfaceFormatEntity entity) {
        if (entity != null) {
            this.removeById(entity.getId());
        }
    }
    //子表方法

    //列表子表数据方法


}